/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;

public final class UserAgentUtil {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    public static final String DEFAULT_USER_AGENT_HEADER = "azsdk-java";
    private static final String PLATFORM_INFO_FORMAT = "%s; %s; %s";
    private static final int MAX_APP_ID_LENGTH = 24;

    private UserAgentUtil() {
    }

    public static String toUserAgentString(String string, String string2, String string3, Configuration configuration) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!CoreUtils.isNullOrEmpty(string)) {
            if (string.length() > 24) {
                throw new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH);
            }
            if (string.contains(" ")) {
                throw new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE);
            }
            stringBuilder.append(string).append(" ");
        }
        stringBuilder.append(DEFAULT_USER_AGENT_HEADER).append("-").append(string2).append("/").append(string3);
        if (!UserAgentUtil.isTelemetryDisabled(configuration)) {
            stringBuilder.append(" (").append(UserAgentUtil.getPlatformInfo()).append(")");
        }
        return stringBuilder.toString();
    }

    private static String getPlatformInfo() {
        String string = Configuration.getGlobalConfiguration().get("java.version");
        String string2 = Configuration.getGlobalConfiguration().get("os.name");
        String string3 = Configuration.getGlobalConfiguration().get("os.version");
        return String.format(PLATFORM_INFO_FORMAT, string, string2, string3);
    }

    private static boolean isTelemetryDisabled(Configuration configuration) {
        return configuration == null ? Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", false).booleanValue() : configuration.get("AZURE_TELEMETRY_DISABLED", false).booleanValue();
    }
}

