/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlTokenizerState;

class UrlTokenizer {
    private final String text;
    private final int textLength;
    private UrlTokenizerState state;
    private int currentIndex;
    private UrlToken currentToken;

    UrlTokenizer(String string) {
        this(string, UrlTokenizerState.SCHEME_OR_HOST);
    }

    UrlTokenizer(String string, UrlTokenizerState urlTokenizerState) {
        this.text = string;
        this.textLength = string == null ? 0 : string.length();
        this.state = urlTokenizerState;
        this.currentIndex = 0;
        this.currentToken = null;
    }

    private boolean hasCurrentCharacter() {
        return this.currentIndex < this.textLength;
    }

    private char currentCharacter() {
        return this.text.charAt(this.currentIndex);
    }

    private void nextCharacter() {
        if (this.hasCurrentCharacter()) {
            ++this.currentIndex;
        }
    }

    private boolean peekMatchesSchemeSeparator(boolean bl2) {
        if ("://".regionMatches(0, this.text, this.currentIndex, 3)) {
            if (bl2) {
                this.currentIndex += 3;
            }
            return true;
        }
        return false;
    }

    UrlToken current() {
        return this.currentToken;
    }

    boolean next() {
        if (!this.hasCurrentCharacter()) {
            this.currentToken = null;
        } else {
            switch (this.state) {
                case SCHEME: {
                    String string = this.readUntilNotLetterOrDigit();
                    this.currentToken = UrlToken.scheme(string);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    this.state = UrlTokenizerState.HOST;
                    break;
                }
                case SCHEME_OR_HOST: {
                    String string = this.readUntil(true);
                    if (!this.hasCurrentCharacter()) {
                        this.currentToken = UrlToken.host(string);
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    char c2 = this.currentCharacter();
                    if (c2 == ':') {
                        if (this.peekMatchesSchemeSeparator(false)) {
                            this.currentToken = UrlToken.scheme(string);
                            this.state = UrlTokenizerState.HOST;
                            break;
                        }
                        this.currentToken = UrlToken.host(string);
                        this.state = UrlTokenizerState.PORT;
                        break;
                    }
                    if (c2 == '/') {
                        this.currentToken = UrlToken.host(string);
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    if (c2 != '?') break;
                    this.currentToken = UrlToken.host(string);
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case HOST: {
                    this.peekMatchesSchemeSeparator(true);
                    String string = this.readUntil(true);
                    this.currentToken = UrlToken.host(string);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    char c3 = this.currentCharacter();
                    if (c3 == ':') {
                        this.state = UrlTokenizerState.PORT;
                        break;
                    }
                    if (c3 == '/') {
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case PORT: {
                    char c4 = this.currentCharacter();
                    if (c4 == ':') {
                        this.nextCharacter();
                    }
                    String string = this.readUntil(false);
                    this.currentToken = UrlToken.port(string);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    if (this.currentCharacter() == '/') {
                        this.state = UrlTokenizerState.PATH;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case PATH: {
                    String string;
                    int n2 = this.text.indexOf(63, this.currentIndex);
                    if (n2 == -1) {
                        string = this.text.substring(this.currentIndex);
                        this.currentIndex = this.textLength;
                    } else {
                        string = this.text.substring(this.currentIndex, n2);
                        this.currentIndex = n2;
                    }
                    this.currentToken = UrlToken.path(string);
                    if (!this.hasCurrentCharacter()) {
                        this.state = UrlTokenizerState.DONE;
                        break;
                    }
                    this.state = UrlTokenizerState.QUERY;
                    break;
                }
                case QUERY: {
                    if (this.currentCharacter() == '?') {
                        this.nextCharacter();
                    }
                    String string = this.readRemaining();
                    this.currentToken = UrlToken.query(string);
                    this.state = UrlTokenizerState.DONE;
                    break;
                }
            }
        }
        return this.currentToken != null;
    }

    private String readUntilNotLetterOrDigit() {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int n2 = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char c2 = this.currentCharacter();
            if (!Character.isLetterOrDigit(c2)) {
                return this.text.substring(n2, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(n2);
    }

    private String readUntil(boolean bl2) {
        if (!this.hasCurrentCharacter()) {
            return "";
        }
        int n2 = this.currentIndex;
        while (this.hasCurrentCharacter()) {
            char c2 = this.currentCharacter();
            if (bl2 && c2 == ':' || c2 == '/' || c2 == '?') {
                return this.text.substring(n2, this.currentIndex);
            }
            this.nextCharacter();
        }
        return this.text.substring(n2);
    }

    private String readRemaining() {
        String string = "";
        if (this.currentIndex < this.textLength) {
            string = this.text.substring(this.currentIndex, this.textLength);
            this.currentIndex = this.textLength;
        }
        return string;
    }
}

