/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationProperty;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationPropertyBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.metrics.MeterProvider;

public class MetricsOptions {
    private static final ConfigurationProperty<Boolean> IS_DISABLED_PROPERTY = ConfigurationPropertyBuilder.ofBoolean("metrics.disabled").environmentVariableName("AZURE_METRICS_DISABLED").shared(true).defaultValue(false).build();
    private static final ConfigurationProperty<String> PROVIDER_NAME_PROPERTY = ConfigurationPropertyBuilder.ofString("metrics.provider.implementation").environmentVariableName("AZURE_METRICS_IMPLEMENTATION").shared(true).build();
    private static final Configuration GLOBAL_CONFIG = Configuration.getGlobalConfiguration();
    private final Class<? extends MeterProvider> meterProvider;
    private boolean isEnabled;

    public MetricsOptions() {
        this(GLOBAL_CONFIG);
    }

    protected MetricsOptions(Class<? extends MeterProvider> clazz) {
        this.isEnabled = GLOBAL_CONFIG.get(IS_DISABLED_PROPERTY) == false;
        this.meterProvider = clazz;
    }

    private MetricsOptions(Configuration configuration) {
        this.isEnabled = configuration.get(IS_DISABLED_PROPERTY) == false;
        String string = configuration.get(PROVIDER_NAME_PROPERTY);
        this.meterProvider = string != null ? ImplUtils.getClassByName(string) : null;
    }

    public static MetricsOptions fromConfiguration(Configuration configuration) {
        if (configuration.contains(IS_DISABLED_PROPERTY)) {
            return new MetricsOptions().setEnabled(configuration.get(IS_DISABLED_PROPERTY) == false);
        }
        return new MetricsOptions();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public MetricsOptions setEnabled(boolean bl2) {
        this.isEnabled = bl2;
        return this;
    }

    public Class<? extends MeterProvider> getMeterProvider() {
        return this.meterProvider;
    }
}

