/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.ExponentialBackoffOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.PagedFlux;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AsynchronousByteChannelWriteSubscriber;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ByteBufferCollector;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.OutputStreamWriteSubscriber;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.RetriableDownloadFlux;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ProgressReporter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.io.IOUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscriber;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscription;
import macromedia.jdbc.sqlserver.externals.reactor.core.CoreSubscriber;
import macromedia.jdbc.sqlserver.externals.reactor.core.Exceptions;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.MonoSink;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Operators;
import macromedia.jdbc.sqlserver.externals.reactor.core.scheduler.Schedulers;
import macromedia.jdbc.sqlserver.externals.reactor.util.context.ContextView;

public final class FluxUtil {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final ClientLogger LOGGER = new ClientLogger(FluxUtil.class);
    private static final int DEFAULT_CHUNK_SIZE = 65536;

    public static boolean isFluxByteBuffer(Type type) {
        if (TypeUtil.isTypeOrSubTypeOf(type, Flux.class)) {
            Type type2 = TypeUtil.getTypeArguments(type)[0];
            return TypeUtil.isTypeOrSubTypeOf(type2, ByteBuffer.class);
        }
        return false;
    }

    public static Flux<ByteBuffer> addProgressReporting(Flux<ByteBuffer> flux, ProgressReporter progressReporter2) {
        if (progressReporter2 == null) {
            return flux;
        }
        return Mono.just((Object)progressReporter2).flatMapMany(progressReporter -> {
            progressReporter.reset();
            return flux.doOnNext(byteBuffer -> progressReporter.reportProgress(byteBuffer.remaining()));
        });
    }

    public static Mono<byte[]> collectBytesInByteBufferStream(Flux<ByteBuffer> flux) {
        return flux.collect(ByteBufferCollector::new, ByteBufferCollector::write).map(ByteBufferCollector::toByteArray);
    }

    public static Mono<byte[]> collectBytesInByteBufferStream(Flux<ByteBuffer> flux, int n2) {
        return flux.collect(() -> new ByteBufferCollector(n2), ByteBufferCollector::write).map(ByteBufferCollector::toByteArray);
    }

    public static Mono<byte[]> collectBytesFromNetworkResponse(Flux<ByteBuffer> flux, HttpHeaders httpHeaders) {
        Objects.requireNonNull(httpHeaders, "'headers' cannot be null.");
        String string = httpHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (string == null) {
            return FluxUtil.collectBytesInByteBufferStream(flux);
        }
        try {
            int n2 = Integer.parseInt(string);
            if (n2 > 0) {
                return FluxUtil.collectBytesInByteBufferStream(flux, n2);
            }
            return Mono.just((Object)EMPTY_BYTE_ARRAY);
        }
        catch (NumberFormatException numberFormatException) {
            return FluxUtil.collectBytesInByteBufferStream(flux);
        }
    }

    public static byte[] byteBufferToArray(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static Flux<ByteBuffer> createRetriableDownloadFlux(Supplier<Flux<ByteBuffer>> supplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> biFunction, int n2) {
        return FluxUtil.createRetriableDownloadFlux(supplier, biFunction, FluxUtil.createDefaultRetryOptions(n2), 0L);
    }

    public static Flux<ByteBuffer> createRetriableDownloadFlux(Supplier<Flux<ByteBuffer>> supplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> biFunction, int n2, long l2) {
        return FluxUtil.createRetriableDownloadFlux(supplier, biFunction, FluxUtil.createDefaultRetryOptions(n2), l2);
    }

    private static RetryOptions createDefaultRetryOptions(int n2) {
        return new RetryOptions(new ExponentialBackoffOptions().setMaxRetries(Math.max(0, n2)));
    }

    public static Flux<ByteBuffer> createRetriableDownloadFlux(Supplier<Flux<ByteBuffer>> supplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> biFunction, RetryOptions retryOptions, long l2) {
        RetryOptions retryOptions2 = retryOptions == null ? new RetryOptions(new ExponentialBackoffOptions()) : retryOptions;
        return new RetriableDownloadFlux(supplier, biFunction, retryOptions2, l2);
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream) {
        return FluxUtil.toFluxByteBuffer(inputStream, 4096);
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream, int n2) {
        if (n2 <= 0) {
            return Flux.error((Throwable)new IllegalArgumentException("'chunkSize' must be greater than 0."));
        }
        if (inputStream == null) {
            return Flux.empty();
        }
        if (inputStream instanceof FileInputStream && !System.getProperty("os.name").contains("Windows")) {
            FileChannel fileChannel2 = ((FileInputStream)inputStream).getChannel();
            return Flux.generate(() -> fileChannel2, (fileChannel, synchronousSink) -> {
                try {
                    long l2 = fileChannel.position();
                    long l3 = fileChannel.size();
                    if (l2 == l3) {
                        fileChannel.close();
                        synchronousSink.complete();
                    } else {
                        int n3 = (int)Math.min((long)n2, l3 - l2);
                        synchronousSink.next((Object)fileChannel.map(FileChannel.MapMode.READ_ONLY, l2, n3));
                        fileChannel.position(l2 + (long)n3);
                    }
                }
                catch (IOException iOException) {
                    synchronousSink.error((Throwable)iOException);
                }
                return fileChannel;
            });
        }
        return Flux.generate(() -> inputStream, (inputStream2, synchronousSink) -> {
            byte[] byArray = new byte[n2];
            try {
                int n3;
                for (int i2 = 0; i2 < n2; i2 += n3) {
                    n3 = inputStream.read(byArray, i2, n2 - i2);
                    if (n3 != -1) continue;
                    if (i2 > 0) {
                        synchronousSink.next((Object)ByteBuffer.wrap(byArray, 0, i2));
                    }
                    synchronousSink.complete();
                    return inputStream2;
                }
                synchronousSink.next((Object)ByteBuffer.wrap(byArray));
            }
            catch (IOException iOException) {
                synchronousSink.error((Throwable)iOException);
            }
            return inputStream2;
        }).filter(Buffer::hasRemaining);
    }

    public static <T> Mono<T> withContext(Function<Context, Mono<T>> function) {
        return FluxUtil.withContext(function, Collections.emptyMap());
    }

    public static <T> Mono<T> withContext(Function<Context, Mono<T>> function, Map<String, String> map) {
        return Mono.deferContextual(contextView -> {
            Context[] contextArray = new Context[]{Context.NONE};
            if (!CoreUtils.isNullOrEmpty(map)) {
                map.forEach((string, string2) -> {
                    contextArray[0] = contextArray[0].addData(string, string2);
                });
            }
            if (!contextView.isEmpty()) {
                contextView.stream().forEach(entry -> {
                    contextArray[0] = contextArray[0].addData(entry.getKey(), entry.getValue());
                });
            }
            return (Mono)function.apply(contextArray[0]);
        });
    }

    public static <T> Mono<T> toMono(Response<T> response) {
        return Mono.justOrEmpty(response.getValue());
    }

    public static <T> Mono<T> monoError(ClientLogger clientLogger, RuntimeException runtimeException) {
        return Mono.error((Throwable)clientLogger.logExceptionAsError(Exceptions.propagate((Throwable)runtimeException)));
    }

    public static <T> Mono<T> monoError(LoggingEventBuilder loggingEventBuilder, RuntimeException runtimeException) {
        return Mono.error((Throwable)loggingEventBuilder.log(Exceptions.propagate((Throwable)runtimeException)));
    }

    public static <T> Flux<T> fluxError(ClientLogger clientLogger, RuntimeException runtimeException) {
        return Flux.error((Throwable)clientLogger.logExceptionAsError(Exceptions.propagate((Throwable)runtimeException)));
    }

    public static <T> PagedFlux<T> pagedFluxError(ClientLogger clientLogger, RuntimeException runtimeException) {
        return new PagedFlux(() -> FluxUtil.monoError(clientLogger, runtimeException));
    }

    public static <T> Flux<T> fluxContext(Function<Context, Flux<T>> function) {
        return Flux.deferContextual(contextView -> (Publisher)function.apply(FluxUtil.toAzureContext(contextView)));
    }

    private static Context toAzureContext(ContextView contextView) {
        Context[] contextArray = new Context[]{Context.NONE};
        if (!contextView.isEmpty()) {
            contextView.stream().forEach(entry -> {
                contextArray[0] = contextArray[0].addData(entry.getKey(), entry.getValue());
            });
        }
        return contextArray[0];
    }

    public static macromedia.jdbc.sqlserver.externals.reactor.util.context.Context toReactorContext(Context context) {
        Context[] contextArray;
        if (context == null) {
            return macromedia.jdbc.sqlserver.externals.reactor.util.context.Context.empty();
        }
        macromedia.jdbc.sqlserver.externals.reactor.util.context.Context context2 = macromedia.jdbc.sqlserver.externals.reactor.util.context.Context.empty();
        for (Context context3 : contextArray = context.getContextChain()) {
            if (context3 == null || context3.getValue() == null) continue;
            context2 = context2.put(context3.getKey(), context3.getValue());
        }
        return context2;
    }

    public static Mono<Void> writeToOutputStream(Flux<ByteBuffer> flux, OutputStream outputStream) {
        if (flux == null && outputStream == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'stream' cannot be null."));
        }
        if (flux == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (outputStream == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'stream' cannot be null."));
        }
        return Mono.create(monoSink -> flux.subscribe((Subscriber)new OutputStreamWriteSubscriber((MonoSink<Void>)monoSink, outputStream, LOGGER)));
    }

    public static Mono<Void> writeFile(Flux<ByteBuffer> flux, AsynchronousFileChannel asynchronousFileChannel) {
        return FluxUtil.writeFile(flux, asynchronousFileChannel, 0L);
    }

    public static Mono<Void> writeFile(Flux<ByteBuffer> flux, AsynchronousFileChannel asynchronousFileChannel, long l2) {
        if (flux == null && asynchronousFileChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'outFile' cannot be null."));
        }
        if (flux == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (asynchronousFileChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'outFile' cannot be null."));
        }
        if (l2 < 0L) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalArgumentException("'position' cannot be less than 0."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(flux, IOUtils.toAsynchronousByteChannel(asynchronousFileChannel, l2));
    }

    public static Mono<Void> writeToAsynchronousByteChannel(Flux<ByteBuffer> flux, AsynchronousByteChannel asynchronousByteChannel) {
        if (flux == null && asynchronousByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'channel' cannot be null."));
        }
        if (flux == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (asynchronousByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return Mono.create(monoSink -> flux.subscribe((Subscriber)new AsynchronousByteChannelWriteSubscriber(asynchronousByteChannel, (MonoSink<Void>)monoSink)));
    }

    public static Mono<Void> writeToWritableByteChannel(Flux<ByteBuffer> flux, WritableByteChannel writableByteChannel) {
        if (flux == null && writableByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'channel' cannot be null."));
        }
        if (flux == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (writableByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return flux.publishOn(Schedulers.boundedElastic()).map(byteBuffer -> {
            try {
                ImplUtils.fullyWriteBuffer(byteBuffer, writableByteChannel);
            }
            catch (IOException iOException) {
                throw Exceptions.propagate((Throwable)iOException);
            }
            return byteBuffer;
        }).then();
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel asynchronousFileChannel, int n2, long l2, long l3) {
        return new FileReadFlux(asynchronousFileChannel, n2, l2, l3);
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel asynchronousFileChannel, long l2, long l3) {
        return FluxUtil.readFile(asynchronousFileChannel, 65536, l2, l3);
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel asynchronousFileChannel) {
        try {
            long l2 = asynchronousFileChannel.size();
            return FluxUtil.readFile(asynchronousFileChannel, 65536, 0L, l2);
        }
        catch (IOException iOException) {
            return Flux.error((Throwable)new RuntimeException("Failed to read the file.", iOException));
        }
    }

    private FluxUtil() {
    }

    private static final class FileReadFlux
    extends Flux<ByteBuffer> {
        private final AsynchronousFileChannel fileChannel;
        private final int chunkSize;
        private final long offset;
        private final long length;

        FileReadFlux(AsynchronousFileChannel asynchronousFileChannel, int n2, long l2, long l3) {
            this.fileChannel = asynchronousFileChannel;
            this.chunkSize = n2;
            this.offset = l2;
            this.length = l3;
        }

        public void subscribe(CoreSubscriber<? super ByteBuffer> coreSubscriber) {
            FileReadSubscription fileReadSubscription = new FileReadSubscription((Subscriber<? super ByteBuffer>)coreSubscriber, this.fileChannel, this.chunkSize, this.offset, this.length);
            coreSubscriber.onSubscribe((Subscription)fileReadSubscription);
        }

        static final class FileReadSubscription
        implements Subscription,
        CompletionHandler<Integer, ByteBuffer> {
            private static final int NOT_SET = -1;
            private static final long serialVersionUID = -6831808726875304256L;
            private final Subscriber<? super ByteBuffer> subscriber;
            private volatile long position;
            private final AsynchronousFileChannel fileChannel;
            private final int chunkSize;
            private final long offset;
            private final long length;
            private volatile boolean done;
            private Throwable error;
            private volatile ByteBuffer next;
            private volatile boolean cancelled;
            volatile int wip;
            static final AtomicIntegerFieldUpdater<FileReadSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(FileReadSubscription.class, "wip");
            volatile long requested;
            static final AtomicLongFieldUpdater<FileReadSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(FileReadSubscription.class, "requested");

            FileReadSubscription(Subscriber<? super ByteBuffer> subscriber, AsynchronousFileChannel asynchronousFileChannel, int n2, long l2, long l3) {
                this.subscriber = subscriber;
                this.fileChannel = asynchronousFileChannel;
                this.chunkSize = n2;
                this.offset = l2;
                this.length = l3;
                this.position = -1L;
            }

            @Override
            public void request(long l2) {
                if (Operators.validate((long)l2)) {
                    Operators.addCap(REQUESTED, (Object)this, (long)l2);
                    this.drain();
                }
            }

            @Override
            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void completed(Integer n2, ByteBuffer byteBuffer) {
                if (!this.cancelled) {
                    if (n2 == -1) {
                        this.done = true;
                    } else {
                        long l2;
                        long l3 = this.position;
                        int n3 = Math.min(n2, this.maxRequired(l3));
                        this.position = l2 = l3 + (long)n3;
                        byteBuffer.position(n3);
                        byteBuffer.flip();
                        this.next = byteBuffer;
                        if (l2 >= this.offset + this.length) {
                            this.done = true;
                        }
                    }
                    this.drain();
                }
            }

            @Override
            public void failed(Throwable throwable, ByteBuffer byteBuffer) {
                if (!this.cancelled) {
                    this.error = throwable;
                    this.done = true;
                    this.drain();
                }
            }

            private void drain() {
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                if (this.position == -1L) {
                    this.position = this.offset;
                    this.doRead();
                }
                int n2 = 1;
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (REQUESTED.get(this) <= 0L) continue;
                    boolean bl2 = false;
                    boolean bl3 = this.done;
                    ByteBuffer byteBuffer = this.next;
                    if (byteBuffer != null) {
                        this.next = null;
                        this.subscriber.onNext(byteBuffer);
                        bl2 = true;
                    }
                    if (bl3) {
                        if (this.error != null) {
                            this.subscriber.onError(this.error);
                        } else {
                            this.subscriber.onComplete();
                        }
                        return;
                    }
                    if (!bl2) continue;
                    Operators.produced(REQUESTED, (Object)this, (long)1L);
                    this.doRead();
                } while ((n2 = WIP.addAndGet(this, -n2)) != 0);
            }

            private void doRead() {
                long l2 = this.position;
                ByteBuffer byteBuffer = ByteBuffer.allocate(Math.min(this.chunkSize, this.maxRequired(l2)));
                this.fileChannel.read(byteBuffer, l2, byteBuffer, this);
            }

            private int maxRequired(long l2) {
                long l3 = this.offset + this.length - l2;
                if (l3 <= 0L) {
                    return 0;
                }
                int n2 = (int)l3;
                if (n2 < 0) {
                    return Integer.MAX_VALUE;
                }
                return n2;
            }
        }
    }
}

