/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonValue;

public abstract class ExpandableStringEnum<T extends ExpandableStringEnum<T>> {
    private static final Map<Class<?>, ReflectiveInvoker> CONSTRUCTORS = new ConcurrentHashMap();
    private static final Map<Class<?>, ConcurrentHashMap<String, ? extends ExpandableStringEnum<?>>> VALUES = new ConcurrentHashMap();
    private static final ClientLogger LOGGER = new ClientLogger(ExpandableStringEnum.class);
    private String name;
    private Class<T> clazz;

    @Deprecated
    public ExpandableStringEnum() {
    }

    protected static <T extends ExpandableStringEnum<T>> T fromString(String string, Class<T> clazz2) {
        ReflectiveInvoker reflectiveInvoker;
        if (string == null) {
            return null;
        }
        ConcurrentHashMap concurrentHashMap = VALUES.computeIfAbsent(clazz2, clazz -> new ConcurrentHashMap());
        ExpandableStringEnum expandableStringEnum = (ExpandableStringEnum)concurrentHashMap.get(string);
        if (expandableStringEnum != null) {
            return (T)expandableStringEnum;
        }
        if (CONSTRUCTORS.size() > 10000) {
            CONSTRUCTORS.clear();
        }
        if ((reflectiveInvoker = CONSTRUCTORS.computeIfAbsent(clazz2, ExpandableStringEnum::getDefaultConstructor)) == null) {
            return null;
        }
        try {
            expandableStringEnum = (ExpandableStringEnum)reflectiveInvoker.invokeWithArguments(null, new Object[0]);
        }
        catch (Exception exception) {
            LOGGER.log(LogLevel.WARNING, () -> "Failed to create " + clazz2.getName() + ", default constructor threw exception", exception);
            return null;
        }
        return (T)expandableStringEnum.nameAndAddValue(string, expandableStringEnum, clazz2);
    }

    private static <T> ReflectiveInvoker getDefaultConstructor(Class<T> clazz) {
        try {
            return ReflectionUtils.getConstructorInvoker(clazz, clazz.getDeclaredConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Can't find or access default constructor for " + clazz.getName() + ", make sure corresponding package is open to azure-core", reflectiveOperationException);
        }
        catch (Exception exception) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Failed to get default constructor for " + clazz.getName(), exception);
        }
        return null;
    }

    T nameAndAddValue(String string, T t2, Class<T> clazz) {
        this.name = string;
        this.clazz = clazz;
        VALUES.get(clazz).put(string, (ExpandableStringEnum<?>)t2);
        return (T)this;
    }

    protected static <T extends ExpandableStringEnum<T>> Collection<T> values(Class<T> clazz) {
        return new ArrayList(VALUES.getOrDefault(clazz, new ConcurrentHashMap()).values());
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.name);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.clazz == null || !this.clazz.isAssignableFrom(object.getClass())) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.name == null) {
            return ((ExpandableStringEnum)object).name == null;
        }
        return this.name.equals(((ExpandableStringEnum)object).name);
    }
}

