/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Collections;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.MetricsOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.TracingOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class ClientOptions {
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    private static final ClientLogger LOGGER = new ClientLogger(ClientOptions.class);
    private Iterable<Header> headers;
    private String applicationId;
    private MetricsOptions metricsOptions;
    private TracingOptions tracingOptions;

    public String getApplicationId() {
        return this.applicationId;
    }

    public ClientOptions setApplicationId(String string) {
        if (!CoreUtils.isNullOrEmpty(string)) {
            if (string.length() > 24) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
            }
            if (string.contains(" ")) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
            }
        }
        this.applicationId = string;
        return this;
    }

    public ClientOptions setHeaders(Iterable<Header> iterable) {
        this.headers = iterable;
        return this;
    }

    public Iterable<Header> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        return this.headers;
    }

    public ClientOptions setMetricsOptions(MetricsOptions metricsOptions) {
        this.metricsOptions = metricsOptions;
        return this;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public ClientOptions setTracingOptions(TracingOptions tracingOptions) {
        this.tracingOptions = tracingOptions;
        return this;
    }

    public TracingOptions getTracingOptions() {
        return this.tracingOptions;
    }
}

