/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.Option;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.JsonPatchOperationKind;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.JsonPatchOperationSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=JsonPatchOperationSerializer.class)
final class JsonPatchOperation
implements JsonSerializable<JsonPatchOperation> {
    private final JsonPatchOperationKind op;
    private final String from;
    private final String path;
    private final Option<String> value;

    JsonPatchOperation(JsonPatchOperationKind jsonPatchOperationKind, String string, String string2, Option<String> option) {
        this.op = jsonPatchOperationKind;
        this.from = string;
        this.path = string2;
        this.value = option;
    }

    JsonPatchOperationKind getOp() {
        return this.op;
    }

    String getFrom() {
        return this.from;
    }

    String getPath() {
        return this.path;
    }

    Option<String> getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.op.toString(), this.from, this.path, this.value == null ? null : this.value.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof JsonPatchOperation)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JsonPatchOperation jsonPatchOperation = (JsonPatchOperation)object;
        return Objects.equals((Object)this.op, (Object)jsonPatchOperation.op) && Objects.equals(this.from, jsonPatchOperation.from) && Objects.equals(this.path, jsonPatchOperation.path) && Objects.equals(this.value, jsonPatchOperation.value);
    }

    public String toString() {
        return this.buildString(new StringBuilder()).toString();
    }

    StringBuilder buildString(StringBuilder stringBuilder) {
        stringBuilder.append("{\"op\":\"").append(this.op.toString()).append("\"");
        if (this.from != null) {
            stringBuilder.append(",\"from\":\"").append(this.from).append("\"");
        }
        stringBuilder.append(",\"path\":\"").append(this.path).append("\"");
        if (this.value.isInitialized()) {
            stringBuilder.append(",\"value\":").append(this.value.getValue());
        }
        return stringBuilder.append("}");
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("op", this.op.toString()).writeStringField("from", this.from).writeStringField("path", this.path);
        if (this.value.isInitialized()) {
            String string = this.value.getValue();
            if (string == null) {
                jsonWriter.writeNullField("value");
            } else {
                jsonWriter.writeRawField("value", this.value.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static JsonPatchOperation fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            JsonPatchOperationKind jsonPatchOperationKind = null;
            String string = null;
            String string2 = null;
            Option<String> option = Option.uninitialized();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String string3 = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("op".equals(string3)) {
                    jsonPatchOperationKind = JsonPatchOperationKind.fromString(jsonReader.getString());
                    continue;
                }
                if ("from".equals(string3)) {
                    string = jsonReader.getString();
                    continue;
                }
                if ("path".equals(string3)) {
                    string2 = jsonReader.getString();
                    continue;
                }
                if ("value".equals(string3)) {
                    option = Option.of(jsonReader.getString());
                    continue;
                }
                jsonReader.skipChildren();
            }
            return new JsonPatchOperation(jsonPatchOperationKind, string, string2, option);
        });
    }
}

