/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.Option;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.JsonPatchOperation;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.JsonPatchOperationKind;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializerProviders;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonIgnore;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonValue;

public final class JsonPatchDocument
implements JsonSerializable<JsonPatchDocument> {
    private static final Object SERIALIZER_INSTANTIATION_SYNCHRONIZER = new Object();
    private static volatile JsonSerializer defaultSerializer;
    @JsonIgnore
    private final JsonSerializer serializer;
    @JsonValue
    private final List<JsonPatchOperation> operations = new ArrayList<JsonPatchOperation>();

    public JsonPatchDocument() {
        this(null);
    }

    public JsonPatchDocument(JsonSerializer jsonSerializer) {
        this.serializer = jsonSerializer;
    }

    List<JsonPatchOperation> getOperations() {
        return new ArrayList<JsonPatchOperation>(this.operations);
    }

    public JsonPatchDocument appendAdd(String string, Object object) {
        return this.appendAddInternal(string, this.serializeValue(object));
    }

    public JsonPatchDocument appendAddRaw(String string, String string2) {
        return this.appendAddInternal(string, Option.of(string2));
    }

    private JsonPatchDocument appendAddInternal(String string, Option<String> option) {
        Objects.requireNonNull(string, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.ADD, null, string, option);
    }

    public JsonPatchDocument appendReplace(String string, Object object) {
        return this.appendReplaceInternal(string, this.serializeValue(object));
    }

    public JsonPatchDocument appendReplaceRaw(String string, String string2) {
        return this.appendReplaceInternal(string, Option.of(string2));
    }

    private JsonPatchDocument appendReplaceInternal(String string, Option<String> option) {
        Objects.requireNonNull(string, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REPLACE, null, string, option);
    }

    public JsonPatchDocument appendCopy(String string, String string2) {
        Objects.requireNonNull(string, "'from' cannot be null.");
        Objects.requireNonNull(string2, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.COPY, string, string2, Option.uninitialized());
    }

    public JsonPatchDocument appendMove(String string, String string2) {
        Objects.requireNonNull(string, "'from' cannot be null.");
        Objects.requireNonNull(string2, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.MOVE, string, string2, Option.uninitialized());
    }

    public JsonPatchDocument appendRemove(String string) {
        Objects.requireNonNull(string, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.REMOVE, null, string, Option.uninitialized());
    }

    public JsonPatchDocument appendTest(String string, Object object) {
        return this.appendTestInternal(string, this.serializeValue(object));
    }

    public JsonPatchDocument appendTestRaw(String string, String string2) {
        return this.appendTestInternal(string, Option.of(string2));
    }

    private JsonPatchDocument appendTestInternal(String string, Option<String> option) {
        Objects.requireNonNull(string, "'path' cannot be null.");
        return this.appendOperation(JsonPatchOperationKind.TEST, null, string, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<String> serializeValue(Object object) {
        byte[] byArray;
        if (object == null) {
            return Option.empty();
        }
        if (this.serializer == null) {
            if (defaultSerializer == null) {
                Object object2 = SERIALIZER_INSTANTIATION_SYNCHRONIZER;
                synchronized (object2) {
                    if (defaultSerializer == null) {
                        defaultSerializer = JsonSerializerProviders.createInstance();
                    }
                }
            }
            byArray = defaultSerializer.serializeToBytes(object);
        } else {
            byArray = this.serializer.serializeToBytes(object);
        }
        return Option.of(new String(byArray, StandardCharsets.UTF_8));
    }

    private JsonPatchDocument appendOperation(JsonPatchOperationKind jsonPatchOperationKind, String string, String string2, Option<String> option) {
        this.operations.add(new JsonPatchOperation(jsonPatchOperationKind, string, string2, option));
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i2 = 0; i2 < this.operations.size(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            this.operations.get(i2).buildString(stringBuilder);
        }
        return stringBuilder.append("]").toString();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return CoreUtils.isNullOrEmpty(this.operations) ? jsonWriter : jsonWriter.writeArray(this.operations, JsonWriter::writeJson);
    }

    public static JsonPatchDocument fromJson(JsonReader jsonReader) throws IOException {
        List<JsonPatchOperation> list = jsonReader.readArray(JsonPatchOperation::fromJson);
        JsonPatchDocument jsonPatchDocument = new JsonPatchDocument();
        if (list != null) {
            jsonPatchDocument.operations.addAll(list);
        }
        return jsonPatchDocument;
    }
}

