/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoPosition
implements JsonSerializable<GeoPosition> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoPosition.class);
    private final double longitude;
    private final double latitude;
    private final Double altitude;

    public GeoPosition(double d2, double d3) {
        this(d2, d3, null);
    }

    public GeoPosition(double d2, double d3, Double d4) {
        this.longitude = d2;
        this.latitude = d3;
        this.altitude = d4;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public int count() {
        return this.altitude == null ? 2 : 3;
    }

    double get(int n2) {
        switch (n2) {
            case 0: {
                return this.longitude;
            }
            case 1: {
                return this.latitude;
            }
            case 2: {
                if (this.altitude == null) {
                    throw LOGGER.logExceptionAsError(new IndexOutOfBoundsException("Index out of range: " + n2));
                }
                return this.altitude;
            }
        }
        throw LOGGER.logExceptionAsError(new IndexOutOfBoundsException("Index out of range: " + n2));
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude, this.altitude);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeoPosition)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        GeoPosition geoPosition = (GeoPosition)object;
        return Double.compare(this.longitude, geoPosition.longitude) == 0 && Double.compare(this.latitude, geoPosition.latitude) == 0 && Objects.equals(this.altitude, geoPosition.altitude);
    }

    public String toString() {
        return this.altitude != null ? String.format("[%s, %s, %s]", this.longitude, this.latitude, this.altitude) : String.format("[%s, %s]", this.longitude, this.latitude);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartArray().writeDouble(this.longitude).writeDouble(this.latitude);
        if (this.altitude != null) {
            jsonWriter.writeDouble(this.altitude);
        }
        return jsonWriter.writeEndArray();
    }

    public static GeoPosition fromJson(JsonReader jsonReader2) throws IOException {
        List<Number> list = jsonReader2.readArray(jsonReader -> {
            if (jsonReader.currentToken() == JsonToken.NUMBER) {
                return jsonReader.getDouble();
            }
            return null;
        });
        if (list == null) {
            return null;
        }
        int n2 = list.size();
        if (n2 < 2 || n2 > 3) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 element coordinates supported."));
        }
        double d2 = list.get(0).doubleValue();
        double d3 = list.get(1).doubleValue();
        Double d4 = n2 == 3 ? Double.valueOf(list.get(2).doubleValue()) : null;
        return new GeoPosition(d2, d3, d4);
    }
}

