/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoArray;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLinearRing;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoPolygon
extends GeoObject {
    private final List<GeoLinearRing> rings;

    public GeoPolygon(GeoLinearRing geoLinearRing) {
        this(geoLinearRing, null, null);
    }

    public GeoPolygon(GeoLinearRing geoLinearRing, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        this(Collections.singletonList(Objects.requireNonNull(geoLinearRing, "'ring' cannot be null.")), geoBoundingBox, map);
    }

    public GeoPolygon(List<GeoLinearRing> list) {
        this(list, null, null);
    }

    public GeoPolygon(List<GeoLinearRing> list, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        Objects.requireNonNull(list, "'rings' cannot be null.");
        this.rings = Collections.unmodifiableList(new ArrayList<GeoLinearRing>(list));
    }

    public List<GeoLinearRing> getRings() {
        return this.rings;
    }

    public GeoLinearRing getOuterRing() {
        return this.rings.get(0);
    }

    GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.POLYGON;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rings, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoPolygon)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoPolygon geoPolygon = (GeoPolygon)object;
        return super.equals(object) && Objects.equals(this.rings, geoPolygon.rings);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.POLYGON.toString()).writeArrayField("coordinates", this.getRings(), JsonWriter::writeJson).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoPolygon fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            List<GeoLinearRing> list = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String string = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("type".equals(string)) {
                    String string2 = jsonReader.getString();
                    if (GeoObjectType.POLYGON.toString().equals(string2)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'Polygon'. The found 'type' was '" + string2 + "'.");
                }
                if ("coordinates".equals(string)) {
                    list = jsonReader.readArray(GeoLinearRing::fromJson);
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader.readUntyped());
            }
            return new GeoPolygon(list, geoBoundingBox, linkedHashMap);
        });
    }
}

