/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoArray;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPoint;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoPointCollection
extends GeoObject {
    private final List<GeoPoint> points;

    public GeoPointCollection(List<GeoPoint> list) {
        this(list, null, null);
    }

    public GeoPointCollection(List<GeoPoint> list, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        Objects.requireNonNull(list, "'points' cannot be null.");
        this.points = Collections.unmodifiableList(new ArrayList<GeoPoint>(list));
    }

    public List<GeoPoint> getPoints() {
        return this.points;
    }

    GeoArray<GeoPosition> getCoordinates() {
        return new GeoArray<GeoPosition>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_POINT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.points, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoPointCollection)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoPointCollection geoPointCollection = (GeoPointCollection)object;
        return super.equals(object) && Objects.equals(this.points, geoPointCollection.points);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter2) throws IOException {
        jsonWriter2.writeStartObject().writeStringField("type", GeoObjectType.MULTI_POINT.toString()).writeArrayField("coordinates", this.points, (jsonWriter, geoPoint) -> geoPoint.getCoordinates().toJson((JsonWriter)jsonWriter)).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter2).writeEndObject();
    }

    public static GeoPointCollection fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            ArrayList<GeoPoint> arrayList = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                Object object;
                String string = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("type".equals(string)) {
                    object = jsonReader.getString();
                    if (GeoObjectType.MULTI_POINT.toString().equals(object)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'MultiPoint'. The found 'type' was '" + (String)object + "'.");
                }
                if ("coordinates".equals(string)) {
                    object = jsonReader.readArray(GeoPosition::fromJson);
                    arrayList = new ArrayList<GeoPoint>(object.size());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        GeoPosition geoPosition = (GeoPosition)iterator.next();
                        arrayList.add(new GeoPoint(geoPosition));
                    }
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader.readUntyped());
            }
            return new GeoPointCollection(arrayList, geoBoundingBox, linkedHashMap);
        });
    }
}

