/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoArray;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoLineString
extends GeoObject {
    private final GeoArray<GeoPosition> coordinates;

    public GeoLineString(List<GeoPosition> list) {
        this(list, null, null);
    }

    public GeoLineString(List<GeoPosition> list, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        Objects.requireNonNull(list, "'positions' cannot be null.");
        this.coordinates = new GeoArray(new ArrayList<GeoPosition>(list));
    }

    public List<GeoPosition> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coordinates, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoLineString)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoLineString geoLineString = (GeoLineString)object;
        return super.equals(geoLineString) && Objects.equals(this.coordinates, geoLineString.coordinates);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.LINE_STRING.toString()).writeArrayField("coordinates", this.getCoordinates(), JsonWriter::writeJson).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoLineString fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            List<GeoPosition> list = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String string = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("type".equals(string)) {
                    String string2 = jsonReader.getString();
                    if (GeoObjectType.LINE_STRING.toString().equals(string2)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'LineString'. The found 'type' was '" + string2 + "'.");
                }
                if ("coordinates".equals(string)) {
                    list = jsonReader.readArray(GeoPosition::fromJson);
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader.readUntyped());
            }
            return new GeoLineString(list, geoBoundingBox, linkedHashMap);
        });
    }
}

