/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.CloudEventDataFormat;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProviders;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonAnyGetter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonAnySetter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonIgnore;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonRawValue;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public final class CloudEvent
implements JsonSerializable<CloudEvent> {
    private static final String SPEC_VERSION = "1.0";
    private static final ClientLogger LOGGER = new ClientLogger(CloudEvent.class);
    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("specversion", "id", "source", "type", "datacontenttype", "dataschema", "subject", "time", "data", "data_base64"));
    private static final String ILLEGAL_ATTRIBUTE_NAME_MESSAGE = "Extension attribute 'name' must have only lower-case alphanumeric characters and not be one of the CloudEvent reserved attribute names: " + String.join((CharSequence)", ", RESERVED_ATTRIBUTE_NAMES);
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="source", required=true)
    private String source;
    @JsonProperty(value="data")
    @JsonRawValue
    @JsonDeserialize(using=AnyToStringDeserializer.class)
    private String data;
    @JsonProperty(value="data_base64")
    private String dataBase64;
    @JsonProperty(value="type", required=true)
    private String type;
    @JsonProperty(value="time")
    private OffsetDateTime time;
    @JsonProperty(value="specversion", required=true)
    private String specVersion;
    @JsonProperty(value="dataschema")
    private String dataSchema;
    @JsonProperty(value="datacontenttype")
    private String dataContentType;
    @JsonProperty(value="subject")
    private String subject;
    @JsonIgnore
    private Map<String, Object> extensionAttributes;
    @JsonIgnore
    private BinaryData binaryData;

    public CloudEvent(String string, String string2, BinaryData binaryData, CloudEventDataFormat cloudEventDataFormat, String string3) {
        this.source = Objects.requireNonNull(string, "'source' cannot be null.");
        this.type = Objects.requireNonNull(string2, "'type' cannot be null.");
        if (binaryData != null) {
            Objects.requireNonNull(cloudEventDataFormat, "'format' cannot be null when 'data' isn't null.");
            if (CloudEventDataFormat.BYTES == cloudEventDataFormat) {
                this.dataBase64 = Base64.getEncoder().encodeToString(binaryData.toBytes());
            } else {
                try (JsonReader jsonReader = JsonProviders.createReader(binaryData.toBytes());){
                    JsonToken jsonToken = jsonReader.nextToken();
                    this.data = jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY ? jsonReader.readChildren() : (jsonToken == JsonToken.STRING ? "\"" + jsonReader.getString() + "\"" : jsonReader.getString());
                }
                catch (IOException iOException) {
                    throw LOGGER.logExceptionAsError(new IllegalArgumentException("'data' isn't in valid Json format", iOException));
                }
            }
        }
        this.dataContentType = string3;
        this.id = CoreUtils.randomUuid().toString();
        this.specVersion = SPEC_VERSION;
        this.binaryData = binaryData;
        this.time = OffsetDateTime.now(ZoneOffset.UTC);
    }

    private CloudEvent() {
    }

    public static List<CloudEvent> fromString(String string) {
        return CloudEvent.fromString(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CloudEvent> fromString(String string, boolean bl2) {
        ArrayList<CloudEvent> arrayList;
        Object object;
        Objects.requireNonNull(string, "'cloudEventsJson' cannot be null");
        try (JsonReader jsonReader = JsonProviders.createReader(string);){
            object = jsonReader.nextToken();
            if (object == JsonToken.START_OBJECT) {
                arrayList = new ArrayList<CloudEvent>(1);
                arrayList.add(jsonReader.readObject(CloudEvent::fromJson));
            } else {
                if (object != JsonToken.START_ARRAY) {
                    if (object != JsonToken.NULL) throw LOGGER.logExceptionAsError(new IllegalArgumentException("JSON string started at an invalid state for reading a single instance or an array of CloudEvents. Starting token was: " + object));
                    List<CloudEvent> list = null;
                    return list;
                }
                arrayList = jsonReader.readArray(CloudEvent::fromJson);
            }
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(iOException));
        }
        if (bl2) return arrayList;
        if (arrayList == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object = (CloudEvent)arrayList.get(n2);
            if (((CloudEvent)object).getId() == null || ((CloudEvent)object).getSource() == null || ((CloudEvent)object).getType() == null) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (((CloudEvent)object).getId() == null) {
                    arrayList2.add("'id'");
                }
                if (((CloudEvent)object).getSource() == null) {
                    arrayList2.add("'source'");
                }
                if (((CloudEvent)object).getType() != null) throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id', 'source' and 'type' are mandatory attributes for a CloudEvent according to the spec. This JSON string doesn't have " + CoreUtils.stringJoin(", ", arrayList2) + " for the object at index " + n2 + ". Please make sure the input Json string has the required attributes or use CloudEvent.fromString(cloudEventsJson, true) to skip the null check."));
                arrayList2.add("'type'");
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id', 'source' and 'type' are mandatory attributes for a CloudEvent according to the spec. This JSON string doesn't have " + CoreUtils.stringJoin(", ", arrayList2) + " for the object at index " + n2 + ". Please make sure the input Json string has the required attributes or use CloudEvent.fromString(cloudEventsJson, true) to skip the null check."));
            }
            ++n2;
        }
        return arrayList;
    }

    public String getId() {
        return this.id;
    }

    public CloudEvent setId(String string) {
        Objects.requireNonNull(string, "'id' cannot be null");
        if (string.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id' cannot be empty"));
        }
        this.id = string;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public BinaryData getData() {
        if (this.binaryData == null) {
            if (this.data != null) {
                this.binaryData = BinaryData.fromString(this.data);
            } else if (this.dataBase64 != null) {
                this.binaryData = BinaryData.fromBytes(Base64.getDecoder().decode(this.dataBase64));
            }
        }
        return this.binaryData;
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public CloudEvent setTime(OffsetDateTime offsetDateTime) {
        this.time = offsetDateTime;
        return this;
    }

    public String getDataContentType() {
        return this.dataContentType;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public CloudEvent setDataSchema(String string) {
        this.dataSchema = string;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CloudEvent setSubject(String string) {
        this.subject = string;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getExtensionAttributes() {
        return this.extensionAttributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.extensionAttributes);
    }

    @JsonAnySetter
    public CloudEvent addExtensionAttribute(String string, Object object) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        Objects.requireNonNull(object, "'value' cannot be null.");
        if (!CloudEvent.validateAttributeName(string)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(ILLEGAL_ATTRIBUTE_NAME_MESSAGE));
        }
        if (this.extensionAttributes == null) {
            this.extensionAttributes = new HashMap<String, Object>();
        }
        this.extensionAttributes.put(string, object);
        return this;
    }

    String getSpecVersion() {
        return this.specVersion;
    }

    CloudEvent setSpecVersion(String string) {
        this.specVersion = string;
        return this;
    }

    private static boolean validateAttributeName(String string) {
        if (RESERVED_ATTRIBUTE_NAMES.contains(string)) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("id", this.id).writeStringField("source", this.source);
        if (this.dataBase64 != null) {
            jsonWriter.writeStringField("data_base64", this.dataBase64);
        } else if (this.data != null) {
            jsonWriter.writeRawField("data", this.data);
        } else {
            jsonWriter.writeNullField("data");
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.time != null) {
            jsonWriter.writeStringField("time", this.time.toString());
        }
        jsonWriter.writeStringField("specversion", this.specVersion).writeStringField("dataschema", this.dataSchema).writeStringField("datacontenttype", this.dataContentType).writeStringField("subject", this.subject);
        if (!CoreUtils.isNullOrEmpty(this.extensionAttributes)) {
            for (Map.Entry<String, Object> entry : this.extensionAttributes.entrySet()) {
                jsonWriter.writeUntypedField(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CloudEvent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(jsonReader3 -> {
            CloudEvent cloudEvent = new CloudEvent();
            while (jsonReader3.nextToken() != JsonToken.END_OBJECT) {
                String string = jsonReader3.getFieldName();
                JsonToken jsonToken = jsonReader3.nextToken();
                if ("id".equals(string)) {
                    cloudEvent.id = jsonReader3.getString();
                    continue;
                }
                if ("source".equals(string)) {
                    cloudEvent.source = jsonReader3.getString();
                    continue;
                }
                if ("data".equals(string)) {
                    if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY) {
                        cloudEvent.data = jsonReader.readChildren();
                        continue;
                    }
                    if (jsonToken == JsonToken.STRING) {
                        cloudEvent.data = "\"" + jsonReader.getRawText() + "\"";
                        continue;
                    }
                    cloudEvent.data = jsonReader.getString();
                    continue;
                }
                if ("data_base64".equals(string)) {
                    cloudEvent.dataBase64 = jsonReader3.getString();
                    continue;
                }
                if ("type".equals(string)) {
                    cloudEvent.type = jsonReader3.getString();
                    continue;
                }
                if ("time".equals(string)) {
                    cloudEvent.time = jsonReader3.getNullable(jsonReader -> OffsetDateTime.parse(jsonReader.getString()));
                    continue;
                }
                if ("specversion".equals(string)) {
                    cloudEvent.specVersion = jsonReader3.getString();
                    continue;
                }
                if ("dataschema".equals(string)) {
                    cloudEvent.dataSchema = jsonReader3.getString();
                    continue;
                }
                if ("datacontenttype".equals(string)) {
                    cloudEvent.dataContentType = jsonReader3.getString();
                    continue;
                }
                if ("subject".equals(string)) {
                    cloudEvent.subject = jsonReader3.getString();
                    continue;
                }
                if (cloudEvent.extensionAttributes == null) {
                    cloudEvent.extensionAttributes = new LinkedHashMap<String, Object>();
                }
                cloudEvent.extensionAttributes.put(string, jsonReader3.readUntyped());
            }
            return cloudEvent;
        });
    }

    private static final class AnyToStringDeserializer
    extends JsonDeserializer<String> {
        private AnyToStringDeserializer() {
        }

        @Override
        public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return jsonParser.readValueAsTree().toString();
        }
    }
}

