/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.util.function.Tuple2;
import macromedia.jdbc.sqlserver.externals.reactor.util.function.Tuples;

public final class StreamUtil {
    private static final ClientLogger LOGGER = new ClientLogger(StreamUtil.class);

    private StreamUtil() {
    }

    public static Tuple2<Long, List<ByteBuffer>> readStreamToListOfByteBuffers(InputStream inputStream, Long l2, int n2, int n3) throws IOException {
        int n4;
        Objects.requireNonNull(inputStream, "'inputStream' must not be null");
        if (n2 <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'initialBufferSize' must be positive integer"));
        }
        if (n3 < n2) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maxBufferSize' must not be smaller than 'maxBufferSize'"));
        }
        if (l2 != null && l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'length' must not be negative"));
        }
        int n5 = n2;
        if (l2 != null) {
            n5 = (int)Math.max(1L, Math.min((long)n3, l2));
        }
        long l3 = 0L;
        long l4 = l2 != null ? l2 : Long.MAX_VALUE;
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        LinkedList<ByteBuffer> linkedList = new LinkedList<ByteBuffer>();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n5);
        do {
            if ((n4 = readableByteChannel.read(byteBuffer)) >= 0) {
                l3 += (long)n4;
                if (byteBuffer.hasRemaining()) continue;
                int n6 = 2 * n5;
                if ((long)n6 <= l4 - l3 && n6 <= n3) {
                    n5 = n6;
                }
                byteBuffer.flip();
                linkedList.add(byteBuffer);
                if (l3 == l4) {
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(1);
                    n4 = readableByteChannel.read(byteBuffer2);
                    if (n4 != -1) {
                        byteBuffer = ByteBuffer.allocate(n5);
                        byteBuffer2.flip();
                        byteBuffer.put(byteBuffer2);
                        continue;
                    }
                    byteBuffer = null;
                    continue;
                }
                byteBuffer = ByteBuffer.allocate(n5);
                continue;
            }
            byteBuffer.flip();
            if (!byteBuffer.hasRemaining()) continue;
            linkedList.add(byteBuffer);
        } while (n4 >= 0);
        return Tuples.of((Object)l3, Collections.unmodifiableList(linkedList));
    }
}

