/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContentType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class FluxByteBufferContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(FluxByteBufferContent.class);
    private final Flux<ByteBuffer> content;
    private final AtomicReference<FluxByteBufferContent> cachedReplayableContent = new AtomicReference();
    private final Long length;
    private final boolean isReplayable;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<FluxByteBufferContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FluxByteBufferContent.class, byte[].class, "bytes");

    public FluxByteBufferContent(Flux<ByteBuffer> flux) {
        this(flux, null);
    }

    public FluxByteBufferContent(Flux<ByteBuffer> flux, Long l2) {
        this(flux, l2, false);
    }

    public FluxByteBufferContent(Flux<ByteBuffer> flux, Long l2, boolean bl2) {
        this.content = Objects.requireNonNull(flux, "'content' cannot be null.");
        this.length = l2;
        this.isReplayable = bl2;
    }

    @Override
    public Long getLength() {
        byte[] byArray = BYTES_UPDATER.get(this);
        if (byArray != null) {
            return byArray.length;
        }
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, byArray -> byArray == null ? this.getBytes() : byArray);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer objectSerializer) {
        return objectSerializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.toBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        FluxUtil.writeToOutputStream(this.content, outputStream).block();
    }

    @Override
    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        FluxUtil.writeToWritableByteChannel(this.content, writableByteChannel).block();
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel asynchronousByteChannel) {
        if (asynchronousByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.content, asynchronousByteChannel);
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        if (this.isReplayable) {
            return this;
        }
        FluxByteBufferContent fluxByteBufferContent = this.cachedReplayableContent.get();
        if (fluxByteBufferContent != null) {
            return fluxByteBufferContent;
        }
        return (BinaryDataContent)this.bufferContent().map(linkedList -> {
            FluxByteBufferContent fluxByteBufferContent = new FluxByteBufferContent((Flux<ByteBuffer>)Flux.fromIterable((Iterable)linkedList).map(ByteBuffer::duplicate), this.length, true);
            this.cachedReplayableContent.set(fluxByteBufferContent);
            return fluxByteBufferContent;
        }).block();
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        if (this.isReplayable) {
            return Mono.just((Object)this);
        }
        FluxByteBufferContent fluxByteBufferContent = this.cachedReplayableContent.get();
        if (fluxByteBufferContent != null) {
            return Mono.just((Object)fluxByteBufferContent);
        }
        return this.bufferContent().cache().map(linkedList -> {
            Flux flux = Flux.fromIterable((Iterable)linkedList).map(ByteBuffer::asReadOnlyBuffer);
            FluxByteBufferContent fluxByteBufferContent = new FluxByteBufferContent((Flux<ByteBuffer>)flux, this.length, true);
            this.cachedReplayableContent.set(fluxByteBufferContent);
            return fluxByteBufferContent;
        });
    }

    private Mono<LinkedList<ByteBuffer>> bufferContent() {
        return this.content.map(byteBuffer -> {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
            byteBuffer2.put((ByteBuffer)byteBuffer);
            byteBuffer2.flip();
            return byteBuffer2;
        }).collect(LinkedList::new, LinkedList::add);
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private byte[] getBytes() {
        if (this.length != null && this.length > 0x7FFFFFF7L) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.length));
        }
        return (byte[])FluxUtil.collectBytesInByteBufferStream(this.content).share().block();
    }
}

