/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationSource;

public class EnvironmentConfiguration {
    private static final List<String> DEFAULT_CONFIGURATIONS = Arrays.asList("HTTP_PROXY", "HTTPS_PROXY", "IDENTITY_ENDPOINT", "IDENTITY_HEADER", "NO_PROXY", "MSI_ENDPOINT", "MSI_SECRET", "AZURE_SUBSCRIPTION_ID", "AZURE_USERNAME", "AZURE_PASSWORD", "AZURE_CLIENT_ID", "AZURE_CLIENT_SECRET", "AZURE_TENANT_ID", "AZURE_CLIENT_CERTIFICATE_PATH", "AZURE_CLIENT_CERTIFICATE_PASSWORD", "AZURE_IDENTITY_DISABLE_CP1", "AZURE_RESOURCE_GROUP", "AZURE_CLOUD", "AZURE_AUTHORITY_HOST", "AZURE_TELEMETRY_DISABLED", "AZURE_LOG_LEVEL", "AZURE_HTTP_LOG_DETAIL_LEVEL", "AZURE_TRACING_DISABLED", "AZURE_POD_IDENTITY_TOKEN_URL", "AZURE_REGIONAL_AUTHORITY_NAME", "AZURE_REQUEST_RETRY_COUNT", "AZURE_REQUEST_CONNECT_TIMEOUT", "AZURE_REQUEST_WRITE_TIMEOUT", "AZURE_REQUEST_RESPONSE_TIMEOUT", "AZURE_REQUEST_READ_TIMEOUT");
    private static final EnvironmentConfiguration GLOBAL_CONFIGURATION = new EnvironmentConfiguration();
    private final ConcurrentMap<String, String> explicitConfigurations;
    private final ConcurrentMap<String, Optional<String>> envConfigurations;
    private final ConcurrentMap<String, Optional<String>> sysPropertiesConfigurations;

    private EnvironmentConfiguration() {
        this(EnvironmentVariablesConfigurationSource.GLOBAL_SOURCE, string -> Collections.emptyMap());
    }

    public EnvironmentConfiguration(EnvironmentConfiguration environmentConfiguration) {
        this.explicitConfigurations = new ConcurrentHashMap<String, String>(environmentConfiguration.explicitConfigurations);
        this.envConfigurations = new ConcurrentHashMap<String, Optional<String>>(environmentConfiguration.envConfigurations);
        this.sysPropertiesConfigurations = new ConcurrentHashMap<String, Optional<String>>(environmentConfiguration.sysPropertiesConfigurations);
    }

    public EnvironmentConfiguration(ConfigurationSource configurationSource, ConfigurationSource configurationSource2) {
        this.explicitConfigurations = new ConcurrentHashMap<String, String>();
        if (configurationSource2 == null) {
            configurationSource2 = EnvironmentVariablesConfigurationSource.GLOBAL_SOURCE;
        }
        Map<String, String> map = configurationSource2.getProperties(null);
        Objects.requireNonNull(map, "'environmentConfigurationSource.getProperties(null)' can't be null");
        this.envConfigurations = new ConcurrentHashMap<String, Optional<String>>(map.size());
        for (Map.Entry<String, String> object : map.entrySet()) {
            this.envConfigurations.put(object.getKey(), Optional.ofNullable(object.getValue()));
        }
        if (configurationSource == null) {
            this.sysPropertiesConfigurations = new ConcurrentHashMap<String, Optional<String>>();
        } else {
            Map<String, String> map2 = configurationSource.getProperties(null);
            Objects.requireNonNull(map2, "'systemPropertiesConfigurationSource.getProperties(null)' can't be null");
            this.sysPropertiesConfigurations = new ConcurrentHashMap<String, Optional<String>>(map2.size());
            for (Map.Entry entry : map2.entrySet()) {
                this.sysPropertiesConfigurations.put((String)entry.getKey(), Optional.ofNullable((String)entry.getValue()));
            }
        }
    }

    public static EnvironmentConfiguration getGlobalConfiguration() {
        return GLOBAL_CONFIGURATION;
    }

    public String getEnvironmentVariable(String string) {
        return this.getOrLoad(string, this.envConfigurations, false);
    }

    public String getSystemProperty(String string) {
        return this.getOrLoad(string, this.sysPropertiesConfigurations, true);
    }

    public String get(String string) {
        String string2 = (String)this.explicitConfigurations.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.getSystemProperty(string);
        if (string2 != null) {
            return string2;
        }
        return this.getEnvironmentVariable(string);
    }

    private String getOrLoad(String string, ConcurrentMap<String, Optional<String>> concurrentMap, boolean bl2) {
        Optional optional = (Optional)concurrentMap.get(string);
        if (optional != null) {
            return optional.orElse(null);
        }
        String string2 = bl2 ? this.loadFromProperties(string) : this.loadFromEnvironment(string);
        concurrentMap.put(string, Optional.ofNullable(string2));
        return string2;
    }

    public EnvironmentConfiguration put(String string, String string2) {
        this.explicitConfigurations.put(string, string2);
        return this;
    }

    public String remove(String string) {
        return (String)this.explicitConfigurations.remove(string);
    }

    private String loadFromEnvironment(String string) {
        return System.getenv(string);
    }

    private String loadFromProperties(String string) {
        return System.getProperty(string);
    }

    public static final class EnvironmentVariablesConfigurationSource
    implements ConfigurationSource {
        public static final ConfigurationSource GLOBAL_SOURCE = new EnvironmentVariablesConfigurationSource();
        private final Map<String, String> configurations = new HashMap<String, String>();

        private EnvironmentVariablesConfigurationSource() {
            for (String string : DEFAULT_CONFIGURATIONS) {
                String string2 = System.getenv(string);
                if (string2 == null) continue;
                this.configurations.put(string, string2);
            }
        }

        @Override
        public Map<String, String> getProperties(String string) {
            return this.configurations;
        }
    }
}

