/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.AdditionalPropertiesDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.AdditionalPropertiesSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.Base64UrlSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.BinaryDataDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.BinaryDataSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.ByteArraySerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.DateTimeDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.DateTimeRfc1123Serializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.DateTimeSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.DurationSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.FlatteningDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.FlatteningSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.GeoJsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.GeoJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.HttpHeadersSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonDatabind215;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonVersion;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JsonSerializableDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JsonSerializableSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.ResponseErrorDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.XmlMapperFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonAutoDetect;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonInclude;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.PropertyAccessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.json.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.MapperFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.json.JsonMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

final class ObjectMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(ObjectMapperFactory.class);
    final boolean useJackson215 = macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.PackageVersion.VERSION.getMinorVersion() >= 15 && PackageVersion.VERSION.getMinorVersion() >= 15;
    private boolean jackson215IsSafe = true;
    private static final boolean USE_ACCESS_HELPER = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_JACKSON_ADAPTER_USE_ACCESS_HELPER"));
    public static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();

    ObjectMapperFactory() {
    }

    public ObjectMapper createJsonMapper(ObjectMapper objectMapper) {
        ObjectMapper objectMapper2 = this.attemptJackson215Mutation((ObjectMapper)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule(FlatteningSerializer.getModule(objectMapper))).addModule(FlatteningDeserializer.getModule(objectMapper))).build());
        return this.attemptJackson215Mutation((ObjectMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule(AdditionalPropertiesSerializer.getModule(objectMapper2))).addModule(AdditionalPropertiesDeserializer.getModule(objectMapper2))).addModule(FlatteningSerializer.getModule(objectMapper))).addModule(FlatteningDeserializer.getModule(objectMapper))).addModule(JsonSerializableSerializer.getModule())).addModule(JsonSerializableDeserializer.getModule())).addModule(ResponseErrorDeserializer.getModule(objectMapper))).build());
    }

    public ObjectMapper createXmlMapper() {
        return this.attemptJackson215Mutation(XmlMapperFactory.INSTANCE.createXmlMapper());
    }

    public ObjectMapper createSimpleMapper() {
        return this.attemptJackson215Mutation((ObjectMapper)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).build());
    }

    public ObjectMapper createDefaultMapper() {
        return this.attemptJackson215Mutation(new ObjectMapper());
    }

    public ObjectMapper createPrettyPrintMapper() {
        return this.attemptJackson215Mutation(new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT));
    }

    public ObjectMapper createHeaderMapper() {
        return this.attemptJackson215Mutation((ObjectMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).addModule(JsonSerializableSerializer.getModule())).addModule(JsonSerializableDeserializer.getModule())).build());
    }

    private ObjectMapper attemptJackson215Mutation(ObjectMapper objectMapper) {
        if (this.useJackson215 && this.jackson215IsSafe) {
            try {
                if (USE_ACCESS_HELPER) {
                    try {
                        return AccessController.doPrivileged(() -> JacksonDatabind215.mutateStreamReadConstraints(objectMapper));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Throwable throwable = privilegedActionException.getCause();
                        if (throwable instanceof Error) {
                            throw LOGGER.logThrowableAsError((Error)throwable);
                        }
                        if (throwable instanceof RuntimeException) {
                            throw LOGGER.logExceptionAsError((RuntimeException)throwable);
                        }
                        throw LOGGER.logExceptionAsError(new RuntimeException(privilegedActionException));
                    }
                }
                return JacksonDatabind215.mutateStreamReadConstraints(objectMapper);
            }
            catch (Throwable throwable) {
                if (throwable instanceof LinkageError) {
                    this.jackson215IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, throwable);
                }
                throw throwable;
            }
        }
        return objectMapper;
    }

    static <S extends MapperBuilder<?, ?>> S initializeMapperBuilder(S s2) {
        ((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)s2.enable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule(new JavaTimeModule())).addModule(BinaryDataSerializer.getModule())).addModule(BinaryDataDeserializer.getModule())).addModule(ByteArraySerializer.getModule())).addModule(Base64UrlSerializer.getModule())).addModule(DateTimeSerializer.getModule())).addModule(DateTimeDeserializer.getModule())).addModule(DateTimeRfc1123Serializer.getModule())).addModule(DurationSerializer.getModule())).addModule(HttpHeadersSerializer.getModule())).addModule(GeoJsonSerializer.getModule())).addModule(GeoJsonDeserializer.getModule())).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        return s2;
    }
}

