/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.AzureJsonUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.Module;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class JsonSerializableDeserializer
extends JsonDeserializer<JsonSerializable<?>> {
    private static final ClientLogger LOGGER = new ClientLogger(JsonSerializableDeserializer.class);
    private final Class<? extends JsonSerializable<?>> jsonSerializableType;
    private final ReflectiveInvoker readJson;

    public static Module getModule() {
        return new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonSerializableDeserializer) {
                return ReflectionSerializable.supportsJsonSerializable(beanDescription.getBeanClass()) ? new JsonSerializableDeserializer(beanDescription.getBeanClass()) : jsonSerializableDeserializer;
            }
        });
    }

    JsonSerializableDeserializer(Class<? extends JsonSerializable<?>> clazz) {
        this.jsonSerializableType = clazz;
        try {
            this.readJson = ReflectionUtils.getMethodInvoker(clazz, clazz.getDeclaredMethod("fromJson", JsonReader.class));
        }
        catch (Exception exception) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(exception));
        }
    }

    @Override
    public JsonSerializable<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        try {
            return this.jsonSerializableType.cast(this.readJson.invokeWithArguments(AzureJsonUtils.createReader(jsonParser), new Object[0]));
        }
        catch (Exception exception) {
            IOException iOException = exception instanceof IOException ? (IOException)exception : new IOException(exception);
            throw LOGGER.logThrowableAsError(iOException);
        }
    }
}

