/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.SemanticVersion;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.json.PackageVersion;

final class JacksonVersion {
    private static final String CORE_PACKAGE_NAME = "jackson-core";
    private static final String DATABIND_PACKAGE_NAME = "jackson-databind";
    private static final String XML_PACKAGE_NAME = "jackson-dataformat-xml";
    private static final String JSR310_PACKAGE_NAME = "jackson-datatype-jsr310";
    private static final String TROUBLESHOOTING_DOCS_LINK = "https://aka.ms/azsdk/java/dependency/troubleshoot";
    private static final SemanticVersion MIN_SUPPORTED_VERSION;
    private static final int MAX_SUPPORTED_MAJOR_VERSION = 2;
    private static final String AZURE_CORE_PROPERTIES_NAME = "azure-core.properties";
    private static final String AZURE_CORE_PROPERTIES_VERSION_KEY = "version";
    private static final String AZURE_CORE_VERSION;
    private static final ClientLogger LOGGER;
    private static final String HELP_STRING;

    private JacksonVersion() {
    }

    public static String getHelpInfo() {
        return HELP_STRING;
    }

    private static void checkVersion(SemanticVersion semanticVersion, String string) {
        if (!semanticVersion.isValid()) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Could not find version of '" + string + "'.");
            return;
        }
        if (semanticVersion.compareTo(MIN_SUPPORTED_VERSION) < 0) {
            LOGGER.log(LogLevel.WARNING, () -> "Version '" + semanticVersion + "' of package '" + string + "' is not supported (older than earliest supported version - '" + MIN_SUPPORTED_VERSION + "'). It may result in runtime exceptions during serialization. Please consider updating Jackson to one of the supported versions " + TROUBLESHOOTING_DOCS_LINK);
        }
        if (semanticVersion.getMajorVersion() > 2) {
            LOGGER.log(LogLevel.WARNING, () -> "Major version '" + semanticVersion + "' of package '" + string + "' is newer than latest supported version - '" + 2 + "'. It may result in runtime exceptions during serialization.");
        }
    }

    static {
        SemanticVersion semanticVersion;
        Object object;
        MIN_SUPPORTED_VERSION = SemanticVersion.parse("2.10.0");
        AZURE_CORE_VERSION = CoreUtils.getProperties(AZURE_CORE_PROPERTIES_NAME).getOrDefault(AZURE_CORE_PROPERTIES_VERSION_KEY, "unknown");
        LOGGER = new ClientLogger(JacksonVersion.class);
        SemanticVersion semanticVersion2 = SemanticVersion.parse(PackageVersion.VERSION.toString());
        SemanticVersion semanticVersion3 = SemanticVersion.parse(macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.PackageVersion.VERSION.toString());
        SemanticVersion semanticVersion4 = SemanticVersion.parse(macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.PackageVersion.VERSION.toString());
        try {
            object = Class.forName("macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.PackageVersion");
            semanticVersion = SemanticVersion.parse(((Class)object).getDeclaredField("VERSION").get(null).toString());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            semanticVersion = SemanticVersion.createInvalid();
        }
        object = semanticVersion;
        JacksonVersion.checkVersion(semanticVersion2, CORE_PACKAGE_NAME);
        JacksonVersion.checkVersion(semanticVersion3, DATABIND_PACKAGE_NAME);
        JacksonVersion.checkVersion((SemanticVersion)object, XML_PACKAGE_NAME);
        JacksonVersion.checkVersion(semanticVersion4, JSR310_PACKAGE_NAME);
        HELP_STRING = "Package versions: jackson-core=" + semanticVersion2.getVersionString() + ", " + DATABIND_PACKAGE_NAME + "=" + semanticVersion3.getVersionString() + ", " + XML_PACKAGE_NAME + "=" + ((SemanticVersion)object).getVersionString() + ", " + JSR310_PACKAGE_NAME + "=" + semanticVersion4.getVersionString() + ", azure-core=" + AZURE_CORE_VERSION + ", Troubleshooting version conflicts: " + TROUBLESHOOTING_DOCS_LINK;
        LOGGER.info(HELP_STRING);
    }
}

