/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriteContext;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;

final class JacksonJsonWriter
extends JsonWriter {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonJsonWriter.class);
    private final JsonGenerator generator;
    private JsonWriteContext context = JsonWriteContext.ROOT;

    JacksonJsonWriter(JsonGenerator jsonGenerator) {
        this.generator = Objects.requireNonNull(jsonGenerator, "Cannot create a Jackson-based instance of macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter with a null Jackson JsonGenerator.");
    }

    @Override
    public JsonWriteContext getWriteContext() {
        return this.context;
    }

    @Override
    public void close() throws IOException {
        if (this.context != JsonWriteContext.COMPLETED) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Writing of the JSON object must be completed before the writer can be closed. Current writing state is '" + (Object)((Object)this.context.getWriteState()) + "'."));
        }
        this.generator.flush();
        this.generator.close();
    }

    @Override
    public JsonWriter flush() throws IOException {
        this.generator.flush();
        return this;
    }

    @Override
    public JsonWriter writeStartObject() throws IOException {
        this.context.validateToken(JsonToken.START_OBJECT);
        this.generator.writeStartObject();
        this.context = this.context.updateContext(JsonToken.START_OBJECT);
        return this;
    }

    @Override
    public JsonWriter writeEndObject() throws IOException {
        this.context.validateToken(JsonToken.END_OBJECT);
        this.generator.writeEndObject();
        this.context = this.context.updateContext(JsonToken.END_OBJECT);
        return this;
    }

    @Override
    public JsonWriter writeStartArray() throws IOException {
        this.context.validateToken(JsonToken.START_ARRAY);
        this.generator.writeStartArray();
        this.context = this.context.updateContext(JsonToken.START_ARRAY);
        return this;
    }

    @Override
    public JsonWriter writeEndArray() throws IOException {
        this.context.validateToken(JsonToken.END_ARRAY);
        this.generator.writeEndArray();
        this.context = this.context.updateContext(JsonToken.END_ARRAY);
        return this;
    }

    @Override
    public JsonWriter writeFieldName(String string) throws IOException {
        Objects.requireNonNull(string, "'fieldName' cannot be null.");
        this.context.validateToken(JsonToken.FIELD_NAME);
        this.generator.writeFieldName(string);
        this.context = this.context.updateContext(JsonToken.FIELD_NAME);
        return this;
    }

    @Override
    public JsonWriter writeBinary(byte[] byArray) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        if (byArray == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(byArray);
        }
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    @Override
    public JsonWriter writeBoolean(boolean bl2) throws IOException {
        this.context.validateToken(JsonToken.BOOLEAN);
        this.generator.writeBoolean(bl2);
        this.context = this.context.updateContext(JsonToken.BOOLEAN);
        return this;
    }

    @Override
    public JsonWriter writeDouble(double d2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(d2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeFloat(float f2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(f2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeInt(int n2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(n2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeLong(long l2) throws IOException {
        this.context.validateToken(JsonToken.NUMBER);
        this.generator.writeNumber(l2);
        this.context = this.context.updateContext(JsonToken.NUMBER);
        return this;
    }

    @Override
    public JsonWriter writeNull() throws IOException {
        this.context.validateToken(JsonToken.NULL);
        this.generator.writeNull();
        this.context = this.context.updateContext(JsonToken.NULL);
        return this;
    }

    @Override
    public JsonWriter writeString(String string) throws IOException {
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeString(string);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }

    @Override
    public JsonWriter writeRawValue(String string) throws IOException {
        Objects.requireNonNull(string, "'value' cannot be null.");
        this.context.validateToken(JsonToken.STRING);
        this.generator.writeRawValue(string);
        this.context = this.context.updateContext(JsonToken.STRING);
        return this;
    }
}

