/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

final class HeaderCollectionHandler {
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Field, ReflectiveInvoker> FIELD_TO_SETTER_INVOKER_CACHE = new ConcurrentHashMap<Field, ReflectiveInvoker>();
    private static final ReflectiveInvoker NO_SETTER_REFLECTIVE_INVOKER = ReflectionUtils.createNoOpInvoker();
    private final String prefix;
    private final int prefixLength;
    private final Map<String, String> values;
    private final Field declaringField;

    HeaderCollectionHandler(String string, Field field) {
        this.prefix = string;
        this.prefixLength = string.length();
        this.values = new HashMap<String, String>();
        this.declaringField = field;
    }

    boolean headerStartsWithPrefix(String string) {
        return string.startsWith(this.prefix);
    }

    void addHeader(String string, String string2) {
        this.values.put(string.substring(this.prefixLength), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectValuesIntoDeclaringField(Object object, ClientLogger clientLogger) {
        if (this.usePublicSetter(object, clientLogger)) {
            return;
        }
        boolean bl2 = this.declaringField.isAccessible();
        try {
            if (!bl2) {
                AccessController.doPrivileged(() -> {
                    this.declaringField.setAccessible(true);
                    return null;
                });
            }
            this.declaringField.set(object, this.values);
            clientLogger.verbose("Set header collection by accessing the field directly.");
        }
        catch (IllegalAccessException illegalAccessException) {
            clientLogger.log(LogLevel.WARNING, () -> "Failed to inject header collection values into deserialized headers.", illegalAccessException);
        }
        finally {
            if (!bl2) {
                AccessController.doPrivileged(() -> {
                    this.declaringField.setAccessible(false);
                    return null;
                });
            }
        }
    }

    private boolean usePublicSetter(Object object, ClientLogger clientLogger) {
        String string;
        String string2;
        Class<?> clazz = object.getClass();
        ReflectiveInvoker reflectiveInvoker = HeaderCollectionHandler.getFromCache(this.declaringField, clazz, string2 = clazz.getSimpleName(), string = this.declaringField.getName(), clientLogger);
        if (reflectiveInvoker == NO_SETTER_REFLECTIVE_INVOKER) {
            return false;
        }
        try {
            reflectiveInvoker.invokeWithArguments(object, this.values);
            clientLogger.log(LogLevel.VERBOSE, () -> "Set header collection " + string + " on class " + string2 + " using reflection.");
            return true;
        }
        catch (Exception exception) {
            clientLogger.log(LogLevel.VERBOSE, () -> "Failed to set header " + string + " collection on class " + string2 + " using reflection.", exception);
            return false;
        }
    }

    private static String getPotentialSetterName(String string) {
        return "set" + string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    private static ReflectiveInvoker getFromCache(Field field2, Class<?> clazz, String string, String string2, ClientLogger clientLogger) {
        if (FIELD_TO_SETTER_INVOKER_CACHE.size() >= 10000) {
            FIELD_TO_SETTER_INVOKER_CACHE.clear();
        }
        return FIELD_TO_SETTER_INVOKER_CACHE.computeIfAbsent(field2, field -> {
            String string3 = HeaderCollectionHandler.getPotentialSetterName(string2);
            try {
                ReflectiveInvoker reflectiveInvoker = ReflectionUtils.getMethodInvoker(clazz, clazz.getDeclaredMethod(string3, Map.class));
                clientLogger.log(LogLevel.VERBOSE, () -> "Using invoker for setter " + string3 + " on class " + string + ".");
                return reflectiveInvoker;
            }
            catch (Exception exception) {
                clientLogger.log(LogLevel.VERBOSE, () -> "Failed to retrieve invoker for setter " + string3 + " on class " + string + ". Will attempt to make field accessible. Please consider adding public setter.", exception);
                return NO_SETTER_REFLECTIVE_INVOKER;
            }
        });
    }
}

