/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.GeoObjectHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineString;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineStringCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLinearRing;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPoint;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPointCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygon;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygonCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class GeoJsonSerializer
extends JsonSerializer<GeoObject> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoJsonSerializer.class);
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(GeoObject.class, new GeoJsonSerializer());

    GeoJsonSerializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    @Override
    public void serialize(GeoObject geoObject, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        GeoJsonSerializer.write(geoObject, jsonGenerator);
    }

    private static void write(GeoObject geoObject, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        if (geoObject instanceof GeoPoint) {
            GeoJsonSerializer.writeType(GeoObjectType.POINT, jsonGenerator);
            jsonGenerator.writeFieldName("coordinates");
            GeoJsonSerializer.writePosition(((GeoPoint)geoObject).getCoordinates(), jsonGenerator);
        } else if (geoObject instanceof GeoLineString) {
            GeoJsonSerializer.writeType(GeoObjectType.LINE_STRING, jsonGenerator);
            jsonGenerator.writeFieldName("coordinates");
            GeoJsonSerializer.writePositions(((GeoLineString)geoObject).getCoordinates(), jsonGenerator);
        } else if (geoObject instanceof GeoPolygon) {
            GeoJsonSerializer.writeType(GeoObjectType.POLYGON, jsonGenerator);
            jsonGenerator.writeArrayFieldStart("coordinates");
            for (GeoLinearRing geoLinearRing : ((GeoPolygon)geoObject).getRings()) {
                GeoJsonSerializer.writePositions(geoLinearRing.getCoordinates(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        } else if (geoObject instanceof GeoPointCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.MULTI_POINT, jsonGenerator);
            jsonGenerator.writeArrayFieldStart("coordinates");
            for (GeoPoint geoPoint : ((GeoPointCollection)geoObject).getPoints()) {
                GeoJsonSerializer.writePosition(geoPoint.getCoordinates(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        } else if (geoObject instanceof GeoLineStringCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.MULTI_LINE_STRING, jsonGenerator);
            jsonGenerator.writeArrayFieldStart("coordinates");
            for (GeoLineString geoLineString : ((GeoLineStringCollection)geoObject).getLines()) {
                GeoJsonSerializer.writePositions(geoLineString.getCoordinates(), jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        } else if (geoObject instanceof GeoPolygonCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.MULTI_POLYGON, jsonGenerator);
            jsonGenerator.writeArrayFieldStart("coordinates");
            for (GeoPolygon geoPolygon : ((GeoPolygonCollection)geoObject).getPolygons()) {
                jsonGenerator.writeStartArray();
                for (GeoLinearRing geoLinearRing : geoPolygon.getRings()) {
                    GeoJsonSerializer.writePositions(geoLinearRing.getCoordinates(), jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndArray();
        } else if (geoObject instanceof GeoCollection) {
            GeoJsonSerializer.writeType(GeoObjectType.GEOMETRY_COLLECTION, jsonGenerator);
            jsonGenerator.writeArrayFieldStart("geometries");
            for (GeoObject geoObject2 : ((GeoCollection)geoObject).getGeometries()) {
                GeoJsonSerializer.write(geoObject2, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        } else {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format("Geo type '%s' isn't supported.", geoObject.getClass().getName())));
        }
        GeoJsonSerializer.writeBoundingBox(geoObject.getBoundingBox(), jsonGenerator);
        GeoJsonSerializer.writeAdditionalProperties(GeoObjectHelper.getCustomProperties(geoObject), jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private static void writePositions(List<GeoPosition> list, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        for (GeoPosition geoPosition : list) {
            GeoJsonSerializer.writePosition(geoPosition, jsonGenerator);
        }
        jsonGenerator.writeEndArray();
    }

    private static void writePosition(GeoPosition geoPosition, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        jsonGenerator.writeNumber(geoPosition.getLongitude());
        jsonGenerator.writeNumber(geoPosition.getLatitude());
        Double d2 = geoPosition.getAltitude();
        if (d2 != null) {
            jsonGenerator.writeNumber(d2);
        }
        jsonGenerator.writeEndArray();
    }

    private static void writeType(GeoObjectType geoObjectType, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStringField("type", geoObjectType.toString());
    }

    private static void writeBoundingBox(GeoBoundingBox geoBoundingBox, JsonGenerator jsonGenerator) throws IOException {
        if (geoBoundingBox == null) {
            return;
        }
        jsonGenerator.writeArrayFieldStart("bbox");
        jsonGenerator.writeNumber(geoBoundingBox.getWest());
        jsonGenerator.writeNumber(geoBoundingBox.getSouth());
        Double d2 = geoBoundingBox.getMinAltitude();
        if (d2 != null) {
            jsonGenerator.writeNumber(d2);
        }
        jsonGenerator.writeNumber(geoBoundingBox.getEast());
        jsonGenerator.writeNumber(geoBoundingBox.getNorth());
        Double d3 = geoBoundingBox.getMaxAltitude();
        if (d3 != null) {
            jsonGenerator.writeNumber(d3);
        }
        jsonGenerator.writeEndArray();
    }

    private static void writeAdditionalProperties(Map<String, Object> map, JsonGenerator jsonGenerator) throws IOException {
        if (CoreUtils.isNullOrEmpty(map)) {
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            jsonGenerator.writeObject(entry.getValue());
        }
    }
}

