/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.JsonFlatten;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonTypeInfo;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;

final class FlatteningDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private static final long serialVersionUID = -2133095337545715498L;
    private static final Pattern IS_FLATTENED_PATTERN = Pattern.compile(".+[^\\\\]\\..+");
    private static final Pattern SPLIT_KEY_PATTERN = Pattern.compile("((?<!\\\\))\\.");
    private final BeanDescription beanDescription;
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;
    private final boolean classHasJsonFlatten;

    protected FlatteningDeserializer(BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer, ObjectMapper objectMapper) {
        super(beanDescription.getBeanClass());
        this.beanDescription = beanDescription;
        this.defaultDeserializer = jsonDeserializer;
        this.mapper = objectMapper;
        this.classHasJsonFlatten = beanDescription.getClassAnnotations().has(JsonFlatten.class);
    }

    public static SimpleModule getModule(final ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
                boolean bl2 = beanDescription.getClassAnnotations().has(JsonFlatten.class);
                boolean bl3 = beanDescription.findProperties().stream().filter(BeanPropertyDefinition::hasField).map(BeanPropertyDefinition::getField).anyMatch(annotatedField -> annotatedField.hasAnnotation(JsonFlatten.class));
                if (bl2 || bl3) {
                    return new FlatteningDeserializer(beanDescription, jsonDeserializer, objectMapper);
                }
                return jsonDeserializer;
            }
        });
        return simpleModule;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        JsonNode jsonNode = (JsonNode)this.mapper.readTree(jsonParser);
        Class<?> clazz = this.defaultDeserializer.handledType();
        for (Class<?> clazz2 : TypeUtil.getAllClasses(clazz)) {
            String string;
            JsonNode jsonNode2;
            String string2;
            JsonTypeInfo jsonTypeInfo = clazz2.getAnnotation(JsonTypeInfo.class);
            if (jsonTypeInfo == null || !FlatteningDeserializer.containsDot(string2 = jsonTypeInfo.property()) || (jsonNode2 = ((ObjectNode)jsonNode).remove(string = FlatteningDeserializer.unescapeEscapedDots(string2))) == null) continue;
            ((ObjectNode)jsonNode).set(string2, jsonNode2);
        }
        return typeDeserializer.deserializeTypedFromAny(FlatteningDeserializer.newJsonParserForNode(jsonNode), deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = deserializationContext.readTree(jsonParser);
        if (jsonNode.isNull()) {
            jsonNode = this.mapper.getNodeFactory().objectNode();
        }
        for (BeanPropertyDefinition beanPropertyDefinition : this.beanDescription.findProperties()) {
            if (!beanPropertyDefinition.hasField()) continue;
            this.handleFlatteningForField(beanPropertyDefinition.getField(), jsonNode);
        }
        return this.defaultDeserializer.deserialize(FlatteningDeserializer.newJsonParserForNode(jsonNode), deserializationContext);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        if (this.defaultDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)this.defaultDeserializer)).resolve(deserializationContext);
        }
    }

    private void handleFlatteningForField(AnnotatedField annotatedField, JsonNode jsonNode) {
        JsonProperty jsonProperty = annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            String[] stringArray;
            String string = jsonProperty.value();
            if (jsonNode.has(string)) {
                stringArray = string.replace(".", "\\.");
                ((ObjectNode)jsonNode).set((String)stringArray, jsonNode.get(string));
            }
            if ((this.classHasJsonFlatten || annotatedField.hasAnnotation(JsonFlatten.class)) && IS_FLATTENED_PATTERN.matcher(string).matches()) {
                stringArray = (String[])Arrays.stream(SPLIT_KEY_PATTERN.split(string)).map(FlatteningDeserializer::unescapeEscapedDots).toArray(String[]::new);
                int n2 = 0;
                ArrayList<JsonNode> arrayList = new ArrayList<JsonNode>();
                arrayList.add(jsonNode);
                ++n2;
                JsonNode jsonNode2 = jsonNode;
                for (String string2 : stringArray) {
                    jsonNode2 = jsonNode2.get(string2);
                    ++n2;
                    if (jsonNode2 == null) break;
                    arrayList.add(jsonNode2);
                }
                if (arrayList.size() == n2 - 1) {
                    ((ObjectNode)jsonNode).set(string, null);
                    return;
                }
                if (!((JsonNode)arrayList.get(arrayList.size() - 2)).has(stringArray[stringArray.length - 1])) {
                    ((ObjectNode)jsonNode).set(string, null);
                } else {
                    ((ObjectNode)jsonNode).set(string, (JsonNode)arrayList.get(arrayList.size() - 1));
                }
                for (int i2 = arrayList.size() - 2; i2 >= 0 && (i2 != arrayList.size() - 2 || arrayList.size() - 1 == stringArray.length || ((JsonNode)arrayList.get(i2)).get(stringArray[i2]).size() == 0); --i2) {
                    ((ObjectNode)arrayList.get(i2)).remove(stringArray[i2]);
                    if (((JsonNode)arrayList.get(i2)).size() > 0) break;
                }
            }
        }
    }

    private static String unescapeEscapedDots(String string) {
        return string.replace("\\.", ".");
    }

    private static boolean containsDot(String string) {
        return !CoreUtils.isNullOrEmpty(string) && string.contains(".");
    }

    private static JsonParser newJsonParserForNode(JsonNode jsonNode) throws IOException {
        JsonParser jsonParser = new JsonFactory().createParser(jsonNode.toString());
        jsonParser.nextToken();
        return jsonParser;
    }
}

