/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ArrayNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ser.std.StdSerializer;

final class AdditionalPropertiesSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private static final long serialVersionUID = -3458779491516161716L;
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;

    protected AdditionalPropertiesSerializer(Class<?> clazz, JsonSerializer<?> jsonSerializer, ObjectMapper objectMapper) {
        super(clazz, false);
        this.defaultSerializer = jsonSerializer;
        this.mapper = objectMapper;
    }

    public static SimpleModule getModule(final ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig serializationConfig, BeanDescription beanDescription, JsonSerializer<?> jsonSerializer) {
                for (Class<Object> clazz : TypeUtil.getAllClasses(beanDescription.getBeanClass())) {
                    Field[] fieldArray;
                    if (clazz.isAssignableFrom(Object.class)) continue;
                    for (Field field : fieldArray = clazz.getDeclaredFields()) {
                        JsonProperty jsonProperty;
                        if (!"additionalProperties".equalsIgnoreCase(field.getName()) || (jsonProperty = field.getAnnotation(JsonProperty.class)) == null || !jsonProperty.value().isEmpty()) continue;
                        return new AdditionalPropertiesSerializer(beanDescription.getBeanClass(), jsonSerializer, objectMapper);
                    }
                }
                return jsonSerializer;
            }
        });
        return simpleModule;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ObjectNode objectNode = (ObjectNode)this.mapper.valueToTree(object);
        ObjectNode objectNode2 = objectNode.deepCopy();
        LinkedBlockingQueue<ObjectNode> linkedBlockingQueue = new LinkedBlockingQueue<ObjectNode>();
        LinkedBlockingQueue<ObjectNode> linkedBlockingQueue2 = new LinkedBlockingQueue<ObjectNode>();
        linkedBlockingQueue.add(objectNode);
        linkedBlockingQueue2.add(objectNode2);
        while (!linkedBlockingQueue.isEmpty()) {
            ObjectNode objectNode3 = (ObjectNode)linkedBlockingQueue.poll();
            ObjectNode objectNode4 = (ObjectNode)linkedBlockingQueue2.poll();
            Iterator<Map.Entry<String, JsonNode>> iterator = objectNode3.fields();
            while (iterator.hasNext()) {
                Iterator<Object> iterator2;
                Object object2;
                Map.Entry<String, JsonNode> entry = iterator.next();
                String string = entry.getKey();
                JsonNode jsonNode = objectNode4.get(string);
                if ("additionalProperties".equals(string)) {
                    objectNode4.remove(string);
                    object2 = (ObjectNode)jsonNode;
                    iterator2 = ((ObjectNode)object2).fields();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, JsonNode> entry2 = iterator2.next();
                        objectNode4.set(entry2.getKey(), entry2.getValue());
                    }
                }
                if (entry.getValue() instanceof ObjectNode) {
                    linkedBlockingQueue.add((ObjectNode)entry.getValue());
                    linkedBlockingQueue2.add((ObjectNode)jsonNode);
                    continue;
                }
                if (!(entry.getValue() instanceof ArrayNode) || entry.getValue().size() <= 0 || !(entry.getValue().get(0) instanceof ObjectNode)) continue;
                object2 = entry.getValue().elements();
                iterator2 = jsonNode.elements();
                while (object2.hasNext()) {
                    linkedBlockingQueue.add((ObjectNode)object2.next());
                    linkedBlockingQueue2.add((ObjectNode)iterator2.next());
                }
            }
        }
        jsonGenerator.writeTree(objectNode2);
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        ((ResolvableSerializer)((Object)this.defaultSerializer)).resolve(serializerProvider);
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(object, jsonGenerator, serializerProvider);
    }
}

