/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.BodyParam;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Delete;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.ExpectedResponses;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.FormParam;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Get;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Head;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.HeaderParam;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Headers;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.HostParam;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Options;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Patch;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.PathParam;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Post;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Put;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.QueryParam;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.ReturnValueWireType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.UnexpectedResponseExceptionType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.HttpResponseException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Page;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.RequestOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.ResponseBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.StreamResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.UnexpectedExceptionInformation;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.HeaderSubstitution;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.MissingRequiredAnnotationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.QuerySubstitution;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RangeReplaceSubstitution;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.Substitution;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.UrlEscapers;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecodeData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Base64Url;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.DateTimeRfc1123;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ExpandableStringEnum;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class SwaggerMethodParser
implements HttpResponseDecodeData {
    private static final List<Class<? extends Annotation>> REQUIRED_HTTP_METHODS = Arrays.asList(Delete.class, Get.class, Head.class, Options.class, Patch.class, Post.class, Put.class);
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private final HttpMethod httpMethod;
    private final String relativePath;
    final List<RangeReplaceSubstitution> hostSubstitutions = new ArrayList<RangeReplaceSubstitution>();
    private final List<RangeReplaceSubstitution> pathSubstitutions = new ArrayList<RangeReplaceSubstitution>();
    private final List<QuerySubstitution> querySubstitutions = new ArrayList<QuerySubstitution>();
    private final List<Substitution> formSubstitutions = new ArrayList<Substitution>();
    private final List<HeaderSubstitution> headerSubstitutions = new ArrayList<HeaderSubstitution>();
    private final HttpHeaders headers = new HttpHeaders();
    private final Integer bodyContentMethodParameterIndex;
    private final String bodyContentType;
    private final Type bodyJavaType;
    private final BitSet expectedStatusCodes;
    private final Type returnType;
    private final Type returnValueWireType;
    private final UnexpectedResponseExceptionType[] unexpectedResponseExceptionTypes;
    private final int contextPosition;
    private final int requestOptionsPosition;
    private final boolean isReactive;
    private final boolean isStreamResponse;
    private final boolean returnTypeDecodeable;
    private final boolean responseEagerlyRead;
    private final boolean ignoreResponseBody;
    private final boolean headersEagerlyConverted;
    private final String spanName;
    private Map<Integer, UnexpectedExceptionInformation> exceptionMapping;
    private UnexpectedExceptionInformation defaultException;

    public SwaggerMethodParser(Method method) {
        this(SwaggerInterfaceParser.getInstance(method.getDeclaringClass()), method);
    }

    SwaggerMethodParser(SwaggerInterfaceParser swaggerInterfaceParser, Method method) {
        Class<?> clazz;
        int n2;
        int n3;
        Annotation[] annotationArray;
        Object object;
        int n4;
        Object object2;
        Object object3;
        this.rawHost = swaggerInterfaceParser.getHost();
        Class<?> clazz2 = method.getDeclaringClass();
        this.fullyQualifiedMethodName = clazz2.getName() + "." + method.getName();
        if (method.isAnnotationPresent(Get.class)) {
            this.httpMethod = HttpMethod.GET;
            this.relativePath = method.getAnnotation(Get.class).value();
        } else if (method.isAnnotationPresent(Put.class)) {
            this.httpMethod = HttpMethod.PUT;
            this.relativePath = method.getAnnotation(Put.class).value();
        } else if (method.isAnnotationPresent(Head.class)) {
            this.httpMethod = HttpMethod.HEAD;
            this.relativePath = method.getAnnotation(Head.class).value();
        } else if (method.isAnnotationPresent(Delete.class)) {
            this.httpMethod = HttpMethod.DELETE;
            this.relativePath = method.getAnnotation(Delete.class).value();
        } else if (method.isAnnotationPresent(Post.class)) {
            this.httpMethod = HttpMethod.POST;
            this.relativePath = method.getAnnotation(Post.class).value();
        } else if (method.isAnnotationPresent(Patch.class)) {
            this.httpMethod = HttpMethod.PATCH;
            this.relativePath = method.getAnnotation(Patch.class).value();
        } else if (method.isAnnotationPresent(Options.class)) {
            this.httpMethod = HttpMethod.OPTIONS;
            this.relativePath = method.getAnnotation(Options.class).value();
        } else {
            throw new MissingRequiredAnnotationException(REQUIRED_HTTP_METHODS, method);
        }
        this.returnType = method.getGenericReturnType();
        ReturnValueWireType returnValueWireType = method.getAnnotation(ReturnValueWireType.class);
        this.returnValueWireType = returnValueWireType != null ? ((object3 = returnValueWireType.value()) == Base64Url.class || object3 == DateTimeRfc1123.class ? object3 : (TypeUtil.isTypeOrSubTypeOf(object3, List.class) ? ((Class)object3).getGenericInterfaces()[0] : (TypeUtil.isTypeOrSubTypeOf((Type)object3, Page.class) ? object3 : null))) : null;
        if (method.isAnnotationPresent(Headers.class)) {
            object3 = method.getAnnotation(Headers.class);
            String[] stringArray = object2 = object3.value();
            n4 = stringArray.length;
            for (object = 0; object < n4; ++object) {
                String string;
                String string2 = stringArray[object];
                int n5 = string2.indexOf(":");
                if (n5 < 0 || (annotationArray = string2.substring(0, n5).trim()).isEmpty() || (string = string2.substring(n5 + 1).trim()).isEmpty()) continue;
                if (string.contains(",")) {
                    this.headers.set((String)annotationArray, Arrays.asList(string.split(",")));
                    continue;
                }
                this.headers.set((String)annotationArray, string);
            }
        }
        if ((object3 = method.getAnnotation(ExpectedResponses.class)) != null && object3.value().length > 0) {
            this.expectedStatusCodes = new BitSet();
            object2 = object3.value();
            int n6 = ((String[])object2).length;
            for (n4 = 0; n4 < n6; ++n4) {
                object = object2[n4];
                this.expectedStatusCodes.set((int)object);
            }
        } else {
            this.expectedStatusCodes = null;
        }
        this.unexpectedResponseExceptionTypes = (UnexpectedResponseExceptionType[])method.getAnnotationsByType(UnexpectedResponseExceptionType.class);
        object2 = null;
        String string = null;
        Object object4 = null;
        Annotation[][] annotationArray2 = method.getParameterAnnotations();
        for (n3 = 0; n3 < annotationArray2.length; ++n3) {
            Annotation[] annotationArray3;
            annotationArray = annotationArray3 = method.getParameterAnnotations()[n3];
            int n7 = annotationArray.length;
            for (n2 = 0; n2 < n7; ++n2) {
                Annotation annotation;
                clazz = annotationArray[n2];
                Class<? extends Annotation> clazz3 = clazz.annotationType();
                if (clazz3.equals(HostParam.class)) {
                    annotation = (HostParam)((Object)clazz);
                    this.hostSubstitutions.addAll(RangeReplaceSubstitution.getRangeReplaceSubstitutions(annotation.value(), n3, !annotation.encoded(), this.rawHost));
                    continue;
                }
                if (clazz3.equals(PathParam.class)) {
                    annotation = (PathParam)((Object)clazz);
                    this.pathSubstitutions.addAll(RangeReplaceSubstitution.getRangeReplaceSubstitutions(annotation.value(), n3, !annotation.encoded(), this.relativePath));
                    continue;
                }
                if (clazz3.equals(QueryParam.class)) {
                    annotation = (QueryParam)((Object)clazz);
                    this.querySubstitutions.add(new QuerySubstitution(annotation.value(), n3, !annotation.encoded(), annotation.multipleQueryParams()));
                    continue;
                }
                if (clazz3.equals(HeaderParam.class)) {
                    annotation = (HeaderParam)((Object)clazz);
                    this.headerSubstitutions.add(new HeaderSubstitution(annotation.value(), n3, false));
                    continue;
                }
                if (clazz3.equals(BodyParam.class)) {
                    annotation = (BodyParam)((Object)clazz);
                    object2 = n3;
                    string = annotation.value();
                    object4 = method.getGenericParameterTypes()[n3];
                    continue;
                }
                if (!clazz3.equals(FormParam.class)) continue;
                annotation = (FormParam)((Object)clazz);
                this.formSubstitutions.add(new Substitution(annotation.value(), n3, !annotation.encoded()));
                string = "application/x-www-form-urlencoded";
                object4 = String.class;
            }
        }
        this.hostSubstitutions.sort(RangeReplaceSubstitution::compareTo);
        this.pathSubstitutions.sort(RangeReplaceSubstitution::compareTo);
        this.bodyContentMethodParameterIndex = object2;
        this.bodyContentType = string;
        this.bodyJavaType = object4;
        n3 = this.isReactiveType(this.returnType) ? 1 : 0;
        Class<?>[] classArray = method.getParameterTypes();
        int n8 = -1;
        int n9 = -1;
        for (n2 = 0; n2 < classArray.length; ++n2) {
            clazz = classArray[n2];
            if (clazz == Context.class && n8 == -1) {
                n8 = n2;
            } else if (clazz == RequestOptions.class && n9 == -1) {
                n9 = n2;
            }
            n3 = n3 != 0 || this.isReactiveType(clazz) ? 1 : 0;
        }
        this.isReactive = n3;
        if (n3 != 0) {
            Type type = TypeUtil.getTypeArgument(this.returnType);
            this.isStreamResponse = this.isStreamResponseType(type);
            this.headersEagerlyConverted = TypeUtil.isTypeOrSubTypeOf(ResponseBase.class, type);
        } else {
            this.isStreamResponse = this.isStreamResponseType(this.returnType);
            this.headersEagerlyConverted = TypeUtil.isTypeOrSubTypeOf(ResponseBase.class, this.returnType);
        }
        this.contextPosition = n8;
        this.requestOptionsPosition = n9;
        Type type = SwaggerMethodParser.unwrapReturnType(this.returnType);
        this.returnTypeDecodeable = SwaggerMethodParser.isReturnTypeDecodeable(type);
        this.responseEagerlyRead = SwaggerMethodParser.isResponseEagerlyRead(type);
        this.ignoreResponseBody = SwaggerMethodParser.isResponseBodyIgnored(type);
        this.spanName = swaggerInterfaceParser.getServiceName() + "." + method.getName();
        RestProxyUtils.validateResumeOperationIsNotPresent(method);
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setSchemeAndHost(Object[] objectArray, UrlBuilder urlBuilder, SerializerAdapter serializerAdapter) {
        SwaggerMethodParser.setSchemeAndHost(this.rawHost, this.hostSubstitutions, objectArray, urlBuilder, serializerAdapter);
    }

    static void setSchemeAndHost(String string, List<RangeReplaceSubstitution> list, Object[] objectArray, UrlBuilder urlBuilder, SerializerAdapter serializerAdapter) {
        String string2 = SwaggerMethodParser.applySubstitutions(string, list, objectArray, serializerAdapter);
        int n2 = string2.indexOf("://");
        if (n2 == -1) {
            urlBuilder.setHost(string2);
        } else {
            urlBuilder.setScheme(string2.substring(0, n2));
            String string3 = string2.substring(n2 + 3);
            if (!CoreUtils.isNullOrEmpty(string3)) {
                urlBuilder.setHost(string3);
            } else {
                urlBuilder.setHost(string2);
            }
        }
    }

    public String setPath(Object[] objectArray, SerializerAdapter serializerAdapter) {
        return SwaggerMethodParser.applySubstitutions(this.relativePath, this.pathSubstitutions, objectArray, serializerAdapter);
    }

    public void setEncodedQueryParameters(Object[] objectArray, UrlBuilder urlBuilder, SerializerAdapter serializerAdapter) {
        if (objectArray == null) {
            return;
        }
        for (QuerySubstitution querySubstitution : this.querySubstitutions) {
            int n2 = querySubstitution.getMethodParameterIndex();
            if (0 > n2 || n2 >= objectArray.length) continue;
            Object object = objectArray[querySubstitution.getMethodParameterIndex()];
            if (querySubstitution.mergeParameters() && object instanceof List) {
                List list = (List)object;
                for (Object e2 : list) {
                    SwaggerMethodParser.addSerializedQueryParameter(serializerAdapter, e2, querySubstitution.shouldEncode(), urlBuilder, querySubstitution.getUrlParameterName());
                }
                continue;
            }
            SwaggerMethodParser.addSerializedQueryParameter(serializerAdapter, object, querySubstitution.shouldEncode(), urlBuilder, querySubstitution.getUrlParameterName());
        }
    }

    public void setHeaders(Object[] objectArray, HttpHeaders httpHeaders, SerializerAdapter serializerAdapter) {
        httpHeaders.setAllHttpHeaders(this.headers);
        if (objectArray == null) {
            return;
        }
        for (HeaderSubstitution headerSubstitution : this.headerSubstitutions) {
            Object object;
            int n2 = headerSubstitution.getMethodParameterIndex();
            if (0 > n2 || n2 >= objectArray.length) continue;
            Object object2 = objectArray[headerSubstitution.getMethodParameterIndex()];
            if (object2 instanceof Map) {
                object = (Map)object2;
                String string = headerSubstitution.getUrlParameterName();
                for (Map.Entry entry : object.entrySet()) {
                    String string2 = string + (String)entry.getKey();
                    String string3 = SwaggerMethodParser.serialize(serializerAdapter, entry.getValue());
                    if (string3 == null) continue;
                    httpHeaders.set(string2, string3);
                }
                continue;
            }
            object = SwaggerMethodParser.serialize(serializerAdapter, object2);
            if (object == null) continue;
            httpHeaders.set(headerSubstitution.getHeaderName(), (String)object);
        }
    }

    public Context setContext(Object[] objectArray) {
        if (this.contextPosition < 0) {
            return Context.NONE;
        }
        Context context = (Context)objectArray[this.contextPosition];
        return context != null ? context : Context.NONE;
    }

    public RequestOptions setRequestOptions(Object[] objectArray) {
        return this.requestOptionsPosition < 0 ? null : (RequestOptions)objectArray[this.requestOptionsPosition];
    }

    @Override
    public boolean isExpectedResponseStatusCode(int n2) {
        return this.expectedStatusCodes == null ? n2 < 400 : this.expectedStatusCodes.get(n2);
    }

    @Override
    public UnexpectedExceptionInformation getUnexpectedException(int n2) {
        if (this.exceptionMapping == null) {
            this.exceptionMapping = this.processUnexpectedResponseExceptionTypes();
        }
        return this.exceptionMapping.getOrDefault(n2, this.defaultException);
    }

    public Object setBody(Object[] objectArray, SerializerAdapter serializerAdapter) {
        Object object = null;
        if (this.bodyContentMethodParameterIndex != null && objectArray != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < objectArray.length) {
            object = objectArray[this.bodyContentMethodParameterIndex];
        }
        if (!CoreUtils.isNullOrEmpty(this.formSubstitutions) && objectArray != null) {
            object = this.formSubstitutions.stream().map(substitution -> SwaggerMethodParser.serializeFormData(serializerAdapter, substitution.getUrlParameterName(), objectArray[substitution.getMethodParameterIndex()], substitution.shouldEncode())).filter(Objects::nonNull).collect(Collectors.joining("&"));
        }
        return object;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    public Type getBodyJavaType() {
        return this.bodyJavaType;
    }

    @Override
    public Type getReturnValueWireType() {
        return this.returnValueWireType;
    }

    private static void addSerializedQueryParameter(SerializerAdapter serializerAdapter, Object object, boolean bl2, UrlBuilder urlBuilder, String string) {
        String string2 = SwaggerMethodParser.serialize(serializerAdapter, object);
        if (string2 != null) {
            if (bl2) {
                string2 = UrlEscapers.QUERY_ESCAPER.escape(string2);
            }
            urlBuilder.addQueryParameter(string, string2);
        }
    }

    private static String serialize(SerializerAdapter serializerAdapter, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object.getClass().isPrimitive() || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof DateTimeRfc1123) {
            return String.valueOf(object);
        }
        if (object instanceof OffsetDateTime) {
            return ((OffsetDateTime)object).format(DateTimeFormatter.ISO_INSTANT);
        }
        if (object instanceof ExpandableStringEnum || object.getClass().isEnum()) {
            String string = object.toString();
            return string == null ? "null" : string;
        }
        return serializerAdapter.serializeRaw(object);
    }

    private static String serializeFormData(SerializerAdapter serializerAdapter, String string, Object object2, boolean bl2) {
        if (object2 == null) {
            return null;
        }
        String string3 = UrlEscapers.FORM_ESCAPER.escape(string);
        if (object2 instanceof List) {
            return ((List)object2).stream().map(object -> SwaggerMethodParser.serializeAndEncodeFormValue(serializerAdapter, object, bl2)).filter(Objects::nonNull).map(string2 -> string3 + "=" + string2).collect(Collectors.joining("&"));
        }
        return string3 + "=" + SwaggerMethodParser.serializeAndEncodeFormValue(serializerAdapter, object2, bl2);
    }

    private static String serializeAndEncodeFormValue(SerializerAdapter serializerAdapter, Object object, boolean bl2) {
        if (object == null) {
            return null;
        }
        String string = SwaggerMethodParser.serialize(serializerAdapter, object);
        return bl2 ? UrlEscapers.FORM_ESCAPER.escape(string) : string;
    }

    private static String applySubstitutions(String string, List<RangeReplaceSubstitution> list, Object[] objectArray, SerializerAdapter serializerAdapter) {
        int n2;
        if (objectArray == null || CoreUtils.isNullOrEmpty(list)) {
            return string;
        }
        int n3 = n2 = string.length();
        ArrayList<AbstractMap.SimpleEntry<RangeReplaceSubstitution, String>> arrayList = new ArrayList<AbstractMap.SimpleEntry<RangeReplaceSubstitution, String>>(list.size());
        for (RangeReplaceSubstitution comparable2 : list) {
            int n4 = comparable2.getMethodParameterIndex();
            if (n4 < 0 || n4 >= objectArray.length) continue;
            Object object = objectArray[n4];
            String string2 = SwaggerMethodParser.serialize(serializerAdapter, object);
            if (string2 != null && !string2.isEmpty() && comparable2.shouldEncode()) {
                string2 = UrlEscapers.PATH_ESCAPER.escape(string2);
            }
            if (string2 == null) {
                string2 = "";
            }
            n3 += string2.length() - comparable2.getSize();
            arrayList.add(new AbstractMap.SimpleEntry<RangeReplaceSubstitution, String>(comparable2, string2));
        }
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (Map.Entry entry : arrayList) {
            if (n5 < ((RangeReplaceSubstitution)entry.getKey()).getStart()) {
                stringBuilder.append(string, n5, ((RangeReplaceSubstitution)entry.getKey()).getStart());
            }
            stringBuilder.append((String)entry.getValue());
            n5 = ((RangeReplaceSubstitution)entry.getKey()).getEnd();
        }
        if (n5 < n2) {
            stringBuilder.append(string, n5, n2);
        }
        return stringBuilder.toString();
    }

    private Map<Integer, UnexpectedExceptionInformation> processUnexpectedResponseExceptionTypes() {
        HashMap<Integer, UnexpectedExceptionInformation> hashMap = new HashMap<Integer, UnexpectedExceptionInformation>();
        for (UnexpectedResponseExceptionType unexpectedResponseExceptionType : this.unexpectedResponseExceptionTypes) {
            UnexpectedExceptionInformation unexpectedExceptionInformation = new UnexpectedExceptionInformation(unexpectedResponseExceptionType.value());
            if (unexpectedResponseExceptionType.code().length == 0) {
                this.defaultException = unexpectedExceptionInformation;
                continue;
            }
            for (int n2 : unexpectedResponseExceptionType.code()) {
                hashMap.put(n2, unexpectedExceptionInformation);
            }
        }
        if (this.defaultException == null) {
            this.defaultException = new UnexpectedExceptionInformation(HttpResponseException.class);
        }
        return hashMap;
    }

    public boolean isReactive() {
        return this.isReactive;
    }

    boolean isReactiveType(Type type) {
        return TypeUtil.isTypeOrSubTypeOf(type, Mono.class) || TypeUtil.isTypeOrSubTypeOf(type, Flux.class) || TypeUtil.isTypeOrSubTypeOf(type, Publisher.class);
    }

    boolean isStreamResponseType(Type type) {
        return TypeUtil.getRawClass(type).equals(StreamResponse.class);
    }

    public boolean isStreamResponse() {
        return this.isStreamResponse;
    }

    @Override
    public boolean isReturnTypeDecodeable() {
        return this.returnTypeDecodeable;
    }

    @Override
    public boolean isResponseEagerlyRead() {
        return this.responseEagerlyRead;
    }

    @Override
    public boolean isResponseBodyIgnored() {
        return this.ignoreResponseBody;
    }

    @Override
    public boolean isHeadersEagerlyConverted() {
        return this.headersEagerlyConverted;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public static boolean isReturnTypeDecodeable(Type type) {
        if (type == null) {
            return false;
        }
        return !TypeUtil.isTypeOrSubTypeOf(type, BinaryData.class) && !TypeUtil.isTypeOrSubTypeOf(type, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(type, ByteBuffer.class) && !TypeUtil.isTypeOrSubTypeOf(type, InputStream.class) && !TypeUtil.isTypeOrSubTypeOf(type, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(type, Void.class);
    }

    public static boolean isResponseBodyIgnored(Type type) {
        if (type == null) {
            return false;
        }
        return TypeUtil.isTypeOrSubTypeOf(type, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(type, Void.class);
    }

    public static boolean isResponseEagerlyRead(Type type) {
        if (type == null) {
            return false;
        }
        return SwaggerMethodParser.isReturnTypeDecodeable(type);
    }

    public static Type unwrapReturnType(Type type2) {
        if (type2 == null) {
            return null;
        }
        if (TypeUtil.isTypeOrSubTypeOf(type2, ResponseBase.class)) {
            type2 = SwaggerMethodParser.walkSuperTypesUntil(type2, type -> TypeUtil.getRawClass(type) == ResponseBase.class);
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArguments(type2)[1]);
        }
        if (TypeUtil.isTypeOrSubTypeOf(type2, Response.class)) {
            type2 = SwaggerMethodParser.walkSuperTypesUntil(type2, type -> TypeUtil.typeImplementsInterface(type, Response.class));
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(type2));
        }
        if (TypeUtil.isTypeOrSubTypeOf(type2, Mono.class)) {
            type2 = SwaggerMethodParser.walkSuperTypesUntil(type2, type -> TypeUtil.getRawClass(type) == Mono.class);
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(type2));
        }
        if (TypeUtil.isTypeOrSubTypeOf(type2, Flux.class)) {
            type2 = SwaggerMethodParser.walkSuperTypesUntil(type2, type -> TypeUtil.getRawClass(type) == Flux.class);
            return SwaggerMethodParser.unwrapReturnType(TypeUtil.getTypeArgument(type2));
        }
        return type2;
    }

    private static Type walkSuperTypesUntil(Type type, Predicate<Type> predicate) {
        while (!predicate.test(type)) {
            type = TypeUtil.getSuperType(type);
        }
        return type;
    }
}

