/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.Host;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.ServiceInterface;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.MissingRequiredAnnotationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerMethodParser;

public final class SwaggerInterfaceParser {
    private static final Map<Class<?>, SwaggerInterfaceParser> INTERFACE_PARSERS = new ConcurrentHashMap();
    private final String host;
    private final String serviceName;
    private final Map<Method, SwaggerMethodParser> methodParsers = new ConcurrentHashMap<Method, SwaggerMethodParser>();

    public static SwaggerInterfaceParser getInstance(Class<?> clazz) {
        if (INTERFACE_PARSERS.size() >= 10000) {
            INTERFACE_PARSERS.clear();
        }
        return INTERFACE_PARSERS.computeIfAbsent(clazz, SwaggerInterfaceParser::new);
    }

    SwaggerInterfaceParser(Class<?> clazz) {
        Host host = clazz.getAnnotation(Host.class);
        if (host == null || host.value().isEmpty()) {
            throw new MissingRequiredAnnotationException(Host.class, clazz);
        }
        this.host = host.value();
        ServiceInterface serviceInterface = clazz.getAnnotation(ServiceInterface.class);
        if (serviceInterface == null || serviceInterface.name().isEmpty()) {
            throw new MissingRequiredAnnotationException(ServiceInterface.class, clazz);
        }
        this.serviceName = serviceInterface.name();
    }

    public SwaggerMethodParser getMethodParser(Method method2) {
        return this.methodParsers.computeIfAbsent(method2, method -> new SwaggerMethodParser(this, (Method)method));
    }

    public String getHost() {
        return this.host;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

