/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.policy;

import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.UrlSanitizer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.SpanKind;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.StartSpanOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.Tracer;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class InstrumentationPolicy
implements HttpPipelinePolicy {
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    private static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";
    private static final String HTTP_RESEND_COUNT = "http.request.resend_count";
    private static final String SERVER_ADDRESS = "server.address";
    private static final String SERVER_PORT = "server.port";
    private static final ClientLogger LOGGER = new ClientLogger(InstrumentationPolicy.class);
    private static final String OTHER_ERROR_TYPE = "_OTHER";
    private UrlSanitizer urlSanitizer;
    private Tracer tracer;

    public void initialize(Tracer tracer, UrlSanitizer urlSanitizer) {
        this.tracer = tracer;
        this.urlSanitizer = urlSanitizer;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        if (!this.isTracingEnabled(httpPipelineCallContext)) {
            return httpPipelineNextPolicy.process();
        }
        return Mono.using(() -> this.startSpan(httpPipelineCallContext), context -> httpPipelineNextPolicy.process().map(httpResponse -> {
            this.onResponseCode((HttpResponse)httpResponse, (Context)context);
            return TraceableResponse.create(httpResponse, this.tracer, context);
        }).doOnCancel(() -> this.tracer.end("cancelled", null, (Context)context)).doOnError(throwable -> this.tracer.end(null, (Throwable)throwable, (Context)context)), context -> {});
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        HttpResponse httpResponse;
        block10: {
            if (!this.isTracingEnabled(httpPipelineCallContext)) {
                return httpPipelineNextSyncPolicy.processSync();
            }
            Context context = this.startSpan(httpPipelineCallContext);
            AutoCloseable autoCloseable = this.tracer.makeSpanCurrent(context);
            try {
                HttpResponse httpResponse2 = httpPipelineNextSyncPolicy.processSync();
                this.onResponseCode(httpResponse2, context);
                httpResponse = TraceableResponse.create(httpResponse2, this.tracer, context);
                if (autoCloseable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (autoCloseable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.tracer.end(null, (Throwable)runtimeException, context);
                    throw runtimeException;
                }
                catch (Exception exception) {
                    this.tracer.end(null, (Throwable)exception, context);
                    throw LOGGER.logExceptionAsWarning(new RuntimeException(exception));
                }
            }
            autoCloseable.close();
        }
        return httpResponse;
    }

    private Context startSpan(HttpPipelineCallContext httpPipelineCallContext) {
        HttpRequest httpRequest = httpPipelineCallContext.getHttpRequest();
        String string3 = httpRequest.getHttpMethod().toString();
        StartSpanOptions startSpanOptions = new StartSpanOptions(SpanKind.CLIENT).setAttribute(HTTP_METHOD, string3).setAttribute(HTTP_URL, this.urlSanitizer.getRedactedUrl(httpRequest.getUrl())).setAttribute(SERVER_ADDRESS, httpRequest.getUrl().getHost()).setAttribute(SERVER_PORT, InstrumentationPolicy.getPort(httpRequest.getUrl()));
        Context context = this.tracer.start(string3, startSpanOptions, httpPipelineCallContext.getContext());
        this.addPostSamplingAttributes(context, httpRequest);
        this.tracer.injectContext((string, string2) -> httpRequest.getHeaders().set((String)string, (String)string2), context);
        return context;
    }

    private static int getPort(URL uRL) {
        int n2 = uRL.getPort();
        if (n2 == -1) {
            n2 = uRL.getDefaultPort();
        }
        return n2;
    }

    private void addPostSamplingAttributes(Context context, HttpRequest httpRequest) {
        String string;
        Object var3_3 = context.getData("requestRetryCount").orElse(null);
        if (var3_3 instanceof Integer && (Integer)var3_3 > 0) {
            this.tracer.setAttribute(HTTP_RESEND_COUNT, ((Integer)var3_3).longValue(), context);
        }
        if (!CoreUtils.isNullOrEmpty(string = httpRequest.getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID))) {
            this.tracer.setAttribute(CLIENT_REQUEST_ID_ATTRIBUTE, string, context);
        }
    }

    private void onResponseCode(HttpResponse httpResponse, Context context) {
        if (httpResponse != null && this.tracer.isRecording(context)) {
            int n2 = httpResponse.getStatusCode();
            this.tracer.setAttribute(HTTP_STATUS_CODE, n2, context);
            String string = httpResponse.getHeaderValue(HttpHeaderName.X_MS_REQUEST_ID);
            if (string != null) {
                this.tracer.setAttribute(SERVICE_REQUEST_ID_ATTRIBUTE, string, context);
            }
        }
    }

    private boolean isTracingEnabled(HttpPipelineCallContext httpPipelineCallContext) {
        return this.tracer != null && this.tracer.isEnabled() && (Boolean)httpPipelineCallContext.getData("disable-tracing").orElse(false) == false;
    }

    private static final class TraceableResponse
    extends HttpResponse {
        private final HttpResponse response;
        private final Context span;
        private final Tracer tracer;
        private volatile int ended = 0;
        private static final AtomicIntegerFieldUpdater<TraceableResponse> ENDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TraceableResponse.class, "ended");

        private TraceableResponse(HttpResponse httpResponse, Tracer tracer, Context context) {
            super(httpResponse.getRequest());
            this.response = httpResponse;
            this.span = context;
            this.tracer = tracer;
        }

        public static HttpResponse create(HttpResponse httpResponse, Tracer tracer, Context context) {
            if (tracer.isRecording(context)) {
                return new TraceableResponse(httpResponse, tracer, context);
            }
            tracer.end(null, null, context);
            return httpResponse;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusCode();
        }

        @Override
        @Deprecated
        public String getHeaderValue(String string) {
            return this.response.getHeaderValue(string);
        }

        @Override
        public String getHeaderValue(HttpHeaderName httpHeaderName) {
            return this.response.getHeaderValue(httpHeaderName);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            return Flux.using(() -> this.span, context -> this.response.getBody().doOnError(throwable -> this.onError(null, (Throwable)throwable)).doOnCancel(() -> this.onError("cancelled", null)), context -> this.endNoError());
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return this.endSpanWhen(this.response.getBodyAsByteArray());
        }

        @Override
        public Mono<String> getBodyAsString() {
            return this.endSpanWhen(this.response.getBodyAsString());
        }

        @Override
        public BinaryData getBodyAsBinaryData() {
            try {
                BinaryData binaryData = this.response.getBodyAsBinaryData();
                return binaryData;
            }
            catch (Exception exception) {
                this.onError(null, exception);
                throw exception;
            }
            finally {
                this.endNoError();
            }
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return this.endSpanWhen(this.response.getBodyAsString(charset));
        }

        @Override
        public Mono<InputStream> getBodyAsInputStream() {
            return this.endSpanWhen(this.response.getBodyAsInputStream());
        }

        @Override
        public void close() {
            this.response.close();
            this.endNoError();
        }

        private <T> Mono<T> endSpanWhen(Mono<T> mono) {
            return Mono.using(() -> this.span, context -> mono.doOnError(throwable -> this.onError(null, (Throwable)throwable)).doOnCancel(() -> this.onError("cancelled", null)), context -> this.endNoError());
        }

        private void onError(String string, Throwable throwable) {
            if (ENDED_UPDATER.compareAndSet(this, 0, 1)) {
                this.tracer.end(string, throwable, this.span);
            }
        }

        private void endNoError() {
            if (ENDED_UPDATER.compareAndSet(this, 0, 1)) {
                String string = null;
                if (this.response == null) {
                    string = InstrumentationPolicy.OTHER_ERROR_TYPE;
                } else if (this.response.getStatusCode() >= 400) {
                    string = String.valueOf(this.response.getStatusCode());
                }
                this.tracer.end(string, null, this.span);
            }
        }
    }
}

