/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;

public final class UrlSanitizer {
    static final Set<String> DEFAULT_QUERY_PARAMS_ALLOWLIST = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("api-version")));
    private final Set<String> allowedQueryParamNames;

    public UrlSanitizer(Collection<String> collection) {
        if (collection == null) {
            this.allowedQueryParamNames = DEFAULT_QUERY_PARAMS_ALLOWLIST;
        } else {
            this.allowedQueryParamNames = collection.stream().map(string -> string.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.allowedQueryParamNames.addAll(DEFAULT_QUERY_PARAMS_ALLOWLIST);
        }
    }

    public String getRedactedUrl(URL uRL) {
        String string = uRL.getQuery();
        if (CoreUtils.isNullOrEmpty(string)) {
            return uRL.toString();
        }
        UrlBuilder urlBuilder = ImplUtils.parseUrl(uRL, false);
        CoreUtils.parseQueryParameters(string).forEachRemaining(entry -> {
            if (this.allowedQueryParamNames.contains(((String)entry.getKey()).toLowerCase(Locale.ROOT))) {
                urlBuilder.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
            } else {
                urlBuilder.addQueryParameter((String)entry.getKey(), "REDACTED");
            }
        });
        return urlBuilder.toString();
    }
}

