/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class StringBuilderWriter
extends Writer {
    private static final ClientLogger LOGGER = new ClientLogger(StringBuilderWriter.class);
    private final StringBuilder builder;
    private boolean closed = false;

    public StringBuilderWriter(StringBuilder stringBuilder) {
        this.builder = Objects.requireNonNull(stringBuilder, "'builder' cannot be null.");
    }

    @Override
    public void write(int n2) throws IOException {
        this.ensureOpen();
        this.builder.append(n2);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.ensureOpen();
        this.builder.append(cArray);
    }

    @Override
    public void write(String string) throws IOException {
        this.ensureOpen();
        this.builder.append(string);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.ensureOpen();
        this.builder.append(string, n2, n3);
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.ensureOpen();
        this.builder.append(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) throws IOException {
        this.ensureOpen();
        this.builder.append(charSequence, n2, n3);
        return this;
    }

    @Override
    public Writer append(char c2) throws IOException {
        this.ensureOpen();
        this.builder.append(c2);
        return this;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        this.builder.append(cArray, n2, n3);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.builder.toString();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw LOGGER.logThrowableAsError(new IOException("Writer has been closed."));
        }
    }
}

