/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AccessController;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.MethodHandleReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtilsApi;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

final class ReflectionUtilsMethodHandle
implements ReflectionUtilsApi {
    private static final ClientLogger LOGGER;
    private static final boolean MODULE_BASED;
    private static final MethodHandle CLASS_GET_MODULE_METHOD_HANDLE;
    private static final MethodHandle MODULE_IS_NAMED_METHOD_HANDLE;
    private static final MethodHandle MODULE_ADD_READS_METHOD_HANDLE;
    private static final MethodHandle METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE;
    private static final MethodHandle MODULE_IS_OPEN_UNCONDITIONALLY_METHOD_HANDLE;
    private static final MethodHandle MODULE_IS_OPEN_TO_OTHER_MODULE_METHOD_HANDLE;
    private static final MethodHandles.Lookup LOOKUP;
    private static final Object CORE_MODULE;
    private static final MethodHandle JDK_INTERNAL_PRIVATE_LOOKUP_IN_CONSTRUCTOR;

    ReflectionUtilsMethodHandle() {
    }

    @Override
    public ReflectiveInvoker getMethodInvoker(Class<?> clazz, Method method, boolean bl2) throws Exception {
        MethodHandles.Lookup lookup = ReflectionUtilsMethodHandle.getLookupToUse(clazz, bl2);
        return new MethodHandleReflectiveInvoker(lookup.unreflect(method));
    }

    @Override
    public ReflectiveInvoker getConstructorInvoker(Class<?> clazz, Constructor<?> constructor, boolean bl2) throws Exception {
        MethodHandles.Lookup lookup = ReflectionUtilsMethodHandle.getLookupToUse(clazz, bl2);
        return new MethodHandleReflectiveInvoker(lookup.unreflectConstructor(constructor));
    }

    @Override
    public boolean isModuleBased() {
        return MODULE_BASED;
    }

    private static MethodHandles.Lookup getLookupToUse(Class<?> clazz, boolean bl2) throws Exception {
        try {
            if (MODULE_BASED) {
                if (!bl2) {
                    return MethodHandles.publicLookup();
                }
                Object object = CLASS_GET_MODULE_METHOD_HANDLE.invoke(clazz);
                if (!MODULE_IS_NAMED_METHOD_HANDLE.invoke(object)) {
                    MODULE_ADD_READS_METHOD_HANDLE.invokeWithArguments(CORE_MODULE, object);
                    return ReflectionUtilsMethodHandle.performSafePrivateLookupIn(clazz);
                }
                if (object == CORE_MODULE) {
                    return LOOKUP;
                }
                String string = clazz.getPackage().getName();
                if (((Boolean)MODULE_IS_OPEN_UNCONDITIONALLY_METHOD_HANDLE.invokeWithArguments(object, string)).booleanValue() || ((Boolean)MODULE_IS_OPEN_TO_OTHER_MODULE_METHOD_HANDLE.invokeWithArguments(object, string, CORE_MODULE)).booleanValue()) {
                    MODULE_ADD_READS_METHOD_HANDLE.invokeWithArguments(CORE_MODULE, object);
                    return ReflectionUtilsMethodHandle.performSafePrivateLookupIn(clazz);
                }
                return MethodHandles.publicLookup();
            }
            return JDK_INTERNAL_PRIVATE_LOOKUP_IN_CONSTRUCTOR.invoke(clazz);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
    }

    private static MethodHandles.Lookup performSafePrivateLookupIn(Class<?> clazz) throws Throwable {
        if (System.getSecurityManager() == null) {
            return METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE.invokeExact(clazz, LOOKUP);
        }
        return AccessController.doPrivileged(() -> {
            try {
                return METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE.invokeExact(clazz, LOOKUP);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw (Exception)throwable;
            }
        });
    }

    static {
        GenericDeclaration genericDeclaration;
        LOGGER = new ClientLogger(ReflectionUtilsMethodHandle.class);
        boolean bl2 = false;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        MethodHandle methodHandle4 = null;
        MethodHandle methodHandle5 = null;
        MethodHandle methodHandle6 = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object object = null;
        MethodHandle methodHandle7 = null;
        try {
            genericDeclaration = Class.forName("java.lang.Module");
            methodHandle = lookup.unreflect(Class.class.getDeclaredMethod("getModule", new Class[0]));
            methodHandle2 = lookup.unreflect(((Class)genericDeclaration).getDeclaredMethod("isNamed", new Class[0]));
            methodHandle3 = lookup.unreflect(((Class)genericDeclaration).getDeclaredMethod("addReads", new Class[]{genericDeclaration}));
            methodHandle4 = lookup.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
            methodHandle5 = lookup.unreflect(((Class)genericDeclaration).getDeclaredMethod("isOpen", String.class));
            methodHandle6 = lookup.unreflect(((Class)genericDeclaration).getDeclaredMethod("isOpen", new Class[]{String.class, genericDeclaration}));
            object = methodHandle.invokeWithArguments(ReflectionUtils.class);
            bl2 = true;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "Unable to create MethodHandles to use Java 9+ MethodHandles.privateLookupIn. Will attempt to fallback to using the package-private constructor.", throwable);
        }
        if (!bl2) {
            try {
                genericDeclaration = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                if (!((AccessibleObject)((Object)genericDeclaration)).isAccessible()) {
                    ((Constructor)genericDeclaration).setAccessible(true);
                }
                methodHandle7 = lookup.unreflectConstructor((Constructor<?>)genericDeclaration);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Unable to use package-private MethodHandles.Lookup constructor.", reflectiveOperationException));
            }
        }
        MODULE_BASED = bl2;
        CLASS_GET_MODULE_METHOD_HANDLE = methodHandle;
        MODULE_IS_NAMED_METHOD_HANDLE = methodHandle2;
        MODULE_ADD_READS_METHOD_HANDLE = methodHandle3;
        METHOD_HANDLES_PRIVATE_LOOKUP_IN_METHOD_HANDLE = methodHandle4;
        MODULE_IS_OPEN_UNCONDITIONALLY_METHOD_HANDLE = methodHandle5;
        MODULE_IS_OPEN_TO_OTHER_MODULE_METHOD_HANDLE = methodHandle6;
        LOOKUP = lookup;
        CORE_MODULE = object;
        JDK_INTERNAL_PRIVATE_LOOKUP_IN_CONSTRUCTOR = methodHandle7;
    }
}

