/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtilsApi;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtilsClassic;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtilsMethodHandle;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public abstract class ReflectionUtils {
    private static final ClientLogger LOGGER;
    private static final ReflectionUtilsApi INSTANCE;

    public static ReflectiveInvoker getMethodInvoker(Class<?> clazz, Method method) throws Exception {
        return ReflectionUtils.getMethodInvoker(clazz, method, true);
    }

    public static ReflectiveInvoker getMethodInvoker(Class<?> clazz, Method method, boolean bl2) throws Exception {
        if (method == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'method' cannot be null."));
        }
        clazz = clazz == null ? method.getDeclaringClass() : clazz;
        return INSTANCE.getMethodInvoker(clazz, method, bl2);
    }

    public static ReflectiveInvoker getConstructorInvoker(Class<?> clazz, Constructor<?> constructor) throws Exception {
        return ReflectionUtils.getConstructorInvoker(clazz, constructor, true);
    }

    public static ReflectiveInvoker getConstructorInvoker(Class<?> clazz, Constructor<?> constructor, boolean bl2) throws Exception {
        if (constructor == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'constructor' cannot be null."));
        }
        clazz = clazz == null ? constructor.getDeclaringClass() : clazz;
        return INSTANCE.getConstructorInvoker(clazz, constructor, bl2);
    }

    public static boolean isModuleBased() {
        return INSTANCE.isModuleBased();
    }

    public static ReflectiveInvoker createNoOpInvoker() {
        return new NoOpReflectiveInvoker();
    }

    ReflectionUtils() {
    }

    static {
        ReflectionUtilsApi reflectionUtilsApi;
        LOGGER = new ClientLogger(ReflectionUtils.class);
        try {
            LOGGER.verbose("Attempting to use java.lang.invoke package to handle reflection.");
            reflectionUtilsApi = new ReflectionUtilsMethodHandle();
            LOGGER.verbose("Successfully used java.lang.invoke package to handle reflection.");
        }
        catch (LinkageError linkageError) {
            LOGGER.verbose("Failed to use java.lang.invoke package to handle reflection. Falling back to java.lang.reflect package to handle reflection.");
            reflectionUtilsApi = new ReflectionUtilsClassic();
            LOGGER.verbose("Successfully used java.lang.reflect package to handle reflection.");
        }
        INSTANCE = reflectionUtilsApi;
    }

    private static final class NoOpReflectiveInvoker
    implements ReflectiveInvoker {
        private NoOpReflectiveInvoker() {
        }

        @Override
        public Object invokeStatic(Object ... objectArray) {
            return null;
        }

        @Override
        public Object invokeWithArguments(Object object, Object ... objectArray) {
            return null;
        }

        @Override
        public int getParameterCount() {
            return 0;
        }
    }
}

