/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AccessibleByteArrayOutputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonProviders;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class ReflectionSerializable {
    private static final ClientLogger LOGGER = new ClientLogger(ReflectionSerializable.class);
    private static final Map<Class<?>, ReflectiveInvoker> FROM_JSON_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, ReflectiveInvoker> FROM_XML_CACHE = new ConcurrentHashMap();

    public static boolean supportsJsonSerializable(Class<?> clazz) {
        if (FROM_JSON_CACHE.containsKey(clazz)) {
            return true;
        }
        if (!JsonSerializable.class.isAssignableFrom(clazz)) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getName().equals("fromJson") && (method.getModifiers() & 8) != 0 && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JsonReader.class)) {
                bl2 = true;
            } else if (method.getName().equals("toJson") && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JsonWriter.class)) {
                bl3 = true;
            }
            if (!bl2 || !bl3) continue;
            return true;
        }
        return false;
    }

    public static ByteBuffer serializeJsonSerializableToByteBuffer(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeJsonSerializableToBytes(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeJsonSerializableToString(JsonSerializable<?> jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, accessibleByteArrayOutputStream -> accessibleByteArrayOutputStream.toString(StandardCharsets.UTF_8));
    }

    private static <T> T serializeJsonSerializableWithReturn(JsonSerializable<?> jsonSerializable, Function<AccessibleByteArrayOutputStream, T> function) throws IOException {
        try (AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = new AccessibleByteArrayOutputStream();){
            T t2;
            block11: {
                JsonWriter jsonWriter = JsonProviders.createWriter(accessibleByteArrayOutputStream);
                try {
                    jsonWriter.writeJson(jsonSerializable).flush();
                    t2 = function.apply(accessibleByteArrayOutputStream);
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return t2;
        }
    }

    public static void serializeJsonSerializableIntoOutputStream(JsonSerializable<?> jsonSerializable, OutputStream outputStream) throws IOException {
        try (JsonWriter jsonWriter = JsonProviders.createWriter(outputStream);){
            jsonWriter.writeJson(jsonSerializable).flush();
        }
    }

    public static Object deserializeAsJsonSerializable(Class<?> clazz, byte[] byArray) throws IOException {
        Object object;
        block11: {
            if (FROM_JSON_CACHE.size() >= 10000) {
                FROM_JSON_CACHE.clear();
            }
            ReflectiveInvoker reflectiveInvoker = FROM_JSON_CACHE.computeIfAbsent(clazz, clazz2 -> {
                try {
                    return ReflectionUtils.getMethodInvoker(clazz2, clazz.getDeclaredMethod("fromJson", JsonReader.class));
                }
                catch (Exception exception) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(exception));
                }
            });
            JsonReader jsonReader = JsonProviders.createReader(byArray);
            try {
                object = reflectiveInvoker.invokeStatic(jsonReader);
                if (jsonReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (throwable3 instanceof IOException) {
                        throw (IOException)throwable3;
                    }
                    if (throwable3 instanceof Exception) {
                        throw new IOException(throwable3);
                    }
                    throw (Error)throwable3;
                }
            }
            jsonReader.close();
        }
        return object;
    }

    public static boolean supportsXmlSerializable(Class<?> clazz) {
        if (FROM_XML_CACHE.containsKey(clazz)) {
            return true;
        }
        if (!XmlSerializable.class.isAssignableFrom(clazz)) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getName().equals("fromXml") && (method.getModifiers() & 8) != 0 && method.getParameterCount() == 2 && method.getParameterTypes()[0].equals(XmlReader.class) && method.getParameterTypes()[1].equals(String.class)) {
                bl2 = true;
            } else if (method.getName().equals("toXml") && method.getParameterCount() == 2 && method.getParameterTypes()[0].equals(XmlWriter.class) && method.getParameterTypes()[1].equals(String.class)) {
                bl3 = true;
            }
            if (!bl2 || !bl3) continue;
            return true;
        }
        return false;
    }

    public static ByteBuffer serializeXmlSerializableToByteBuffer(XmlSerializable<?> xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeXmlSerializableToBytes(XmlSerializable<?> xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeXmlSerializableToString(XmlSerializable<?> xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, accessibleByteArrayOutputStream -> accessibleByteArrayOutputStream.toString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <T> T serializeXmlSerializableWithReturn(XmlSerializable<?> xmlSerializable, Function<AccessibleByteArrayOutputStream, T> function) throws IOException {
        try (AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = new AccessibleByteArrayOutputStream();){
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream2;
            block13: {
                XmlWriter xmlWriter = XmlWriter.toStream((OutputStream)accessibleByteArrayOutputStream);
                try {
                    xmlWriter.writeStartDocument();
                    xmlWriter.writeXml(xmlSerializable);
                    xmlWriter.flush();
                    accessibleByteArrayOutputStream2 = function.apply(accessibleByteArrayOutputStream);
                    if (xmlWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xmlWriter.close();
            }
            return (T)accessibleByteArrayOutputStream2;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException);
        }
    }

    public static void serializeXmlSerializableIntoOutputStream(XmlSerializable<?> xmlSerializable, OutputStream outputStream) throws IOException {
        try (XmlWriter xmlWriter = XmlWriter.toStream((OutputStream)outputStream);){
            xmlWriter.writeStartDocument();
            xmlWriter.writeXml(xmlSerializable);
            xmlWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException);
        }
    }

    public static Object deserializeAsXmlSerializable(Class<?> clazz, byte[] byArray) throws IOException {
        Object object;
        block11: {
            if (FROM_XML_CACHE.size() >= 10000) {
                FROM_XML_CACHE.clear();
            }
            ReflectiveInvoker reflectiveInvoker = FROM_XML_CACHE.computeIfAbsent(clazz, clazz2 -> {
                try {
                    return ReflectionUtils.getMethodInvoker(clazz, clazz.getDeclaredMethod("fromXml", XmlReader.class));
                }
                catch (Exception exception) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(exception));
                }
            });
            XmlReader xmlReader = XmlReader.fromBytes((byte[])byArray);
            try {
                object = reflectiveInvoker.invokeStatic(xmlReader);
                if (xmlReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (throwable3 instanceof IOException) {
                        throw (IOException)throwable3;
                    }
                    if (throwable3 instanceof Exception) {
                        throw new IOException(throwable3);
                    }
                    throw (Error)throwable3;
                }
            }
            xmlReader.close();
        }
        return object;
    }

    private ReflectionSerializable() {
    }
}

