/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AccessTokenCacheInfo;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Signal;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Sinks;

public final class AccessTokenCache {
    private static final Duration REFRESH_DELAY = Duration.ofSeconds(30L);
    private static final String REFRESH_DELAY_STRING = String.valueOf(REFRESH_DELAY.getSeconds());
    private static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    private static final ClientLogger LOGGER = new ClientLogger(AccessTokenCache.class);
    private final AtomicReference<Sinks.One<AccessToken>> wip;
    private final AtomicReference<AccessTokenCacheInfo> cacheInfo;
    private final TokenCredential tokenCredential;
    private TokenRequestContext tokenRequestContext;
    private final Supplier<Mono<AccessToken>> tokenSupplierAsync;
    private final Supplier<AccessToken> tokenSupplierSync;
    private final Predicate<AccessToken> shouldRefresh;
    private final Lock lock;

    public AccessTokenCache(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential, "The token credential cannot be null");
        this.wip = new AtomicReference();
        this.tokenCredential = tokenCredential;
        this.cacheInfo = new AtomicReference<AccessTokenCacheInfo>(new AccessTokenCacheInfo(null, OffsetDateTime.now()));
        this.shouldRefresh = accessToken -> OffsetDateTime.now().isAfter(accessToken.getExpiresAt().minus(REFRESH_OFFSET));
        this.tokenSupplierAsync = () -> tokenCredential.getToken(this.tokenRequestContext);
        this.tokenSupplierSync = () -> tokenCredential.getTokenSync(this.tokenRequestContext);
        this.lock = new ReentrantLock();
    }

    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext, boolean bl2) {
        return Mono.defer(this.retrieveToken(tokenRequestContext, bl2)).repeatWhenEmpty(flux -> flux.concatMap(l2 -> Flux.just((Object)true).delayElements(Duration.ofMillis(500L))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext, boolean bl2) {
        this.lock.lock();
        try {
            AccessToken accessToken = this.retrieveTokenSync(tokenRequestContext, bl2).get();
            return accessToken;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Supplier<Mono<? extends AccessToken>> retrieveToken(TokenRequestContext tokenRequestContext, boolean bl2) {
        return () -> {
            try {
                if (tokenRequestContext == null) {
                    return Mono.error((Throwable)LOGGER.logExceptionAsError(new IllegalArgumentException("The token request context input cannot be null.")));
                }
                AccessTokenCacheInfo accessTokenCacheInfo = this.cacheInfo.get();
                AccessToken accessToken = accessTokenCacheInfo.getCachedAccessToken();
                if (this.wip.compareAndSet(null, (Sinks.One<AccessToken>)Sinks.one())) {
                    Mono mono;
                    Mono mono2;
                    boolean bl3;
                    Sinks.One<AccessToken> one = this.wip.get();
                    OffsetDateTime offsetDateTime = OffsetDateTime.now();
                    boolean bl4 = bl3 = bl2 && this.checkIfForceRefreshRequired(tokenRequestContext) || this.tokenRequestContext == null;
                    if (bl3) {
                        this.tokenRequestContext = tokenRequestContext;
                        mono2 = Mono.defer(() -> this.tokenCredential.getToken(this.tokenRequestContext));
                        mono = Mono.empty();
                    } else if (accessToken != null && !this.shouldRefresh.test(accessToken)) {
                        mono2 = Mono.empty();
                        mono = Mono.just((Object)accessToken);
                    } else if (accessToken == null || accessToken.isExpired()) {
                        mono2 = Mono.defer(this.tokenSupplierAsync);
                        mono = Mono.empty();
                    } else {
                        mono2 = offsetDateTime.isAfter(accessTokenCacheInfo.getNextTokenRefresh()) ? Mono.defer(this.tokenSupplierAsync) : Mono.empty();
                        mono = Mono.just((Object)accessToken);
                    }
                    return Mono.using(() -> this.wip, atomicReference -> mono2.materialize().flatMap(this.processTokenRefreshResult(one, offsetDateTime, (Mono<AccessToken>)mono)).doOnError(arg_0 -> ((Sinks.One)one).tryEmitError(arg_0)), atomicReference -> atomicReference.set(null));
                }
                if (accessToken != null && !accessToken.isExpired() && !bl2) {
                    return Mono.just((Object)accessToken);
                }
                if (bl2) {
                    return Mono.empty();
                }
                Sinks.One<AccessToken> one = this.wip.get();
                if (one == null) {
                    return Mono.just((Object)accessToken);
                }
                return one.asMono().switchIfEmpty(Mono.fromSupplier(() -> accessToken));
            }
            catch (Exception exception) {
                return Mono.error((Throwable)exception);
            }
        };
    }

    private Supplier<AccessToken> retrieveTokenSync(TokenRequestContext tokenRequestContext, boolean bl2) {
        return () -> {
            AccessToken accessToken;
            Supplier<AccessToken> supplier;
            boolean bl3;
            if (tokenRequestContext == null) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("The token request context input cannot be null."));
            }
            AccessTokenCacheInfo accessTokenCacheInfo = this.cacheInfo.get();
            AccessToken accessToken2 = accessTokenCacheInfo.getCachedAccessToken();
            OffsetDateTime offsetDateTime = OffsetDateTime.now();
            boolean bl4 = bl3 = bl2 && this.checkIfForceRefreshRequired(tokenRequestContext) || this.tokenRequestContext == null;
            if (bl3) {
                this.tokenRequestContext = tokenRequestContext;
                supplier = this.tokenSupplierSync;
                accessToken = null;
            } else if (accessToken2 != null && !this.shouldRefresh.test(accessToken2)) {
                supplier = null;
                accessToken = accessToken2;
            } else if (accessToken2 == null || accessToken2.isExpired()) {
                supplier = this.tokenSupplierSync;
                accessToken = null;
            } else {
                supplier = offsetDateTime.isAfter(accessTokenCacheInfo.getNextTokenRefresh()) ? this.tokenSupplierSync : null;
                accessToken = accessToken2;
            }
            try {
                if (supplier != null) {
                    AccessToken accessToken3 = supplier.get();
                    AccessTokenCache.buildTokenRefreshLog(LogLevel.INFORMATIONAL, accessToken2, offsetDateTime).log("Acquired a new access token.");
                    OffsetDateTime offsetDateTime2 = OffsetDateTime.now().plus(REFRESH_DELAY);
                    AccessTokenCacheInfo accessTokenCacheInfo2 = new AccessTokenCacheInfo(accessToken3, offsetDateTime2);
                    this.cacheInfo.set(accessTokenCacheInfo2);
                    return accessToken3;
                }
                return accessToken;
            }
            catch (Throwable throwable) {
                AccessTokenCache.buildTokenRefreshLog(LogLevel.ERROR, accessToken2, offsetDateTime).log("Failed to acquire a new access token.", throwable);
                OffsetDateTime offsetDateTime3 = OffsetDateTime.now();
                AccessTokenCacheInfo accessTokenCacheInfo3 = new AccessTokenCacheInfo(accessToken2, offsetDateTime3);
                this.cacheInfo.set(accessTokenCacheInfo3);
                if (accessToken != null) {
                    return accessToken;
                }
                throw throwable;
            }
        };
    }

    private boolean checkIfForceRefreshRequired(TokenRequestContext tokenRequestContext) {
        return this.tokenRequestContext == null || !(this.tokenRequestContext.getClaims() == null ? tokenRequestContext.getClaims() == null : tokenRequestContext.getClaims() != null && tokenRequestContext.getClaims().equals(this.tokenRequestContext.getClaims())) || !this.tokenRequestContext.getScopes().equals(tokenRequestContext.getScopes());
    }

    private Function<Signal<AccessToken>, Mono<? extends AccessToken>> processTokenRefreshResult(Sinks.One<AccessToken> one, OffsetDateTime offsetDateTime, Mono<AccessToken> mono) {
        return signal -> {
            AccessToken accessToken = (AccessToken)signal.get();
            Throwable throwable = signal.getThrowable();
            AccessToken accessToken2 = this.cacheInfo.get().getCachedAccessToken();
            if (signal.isOnNext() && accessToken != null) {
                AccessTokenCache.buildTokenRefreshLog(LogLevel.INFORMATIONAL, accessToken2, offsetDateTime).log("Acquired a new access token.");
                one.tryEmitValue((Object)accessToken);
                OffsetDateTime offsetDateTime2 = OffsetDateTime.now().plus(REFRESH_DELAY);
                this.cacheInfo.set(new AccessTokenCacheInfo(accessToken, offsetDateTime2));
                return Mono.just((Object)accessToken);
            }
            if (signal.isOnError() && throwable != null) {
                AccessTokenCache.buildTokenRefreshLog(LogLevel.ERROR, accessToken2, offsetDateTime).log("Failed to acquire a new access token.", throwable);
                OffsetDateTime offsetDateTime3 = OffsetDateTime.now();
                this.cacheInfo.set(new AccessTokenCacheInfo(accessToken2, offsetDateTime3));
                return mono.switchIfEmpty(Mono.error((Throwable)throwable));
            }
            one.tryEmitEmpty();
            return mono;
        };
    }

    private static LoggingEventBuilder buildTokenRefreshLog(LogLevel logLevel, AccessToken accessToken, OffsetDateTime offsetDateTime) {
        LoggingEventBuilder loggingEventBuilder = LOGGER.atLevel(logLevel);
        if (accessToken == null || !LOGGER.canLogAtLevel(logLevel)) {
            return loggingEventBuilder;
        }
        Duration duration = Duration.between(offsetDateTime, accessToken.getExpiresAt());
        return loggingEventBuilder.addKeyValue("expiresAt", accessToken.getExpiresAt()).addKeyValue("tteSeconds", String.valueOf(duration.abs().getSeconds())).addKeyValue("retryAfterSeconds", REFRESH_DELAY_STRING).addKeyValue("expired", duration.isNegative());
    }
}

