/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.Duration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RequestRetryCondition;

public interface RetryStrategy {
    public static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;

    public int getMaxRetries();

    public Duration calculateRetryDelay(int var1);

    default public boolean shouldRetry(HttpResponse httpResponse) {
        int n2 = httpResponse.getStatusCode();
        return n2 == 408 || n2 == 429 || n2 >= 500 && n2 != 501 && n2 != 505;
    }

    default public boolean shouldRetryException(Throwable throwable) {
        return throwable instanceof Exception;
    }

    default public boolean shouldRetryCondition(RequestRetryCondition requestRetryCondition) {
        if (requestRetryCondition.getResponse() != null) {
            return this.shouldRetry(requestRetryCondition.getResponse());
        }
        return this.shouldRetryException(requestRetryCondition.getThrowable());
    }
}

