/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class RequestIdPolicy
implements HttpPipelinePolicy {
    private static final HttpHeaderName REQUEST_ID_HEADER = HttpHeaderName.fromString("x-ms-client-request-id");
    private final HttpHeaderName requestIdHeaderName;

    public RequestIdPolicy(String string) {
        this.requestIdHeaderName = HttpHeaderName.fromString(Objects.requireNonNull(string, "requestIdHeaderName can not be null."));
    }

    public RequestIdPolicy() {
        this.requestIdHeaderName = REQUEST_ID_HEADER;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        RequestIdPolicy.setRequestIdHeader(httpPipelineCallContext.getHttpRequest(), this.requestIdHeaderName);
        return httpPipelineNextPolicy.process();
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        RequestIdPolicy.setRequestIdHeader(httpPipelineCallContext.getHttpRequest(), this.requestIdHeaderName);
        return httpPipelineNextSyncPolicy.processSync();
    }

    private static void setRequestIdHeader(HttpRequest httpRequest, HttpHeaderName httpHeaderName) {
        HttpHeaders httpHeaders = httpRequest.getHeaders();
        String string = httpHeaders.getValue(httpHeaderName);
        if (string == null) {
            httpHeaders.set(httpHeaderName, CoreUtils.randomUuid().toString());
        }
    }
}

