/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;

public enum HttpLogDetailLevel {
    NONE,
    BASIC,
    HEADERS,
    BODY,
    BODY_AND_HEADERS;

    static final String BASIC_VALUE = "basic";
    static final String HEADERS_VALUE = "headers";
    static final String BODY_VALUE = "body";
    static final String BODY_AND_HEADERS_VALUE = "body_and_headers";
    static final String BODYANDHEADERS_VALUE = "bodyandheaders";
    static final HttpLogDetailLevel ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;

    static HttpLogDetailLevel fromConfiguration(Configuration configuration) {
        String string = configuration.get("AZURE_HTTP_LOG_DETAIL_LEVEL", "none");
        HttpLogDetailLevel httpLogDetailLevel = BASIC_VALUE.equalsIgnoreCase(string) ? BASIC : (HEADERS_VALUE.equalsIgnoreCase(string) ? HEADERS : (BODY_VALUE.equalsIgnoreCase(string) ? BODY : (BODY_AND_HEADERS_VALUE.equalsIgnoreCase(string) || BODYANDHEADERS_VALUE.equalsIgnoreCase(string) ? BODY_AND_HEADERS : NONE)));
        return httpLogDetailLevel;
    }

    public boolean shouldLogUrl() {
        return this != NONE;
    }

    public boolean shouldLogHeaders() {
        return this == HEADERS || this == BODY_AND_HEADERS;
    }

    public boolean shouldLogBody() {
        return this == BODY || this == BODY_AND_HEADERS;
    }

    static {
        ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL = HttpLogDetailLevel.fromConfiguration(Configuration.getGlobalConfiguration());
    }
}

