/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.FixedDelayOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RequestRetryCondition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.accesshelpers.FixedDelayAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class FixedDelay
implements RetryStrategy {
    private static final ClientLogger LOGGER = new ClientLogger(FixedDelay.class);
    private final int maxRetries;
    private final Duration delay;
    private final Predicate<RequestRetryCondition> shouldRetryCondition;

    public FixedDelay(int n2, Duration duration) {
        this(n2, duration, null);
    }

    public FixedDelay(FixedDelayOptions fixedDelayOptions) {
        this(Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getMaxRetries(), Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getDelay());
    }

    private FixedDelay(FixedDelayOptions fixedDelayOptions, Predicate<RequestRetryCondition> predicate) {
        this(Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getMaxRetries(), Objects.requireNonNull(fixedDelayOptions, "'fixedDelayOptions' cannot be null.").getDelay(), predicate);
    }

    private FixedDelay(int n2, Duration duration, Predicate<RequestRetryCondition> predicate) {
        if (n2 < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        this.maxRetries = n2;
        this.delay = Objects.requireNonNull(duration, "'delay' cannot be null.");
        this.shouldRetryCondition = predicate;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Duration calculateRetryDelay(int n2) {
        return this.delay;
    }

    @Override
    public boolean shouldRetryCondition(RequestRetryCondition requestRetryCondition) {
        return this.shouldRetryCondition == null ? RetryStrategy.super.shouldRetryCondition(requestRetryCondition) : this.shouldRetryCondition.test(requestRetryCondition);
    }

    static {
        FixedDelayAccessHelper.setAccessor(FixedDelay::new);
    }
}

