/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AccessTokenCache;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class BearerTokenAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(BearerTokenAuthenticationPolicy.class);
    private static final String BEARER = "Bearer";
    private final String[] scopes;
    private final AccessTokenCache cache;

    public BearerTokenAuthenticationPolicy(TokenCredential tokenCredential, String ... stringArray) {
        Objects.requireNonNull(tokenCredential);
        this.scopes = stringArray;
        this.cache = new AccessTokenCache(tokenCredential);
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext httpPipelineCallContext) {
        if (this.scopes == null) {
            return Mono.empty();
        }
        return this.setAuthorizationHeaderHelper(httpPipelineCallContext, new TokenRequestContext().addScopes(this.scopes), false);
    }

    public void authorizeRequestSync(HttpPipelineCallContext httpPipelineCallContext) {
        this.setAuthorizationHeaderHelperSync(httpPipelineCallContext, new TokenRequestContext().addScopes(this.scopes), false);
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext httpPipelineCallContext, HttpResponse httpResponse) {
        return Mono.just((Object)false);
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext httpPipelineCallContext, HttpResponse httpResponse) {
        return false;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        if (!"https".equals(httpPipelineCallContext.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextPolicy httpPipelineNextPolicy2 = httpPipelineNextPolicy.clone();
        return this.authorizeRequest(httpPipelineCallContext).then(Mono.defer(httpPipelineNextPolicy::process)).flatMap(httpResponse -> {
            String string = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (httpResponse.getStatusCode() == 401 && string != null) {
                return this.authorizeRequestOnChallenge(httpPipelineCallContext, (HttpResponse)httpResponse).flatMap(bl2 -> {
                    if (bl2.booleanValue()) {
                        httpResponse.close();
                        return httpPipelineNextPolicy2.process();
                    }
                    return Mono.just((Object)httpResponse);
                });
            }
            return Mono.just((Object)httpResponse);
        });
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        if (!"https".equals(httpPipelineCallContext.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy2 = httpPipelineNextSyncPolicy.clone();
        this.authorizeRequestSync(httpPipelineCallContext);
        HttpResponse httpResponse = httpPipelineNextSyncPolicy.processSync();
        String string = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && string != null) {
            if (this.authorizeRequestOnChallengeSync(httpPipelineCallContext, httpResponse)) {
                httpResponse.close();
                return httpPipelineNextSyncPolicy2.processSync();
            }
            return httpResponse;
        }
        return httpResponse;
    }

    public Mono<Void> setAuthorizationHeader(HttpPipelineCallContext httpPipelineCallContext, TokenRequestContext tokenRequestContext) {
        return this.setAuthorizationHeaderHelper(httpPipelineCallContext, tokenRequestContext, true);
    }

    public void setAuthorizationHeaderSync(HttpPipelineCallContext httpPipelineCallContext, TokenRequestContext tokenRequestContext) {
        this.setAuthorizationHeaderHelperSync(httpPipelineCallContext, tokenRequestContext, true);
    }

    private Mono<Void> setAuthorizationHeaderHelper(HttpPipelineCallContext httpPipelineCallContext, TokenRequestContext tokenRequestContext, boolean bl2) {
        return this.cache.getToken(tokenRequestContext, bl2).flatMap(accessToken -> {
            BearerTokenAuthenticationPolicy.setAuthorizationHeader(httpPipelineCallContext.getHttpRequest().getHeaders(), accessToken.getToken());
            return Mono.empty();
        });
    }

    private void setAuthorizationHeaderHelperSync(HttpPipelineCallContext httpPipelineCallContext, TokenRequestContext tokenRequestContext, boolean bl2) {
        AccessToken accessToken = this.cache.getTokenSync(tokenRequestContext, bl2);
        BearerTokenAuthenticationPolicy.setAuthorizationHeader(httpPipelineCallContext.getHttpRequest().getHeaders(), accessToken.getToken());
    }

    private static void setAuthorizationHeader(HttpHeaders httpHeaders, String string) {
        httpHeaders.set(HttpHeaderName.AUTHORIZATION, "Bearer " + string);
    }
}

