/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.okhttp3.MediaType;
import macromedia.jdbc.sqlserver.externals.okhttp3.RequestBody;
import macromedia.jdbc.sqlserver.externals.okio.BufferedSink;
import macromedia.jdbc.sqlserver.externals.reactor.core.Exceptions;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.scheduler.Schedulers;

public class OkHttpFluxRequestBody
extends RequestBody {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpFluxRequestBody.class);
    private final BinaryDataContent content;
    private final long effectiveContentLength;
    private final MediaType mediaType;
    private final AtomicBoolean bodySent = new AtomicBoolean(false);
    private final int callTimeoutMillis;

    public boolean isOneShot() {
        return true;
    }

    public final MediaType contentType() {
        return this.mediaType;
    }

    public final long contentLength() {
        return this.effectiveContentLength;
    }

    public OkHttpFluxRequestBody(BinaryDataContent binaryDataContent, long l2, MediaType mediaType, int n2) {
        this.content = Objects.requireNonNull(binaryDataContent, "'content' cannot be null.");
        this.effectiveContentLength = l2;
        this.mediaType = mediaType;
        this.callTimeoutMillis = n2;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (this.bodySent.compareAndSet(false, true)) {
            Mono mono = this.content.toFluxByteBuffer().flatMapSequential(byteBuffer2 -> {
                if (Schedulers.isInNonBlockingThread()) {
                    return Mono.just((Object)byteBuffer2).publishOn(Schedulers.boundedElastic()).map(byteBuffer -> OkHttpFluxRequestBody.writeBuffer(bufferedSink, byteBuffer)).then();
                }
                OkHttpFluxRequestBody.writeBuffer(bufferedSink, byteBuffer2);
                return Mono.empty();
            }, 1, 1).then();
            if (this.callTimeoutMillis > 0) {
                mono.block(Duration.ofMillis(this.callTimeoutMillis));
            } else {
                mono.block();
            }
        } else {
            throw LOGGER.logThrowableAsError(new IOException("Re-attempt to send Flux body is not supported"));
        }
    }

    private static ByteBuffer writeBuffer(BufferedSink bufferedSink, ByteBuffer byteBuffer) {
        try {
            while (byteBuffer.hasRemaining()) {
                bufferedSink.write(byteBuffer);
            }
            return byteBuffer;
        }
        catch (IOException iOException) {
            throw Exceptions.propagate((Throwable)iOException);
        }
    }
}

