/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.BinaryDataRequestBody;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.OkHttpAsyncBufferedResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.OkHttpAsyncResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.OkHttpFluxRequestBody;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.OkHttpProgressReportingRequestBody;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.PerCallTimeoutCall;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.ResponseTimeoutListenerFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.FluxByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Contexts;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ProgressReporter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.okhttp3.Call;
import macromedia.jdbc.sqlserver.externals.okhttp3.Callback;
import macromedia.jdbc.sqlserver.externals.okhttp3.EventListener;
import macromedia.jdbc.sqlserver.externals.okhttp3.MediaType;
import macromedia.jdbc.sqlserver.externals.okhttp3.OkHttpClient;
import macromedia.jdbc.sqlserver.externals.okhttp3.Request;
import macromedia.jdbc.sqlserver.externals.okhttp3.RequestBody;
import macromedia.jdbc.sqlserver.externals.okhttp3.Response;
import macromedia.jdbc.sqlserver.externals.okhttp3.ResponseBody;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.MonoSink;

class OkHttpAsyncHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClient.class);
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final RequestBody EMPTY_REQUEST_BODY = RequestBody.create((byte[])EMPTY_BODY);
    final OkHttpClient httpClient;
    private final Duration responseTimeout;

    OkHttpAsyncHttpClient(OkHttpClient okHttpClient, Duration duration) {
        EventListener.Factory factory = okHttpClient.eventListenerFactory();
        this.httpClient = okHttpClient.newBuilder().eventListenerFactory((EventListener.Factory)new ResponseTimeoutListenerFactory(factory)).build();
        this.responseTimeout = duration;
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest httpRequest) {
        return this.send(httpRequest, Context.NONE);
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest httpRequest, Context context) {
        boolean bl2 = (Boolean)context.getData("azure-eagerly-read-response").orElse(false);
        boolean bl3 = (Boolean)context.getData("azure-ignore-response-body").orElse(false);
        boolean bl4 = (Boolean)context.getData("azure-eagerly-convert-headers").orElse(false);
        Duration duration = (Duration)context.getData("azure-response-timeout").filter(object -> object instanceof Duration).orElse(this.responseTimeout);
        ProgressReporter progressReporter = Contexts.with(context).getHttpRequestProgressReporter();
        return Mono.create(monoSink -> monoSink.onRequest(l2 -> Mono.fromCallable(() -> this.toOkHttpRequest(httpRequest, progressReporter, duration)).subscribe(request -> {
            try {
                Call call = this.httpClient.newCall(request);
                call.enqueue((Callback)new OkHttpCallback((MonoSink<HttpResponse>)monoSink, httpRequest, bl2, bl3, bl4));
                monoSink.onCancel(() -> ((Call)call).cancel());
            }
            catch (Exception exception) {
                monoSink.error((Throwable)exception);
            }
        }, arg_0 -> ((MonoSink)monoSink).error(arg_0))));
    }

    @Override
    public HttpResponse sendSync(HttpRequest httpRequest, Context context) {
        boolean bl2 = (Boolean)context.getData("azure-eagerly-read-response").orElse(false);
        boolean bl3 = (Boolean)context.getData("azure-ignore-response-body").orElse(false);
        boolean bl4 = (Boolean)context.getData("azure-eagerly-convert-headers").orElse(false);
        Duration duration = (Duration)context.getData("azure-response-timeout").filter(object -> object instanceof Duration).orElse(this.responseTimeout);
        ProgressReporter progressReporter = Contexts.with(context).getHttpRequestProgressReporter();
        Request request = this.toOkHttpRequest(httpRequest, progressReporter, duration);
        Call call = null;
        try {
            call = this.httpClient.newCall(request);
            Response response = call.execute();
            return OkHttpAsyncHttpClient.toHttpResponse(httpRequest, response, bl2, bl3, bl4);
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(OkHttpAsyncHttpClient.mapIOException(iOException, call)));
        }
    }

    private static IOException mapIOException(IOException iOException, Call call) {
        if (call == null) {
            return iOException;
        }
        PerCallTimeoutCall perCallTimeoutCall = (PerCallTimeoutCall)call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null && perCallTimeoutCall.isTimedOut()) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("timedout");
            interruptedIOException.addSuppressed(iOException);
            return interruptedIOException;
        }
        return iOException;
    }

    private Request toOkHttpRequest(HttpRequest httpRequest, ProgressReporter progressReporter, Duration duration) {
        Request.Builder builder = new Request.Builder().url(httpRequest.getUrl());
        if (duration != null) {
            builder.tag(PerCallTimeoutCall.class, (Object)new PerCallTimeoutCall(duration.toMillis()));
        }
        if (httpRequest.getHeaders() != null) {
            for (HttpHeader httpHeader : httpRequest.getHeaders()) {
                httpHeader.getValuesList().forEach(string -> builder.addHeader(httpHeader.getName(), string));
            }
        }
        if (httpRequest.getHttpMethod() == HttpMethod.GET) {
            return builder.get().build();
        }
        if (httpRequest.getHttpMethod() == HttpMethod.HEAD) {
            return builder.head().build();
        }
        RequestBody requestBody = this.toOkHttpRequestBody(httpRequest.getBodyAsBinaryData(), httpRequest.getHeaders());
        if (progressReporter != null) {
            requestBody = new OkHttpProgressReportingRequestBody(requestBody, progressReporter);
        }
        return builder.method(httpRequest.getHttpMethod().toString(), requestBody).build();
    }

    private RequestBody toOkHttpRequestBody(BinaryData binaryData, HttpHeaders httpHeaders) {
        if (binaryData == null) {
            return EMPTY_REQUEST_BODY;
        }
        String string = httpHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        MediaType mediaType = string == null ? null : MediaType.parse((String)string);
        BinaryDataContent binaryDataContent = BinaryDataHelper.getContent(binaryData);
        long l2 = OkHttpAsyncHttpClient.getRequestContentLength(binaryDataContent, httpHeaders);
        if (binaryDataContent instanceof FluxByteBufferContent) {
            return new OkHttpFluxRequestBody(binaryDataContent, l2, mediaType, this.httpClient.callTimeoutMillis());
        }
        return new BinaryDataRequestBody(binaryData, mediaType, l2);
    }

    private static long getRequestContentLength(BinaryDataContent binaryDataContent, HttpHeaders httpHeaders) {
        Long l2 = binaryDataContent.getLength();
        if (l2 == null) {
            String string = httpHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
            l2 = string != null ? Long.valueOf(Long.parseLong(string)) : Long.valueOf(-1L);
        }
        return l2;
    }

    private static HttpResponse toHttpResponse(HttpRequest httpRequest, Response response, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        if (bl2 || bl3) {
            try (ResponseBody responseBody = response.body();){
                byte[] byArray = responseBody != null ? responseBody.bytes() : EMPTY_BODY;
                OkHttpAsyncBufferedResponse okHttpAsyncBufferedResponse = new OkHttpAsyncBufferedResponse(response, httpRequest, byArray, bl4);
                return okHttpAsyncBufferedResponse;
            }
        }
        return new OkHttpAsyncResponse(response, httpRequest, bl4);
    }

    private static class OkHttpCallback
    implements Callback {
        private final MonoSink<HttpResponse> sink;
        private final HttpRequest request;
        private final boolean eagerlyReadResponse;
        private final boolean ignoreResponseBody;
        private final boolean eagerlyConvertHeaders;

        OkHttpCallback(MonoSink<HttpResponse> monoSink, HttpRequest httpRequest, boolean bl2, boolean bl3, boolean bl4) {
            this.sink = monoSink;
            this.request = httpRequest;
            this.eagerlyReadResponse = bl2;
            this.ignoreResponseBody = bl3;
            this.eagerlyConvertHeaders = bl4;
        }

        public void onFailure(Call call, IOException iOException) {
            if (iOException.getSuppressed().length == 1) {
                Throwable throwable = iOException.getSuppressed()[0];
                if (throwable instanceof IOException) {
                    this.sink.error((Throwable)OkHttpAsyncHttpClient.mapIOException((IOException)throwable, call));
                } else {
                    this.sink.error(throwable);
                }
            } else {
                this.sink.error((Throwable)OkHttpAsyncHttpClient.mapIOException(iOException, call));
            }
        }

        public void onResponse(Call call, Response response) {
            try {
                this.sink.success((Object)OkHttpAsyncHttpClient.toHttpResponse(this.request, response, this.eagerlyReadResponse, this.ignoreResponseBody, this.eagerlyConvertHeaders));
            }
            catch (IOException iOException) {
                this.sink.error((Throwable)iOException);
            }
        }
    }
}

