/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class HttpRange {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRange.class);
    private final long offset;
    private final Long length;

    public HttpRange(long l2) {
        this(l2, null);
    }

    public HttpRange(long l2, Long l3) {
        if (l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'offset' cannot be less than 0."));
        }
        if (l3 != null && l3 <= 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'length' cannot be equal to or less than 0."));
        }
        this.offset = l2;
        this.length = l3;
    }

    public long getOffset() {
        return this.offset;
    }

    public Long getLength() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.length);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpRange)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        HttpRange httpRange = (HttpRange)object;
        return httpRange.offset == this.offset && Objects.equals(httpRange.length, this.length);
    }

    public String toString() {
        return this.length == null ? "bytes=" + this.offset + "-" : "bytes=" + this.offset + "-" + (this.offset + this.length - 1L);
    }
}

