/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.HttpPipelineCallState;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.Tracer;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class HttpPipeline {
    private final HttpClient httpClient;
    private final HttpPipelinePolicy[] pipelinePolicies;
    private final Tracer tracer;

    HttpPipeline(HttpClient httpClient, List<HttpPipelinePolicy> list, Tracer tracer) {
        Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
        Objects.requireNonNull(list, "'pipelinePolicies' cannot be null.");
        this.httpClient = httpClient;
        this.pipelinePolicies = list.toArray(new HttpPipelinePolicy[0]);
        this.tracer = tracer;
    }

    public HttpPipelinePolicy getPolicy(int n2) {
        return this.pipelinePolicies[n2];
    }

    public int getPolicyCount() {
        return this.pipelinePolicies.length;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Mono<HttpResponse> send(HttpRequest httpRequest) {
        return this.send(new HttpPipelineCallContext(httpRequest));
    }

    public Mono<HttpResponse> send(HttpRequest httpRequest, Context context) {
        return this.send(new HttpPipelineCallContext(httpRequest, context));
    }

    public Mono<HttpResponse> send(HttpPipelineCallContext httpPipelineCallContext) {
        return Mono.defer(() -> {
            HttpPipelineNextPolicy httpPipelineNextPolicy = new HttpPipelineNextPolicy(new HttpPipelineCallState(this, httpPipelineCallContext));
            return httpPipelineNextPolicy.process();
        });
    }

    public HttpResponse sendSync(HttpRequest httpRequest, Context context) {
        HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy = new HttpPipelineNextSyncPolicy(new HttpPipelineCallState(this, new HttpPipelineCallContext(httpRequest, context)));
        return httpPipelineNextSyncPolicy.processSync();
    }
}

