/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.credential;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Sinks;

public class SimpleTokenCache {
    private static final Duration REFRESH_DELAY = Duration.ofSeconds(30L);
    private static final String REFRESH_DELAY_STRING = String.valueOf(REFRESH_DELAY.getSeconds());
    private static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    private static final ClientLogger LOGGER = new ClientLogger(SimpleTokenCache.class);
    private final AtomicReference<Sinks.One<AccessToken>> wip;
    private volatile AccessToken cache;
    private volatile OffsetDateTime nextTokenRefresh = OffsetDateTime.now();
    private final Supplier<Mono<AccessToken>> tokenSupplier;
    private final Predicate<AccessToken> shouldRefresh;

    public SimpleTokenCache(Supplier<Mono<AccessToken>> supplier) {
        this.wip = new AtomicReference();
        this.tokenSupplier = supplier;
        this.shouldRefresh = accessToken -> OffsetDateTime.now().isAfter(accessToken.getExpiresAt().minus(REFRESH_OFFSET));
    }

    public Mono<AccessToken> getToken() {
        return Mono.defer(() -> {
            try {
                if (this.wip.compareAndSet(null, (Sinks.One<AccessToken>)Sinks.one())) {
                    Mono mono;
                    Mono mono2;
                    Sinks.One<AccessToken> one = this.wip.get();
                    OffsetDateTime offsetDateTime = OffsetDateTime.now();
                    if (this.cache != null && !this.shouldRefresh.test(this.cache)) {
                        mono2 = Mono.empty();
                        mono = Mono.just((Object)this.cache);
                    } else if (this.cache == null || this.cache.isExpired()) {
                        mono2 = offsetDateTime.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.defer(this.tokenSupplier).delaySubscription(Duration.between(offsetDateTime, this.nextTokenRefresh));
                        mono = Mono.empty();
                    } else {
                        mono2 = offsetDateTime.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.empty();
                        mono = Mono.just((Object)this.cache);
                    }
                    return Mono.using(() -> this.wip, atomicReference -> mono2.materialize().flatMap(signal -> {
                        AccessToken accessToken = (AccessToken)signal.get();
                        Throwable throwable = signal.getThrowable();
                        if (signal.isOnNext() && accessToken != null) {
                            SimpleTokenCache.buildTokenRefreshLog(LogLevel.INFORMATIONAL, this.cache, offsetDateTime).log("Acquired a new access token");
                            this.cache = accessToken;
                            one.tryEmitValue((Object)accessToken);
                            this.nextTokenRefresh = OffsetDateTime.now().plus(REFRESH_DELAY);
                            return Mono.just((Object)accessToken);
                        }
                        if (signal.isOnError() && throwable != null) {
                            SimpleTokenCache.buildTokenRefreshLog(LogLevel.ERROR, this.cache, offsetDateTime).log("Failed to acquire a new access token");
                            this.nextTokenRefresh = OffsetDateTime.now().plus(REFRESH_DELAY);
                            return mono.switchIfEmpty(Mono.error(() -> throwable));
                        }
                        one.tryEmitEmpty();
                        return mono;
                    }).doOnError(arg_0 -> ((Sinks.One)one).tryEmitError(arg_0)), atomicReference -> atomicReference.set(null));
                }
                if (this.cache != null && !this.cache.isExpired()) {
                    return Mono.just((Object)this.cache);
                }
                Sinks.One<AccessToken> one = this.wip.get();
                if (one == null) {
                    return Mono.just((Object)this.cache);
                }
                return one.asMono().switchIfEmpty(Mono.fromSupplier(() -> this.cache));
            }
            catch (Exception exception) {
                return Mono.error((Throwable)exception);
            }
        });
    }

    Sinks.One<AccessToken> getWipValue() {
        return this.wip.get();
    }

    private static LoggingEventBuilder buildTokenRefreshLog(LogLevel logLevel, AccessToken accessToken, OffsetDateTime offsetDateTime) {
        LoggingEventBuilder loggingEventBuilder = LOGGER.atLevel(logLevel);
        if (accessToken == null || !LOGGER.canLogAtLevel(logLevel)) {
            return loggingEventBuilder;
        }
        Duration duration = Duration.between(offsetDateTime, accessToken.getExpiresAt());
        return loggingEventBuilder.addKeyValue("expiresAt", accessToken.getExpiresAt()).addKeyValue("tteSeconds", String.valueOf(duration.abs().getSeconds())).addKeyValue("retryAfterSeconds", REFRESH_DELAY_STRING).addKeyValue("expired", duration.isNegative());
    }
}

