/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.sql.SQLException;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseParameter;
import macromedia.jdbc.slbase.BaseParameterInfo;

public class BaseParameters {
    private BaseExceptions exceptions;
    BaseParameterInfo[] parameterMetaData;
    public BaseParameter[] parametersIn;
    public BaseParameter[] parametersOut;
    int nameIndex = 0;
    public static final int UNDETERMINED_ORDER = 0;
    public static final int NAME_ORDER = 1;
    public static final int POSITIONAL_ORDER = 2;
    public int parameterOrder = 0;
    boolean outputParamRegistered = false;
    public boolean newParameterBindings = true;
    public BaseConnection connection;

    public BaseParameters(int n2, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.parametersIn = new BaseParameter[n2];
        this.parametersOut = new BaseParameter[n2];
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
    }

    public BaseParameters(BaseParameters baseParameters, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.copy(baseParameters, baseExceptions, baseConnection);
    }

    public void copy(BaseParameters baseParameters, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.nameIndex = baseParameters.nameIndex;
        this.parameterOrder = baseParameters.parameterOrder;
        this.newParameterBindings = baseParameters.newParameterBindings;
        if (this.parametersIn == null || this.parametersIn.length < baseParameters.parametersIn.length) {
            this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        }
        if (this.parametersOut == null || this.parametersOut.length < baseParameters.parametersOut.length) {
            this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        }
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
        this.parameterMetaData = baseParameters.parameterMetaData;
        for (int i2 = 0; i2 < this.parametersIn.length; ++i2) {
            if (baseParameters.parametersIn[i2] != null) {
                if (this.parametersIn[i2] == null) {
                    this.parametersIn[i2] = new BaseParameter(baseParameters.parametersIn[i2], baseConnection);
                } else {
                    this.parametersIn[i2].copy(baseParameters.parametersIn[i2], baseConnection);
                }
            }
            if (baseParameters.parametersOut[i2] == null) continue;
            if (this.parametersOut[i2] == null) {
                this.parametersOut[i2] = new BaseParameter(baseParameters.parametersOut[i2], baseConnection);
            } else {
                this.parametersOut[i2].copy(baseParameters.parametersOut[i2], baseConnection);
            }
            this.outputParamRegistered = true;
        }
    }

    public void set(int n2, int n3, BaseParameter baseParameter) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 2;
        }
        if (this.parameterOrder == 1) {
            throw this.exceptions.getException(6010, "07009");
        }
        try {
            if (n3 == 1) {
                this.parametersIn[n2 - 1] = baseParameter;
            } else if (n3 == 2) {
                this.parametersOut[n2 - 1] = baseParameter;
                this.outputParamRegistered = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String string, int n2, BaseParameter baseParameter) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 1;
        }
        if (this.parameterOrder == 2) {
            throw this.exceptions.getException(6010, "07009");
        }
        try {
            boolean bl2 = false;
            baseParameter.name = string;
            if (n2 == 1) {
                for (int i2 = 0; i2 < this.nameIndex && !bl2; ++i2) {
                    if (this.parametersIn[i2] != null && this.parametersIn[i2].name.equalsIgnoreCase(string)) {
                        this.parametersIn[i2] = baseParameter;
                        bl2 = true;
                        continue;
                    }
                    if (this.parametersOut[i2] == null || !this.parametersOut[i2].name.equalsIgnoreCase(string)) continue;
                    this.parametersIn[i2] = baseParameter;
                    bl2 = true;
                }
                if (bl2) return;
                if (this.nameIndex >= this.parametersIn.length) throw this.exceptions.getException(6010, "07009");
                this.parametersIn[this.nameIndex++] = baseParameter;
                return;
            } else {
                if (n2 != 2) return;
                for (int i3 = 0; i3 < this.nameIndex && !bl2; ++i3) {
                    if (this.parametersOut[i3] != null && this.parametersOut[i3].name.equalsIgnoreCase(string)) {
                        this.parametersOut[i3] = baseParameter;
                        bl2 = true;
                        continue;
                    }
                    if (this.parametersIn[i3] == null || !this.parametersIn[i3].name.equalsIgnoreCase(string)) continue;
                    this.parametersOut[i3] = baseParameter;
                    bl2 = true;
                }
                if (!bl2) {
                    if (this.nameIndex >= this.parametersOut.length) throw this.exceptions.getException(6010, "07009");
                    this.parametersOut[this.nameIndex++] = baseParameter;
                }
                this.outputParamRegistered = true;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(int n2) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 2;
        }
        if (this.parameterOrder == 1) {
            throw this.exceptions.getException(6010, "07009");
        }
        try {
            BaseParameter baseParameter = this.parametersIn[n2 - 1];
            if (baseParameter == null) {
                this.parametersIn[n2 - 1] = baseParameter = new BaseParameter(this.connection);
            }
            return baseParameter;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(String string) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 1;
        }
        if (this.parameterOrder == 2) {
            throw this.exceptions.getException(6010, "07009");
        }
        BaseParameter baseParameter = null;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.nameIndex && !bl2; ++i2) {
            if (this.parametersIn[i2] != null && this.parametersIn[i2].name.equalsIgnoreCase(string)) {
                baseParameter = this.parametersIn[i2];
                bl2 = true;
                continue;
            }
            if (this.parametersOut[i2] == null || !this.parametersOut[i2].name.equalsIgnoreCase(string)) continue;
            baseParameter = new BaseParameter(this.connection);
            baseParameter.name = string;
            this.parametersIn[i2] = baseParameter;
            bl2 = true;
        }
        if (!bl2) {
            if (this.nameIndex < this.parametersIn.length) {
                baseParameter = new BaseParameter(this.connection);
                baseParameter.name = string;
                this.parametersIn[this.nameIndex++] = baseParameter;
            } else {
                throw this.exceptions.getException(6010, "07009");
            }
        }
        return baseParameter;
    }

    public void clearInput() {
        int n2 = this.count();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parametersIn[i2] == null) continue;
            this.parametersIn[i2].setNull(0);
        }
        this.nameIndex = 0;
        this.parameterOrder = 0;
    }

    public void clearOutput(boolean bl2) {
        int n2 = this.count();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.parametersOut[i2] == null) continue;
            if (bl2) {
                this.outputParamRegistered = false;
                this.parametersOut[i2] = null;
                continue;
            }
            this.parametersOut[i2].setNull(0);
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    public boolean anyOutputParamsRegistered() {
        return this.outputParamRegistered;
    }

    public BaseParameter get(int n2, int n3) throws SQLException {
        try {
            Object var3_3 = null;
            if (n3 == 1) {
                return this.parametersIn[n2 - 1];
            }
            if (n3 == 2) {
                return this.parametersOut[n2 - 1];
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter get(String string, int n2) throws SQLException {
        try {
            Object var3_3 = null;
            if (n2 == 1) {
                for (int i2 = 0; i2 < this.nameIndex; ++i2) {
                    if (this.parametersIn[i2] == null || !this.parametersIn[i2].name.equalsIgnoreCase(string)) continue;
                    return this.parametersIn[i2];
                }
                return null;
            }
            if (n2 == 2) {
                for (int i3 = 0; i3 < this.nameIndex; ++i3) {
                    if (this.parametersOut[i3] == null || !this.parametersOut[i3].name.equalsIgnoreCase(string)) continue;
                    return this.parametersOut[i3];
                }
                return null;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getInput(int n2) {
        return this.parametersIn[n2 - 1];
    }

    public BaseParameter getOutput(int n2) {
        return this.parametersOut[n2 - 1];
    }

    boolean isValidOrdinal(int n2) {
        return n2 > 0 && n2 <= this.count();
    }

    protected boolean haveMinimalBindings() {
        boolean bl2 = true;
        int n2 = this.count();
        int n3 = 0;
        int n4 = 0;
        if (this.parameterOrder == 2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.parametersIn[i2] != null && this.parametersIn[i2].type != 0) {
                    ++n3;
                    continue;
                }
                if (this.parametersOut[i2] == null) continue;
                ++n4;
            }
            if (n3 + n4 < n2) {
                bl2 = false;
            }
        } else if (this.nameIndex < n2) {
            bl2 = false;
        }
        return bl2;
    }

    public void setParameterInfo(int n2, BaseParameterInfo baseParameterInfo) {
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new BaseParameterInfo[this.count()];
        }
        this.parameterMetaData[n2] = baseParameterInfo;
    }

    public BaseParameterInfo getParameterInfoOrNull(int n2) throws SQLException {
        try {
            if (this.parameterMetaData == null || n2 > this.parameterMetaData.length - 1 || this.parameterMetaData[n2] == null) {
                return null;
            }
            return this.parameterMetaData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameterInfo getParameterInfo(int n2) throws SQLException {
        try {
            if (this.parameterMetaData == null || n2 > this.parameterMetaData.length - 1 || this.parameterMetaData[n2] == null) {
                throw this.exceptions.getException(6088);
            }
            return this.parameterMetaData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }
}

