/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl.ooxml;

import com.github.pjfanning.xlsx.CommentsImplementationType;
import com.github.pjfanning.xlsx.StreamingReader;
import com.github.pjfanning.xlsx.exceptions.MissingSheetException;
import com.github.pjfanning.xlsx.exceptions.OpenException;
import com.github.pjfanning.xlsx.impl.PoiSharedStringsSupport;
import com.github.pjfanning.xlsx.impl.ooxml.OoxmlStrictHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.util.Internal;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Internal
public class OoxmlReader
extends XSSFReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OoxmlReader.class);
    static final String PURL_COMMENTS_RELATIONSHIP_URL = "http://purl.oclc.org/ooxml/officeDocument/relationships/comments";
    static final String PURL_DRAWING_RELATIONSHIP_URL = "http://purl.oclc.org/ooxml/officeDocument/relationships/drawing";
    private static final Set<String> OVERRIDE_WORKSHEET_RELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(XSSFRelation.WORKSHEET.getRelation(), "http://purl.oclc.org/ooxml/officeDocument/relationships/worksheet", XSSFRelation.CHARTSHEET.getRelation(), XSSFRelation.MACRO_SHEET_BIN.getRelation())));
    private final OoxmlSheetReader ooxmlSheetReader;

    @Internal
    public OoxmlReader(StreamingReader.Builder builder, OPCPackage pkg, boolean strictOoxmlChecksNeeded) throws IOException, OpenXML4JException, POIXMLException {
        super(pkg, true);
        PackageRelationship coreDocRelationship = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        if (coreDocRelationship == null && (coreDocRelationship = this.pkg.getRelationshipsByType("http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument").getRelationship(0)) == null) {
            throw new POIXMLException("OOXML file structure broken/invalid - no core document found!");
        }
        this.workbookPart = this.pkg.getPart(coreDocRelationship);
        this.ooxmlSheetReader = new OoxmlSheetReader(builder, this.workbookPart, strictOoxmlChecksNeeded);
    }

    public SharedStringsTable getSharedStringsTable() throws IOException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        return parts.isEmpty() ? null : new SharedStringsTable((PackagePart)parts.get(0));
    }

    public SharedStrings getSharedStrings(StreamingReader.Builder builder) throws IOException, SAXException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        switch (builder.getSharedStringsImplementationType()) {
            case POI_DEFAULT: {
                return new SharedStringsTable((PackagePart)parts.get(0));
            }
            case CUSTOM_MAP_BACKED: {
                return PoiSharedStringsSupport.createMapBackedSharedStringsTable(((PackagePart)parts.get(0)).getPackage(), builder);
            }
            case TEMP_FILE_BACKED: {
                return PoiSharedStringsSupport.createTempFileSharedStringsTable(((PackagePart)parts.get(0)).getPackage(), builder);
            }
        }
        return new ReadOnlySharedStringsTable((PackagePart)parts.get(0));
    }

    public StylesTable getStylesTable() throws IOException, InvalidFormatException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.isEmpty()) {
            return null;
        }
        StylesTable styles = new StylesTable((PackagePart)parts.get(0));
        parts = this.pkg.getPartsByContentType(XSSFRelation.THEME.getContentType());
        if (!parts.isEmpty()) {
            styles.setTheme(new ThemesTable((PackagePart)parts.get(0)));
        }
        return styles;
    }

    public int getSheetIndex(String name) throws MissingSheetException {
        return this.ooxmlSheetReader.getSheetIndex(name);
    }

    public SheetData getSheetDataAt(int idx) throws MissingSheetException {
        return this.ooxmlSheetReader.getSheetData(idx);
    }

    public int getNumberOfSheets() {
        return this.ooxmlSheetReader.size();
    }

    private static SheetData createSheetData(StreamingReader.Builder builder, XSSFReader.XSSFSheetRef xssfSheetRef, Map<String, PackagePart> sheetMap, boolean strictOoxmlChecksNeeded) {
        PackagePart sheetPart = sheetMap.get(xssfSheetRef.getId());
        List<XSSFShape> shapes = builder.readShapes() ? OoxmlReader.getShapes(sheetPart, strictOoxmlChecksNeeded) : null;
        Comments comments = builder.readComments() ? OoxmlReader.getSheetComments(builder, sheetPart, strictOoxmlChecksNeeded) : null;
        return new SheetData(sheetPart, xssfSheetRef.getName(), comments, shapes);
    }

    private static Comments getSheetComments(StreamingReader.Builder builder, PackagePart sheetPkg, boolean strictOoxmlChecksNeeded) {
        try {
            PackageRelationshipCollection commentsList = sheetPkg.getRelationshipsByType(XSSFRelation.SHEET_COMMENTS.getRelation());
            if (commentsList.isEmpty() && strictOoxmlChecksNeeded) {
                commentsList = sheetPkg.getRelationshipsByType(PURL_COMMENTS_RELATIONSHIP_URL);
            }
            if (!commentsList.isEmpty()) {
                PackageRelationship comments = commentsList.getRelationship(0);
                PackagePartName commentsName = PackagingURIHelper.createPartName((URI)comments.getTargetURI());
                PackagePart commentsPart = sheetPkg.getPackage().getPart(commentsName);
                return OoxmlReader.parseComments(builder, commentsPart, strictOoxmlChecksNeeded);
            }
        }
        catch (IOException | XMLStreamException | InvalidFormatException e) {
            LOGGER.warn("issue getting sheet comments", e);
            return null;
        }
        return null;
    }

    private static Comments parseComments(StreamingReader.Builder builder, PackagePart commentsPart, boolean strictOoxmlChecksNeeded) throws IOException, XMLStreamException {
        if (builder.getCommentsImplementationType() == CommentsImplementationType.TEMP_FILE_BACKED) {
            try (InputStream is = commentsPart.getInputStream();){
                Comments ct = PoiSharedStringsSupport.createTempFileCommentsTable(builder);
                try {
                    PoiSharedStringsSupport.readComments(ct, is);
                }
                catch (IOException | RuntimeException e) {
                    if (ct instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)ct).close();
                        }
                        catch (Exception e2) {
                            e.addSuppressed(e2);
                        }
                    }
                    throw e;
                }
                Comments e = ct;
                return e;
            }
        }
        if (builder.getCommentsImplementationType() == CommentsImplementationType.CUSTOM_MAP_BACKED) {
            try (InputStream is = commentsPart.getInputStream();){
                Comments ct = PoiSharedStringsSupport.createMapBackedCommentsTable(builder);
                try {
                    PoiSharedStringsSupport.readComments(ct, is);
                }
                catch (IOException | RuntimeException e) {
                    if (ct instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)ct).close();
                        }
                        catch (Exception e2) {
                            e.addSuppressed(e2);
                        }
                    }
                    throw e;
                }
                Comments comments = ct;
                return comments;
            }
        }
        if (strictOoxmlChecksNeeded) {
            return OoxmlStrictHelper.getCommentsTable(builder, commentsPart);
        }
        return new CommentsTable(commentsPart);
    }

    private static List<XSSFShape> getShapes(PackagePart sheetPkg, boolean strictOoxmlChecksNeeded) {
        LinkedList<XSSFShape> shapes = new LinkedList<XSSFShape>();
        try {
            PackageRelationshipCollection drawingsList = sheetPkg.getRelationshipsByType(XSSFRelation.DRAWINGS.getRelation());
            if (drawingsList.isEmpty() && strictOoxmlChecksNeeded) {
                drawingsList = sheetPkg.getRelationshipsByType(PURL_DRAWING_RELATIONSHIP_URL);
            }
            for (int i = 0; i < drawingsList.size(); ++i) {
                PackageRelationship drawings = drawingsList.getRelationship(i);
                PackagePartName drawingsName = PackagingURIHelper.createPartName((URI)drawings.getTargetURI());
                PackagePart drawingsPart = sheetPkg.getPackage().getPart(drawingsName);
                if (drawingsPart == null) {
                    LOGGER.warn("Missing drawing: {}. Skipping it.", (Object)drawingsName);
                    continue;
                }
                XSSFDrawing drawing = new XSSFDrawing(drawingsPart);
                shapes.addAll(drawing.getShapes());
            }
        }
        catch (IOException | InvalidFormatException | XmlException e) {
            LOGGER.warn("issue getting shapes", e);
            return null;
        }
        return shapes;
    }

    public static class SheetData {
        private final PackagePart sheetPart;
        private final String sheetName;
        private final Comments comments;
        private final List<XSSFShape> shapes;

        SheetData(PackagePart sheetPart, String sheetName, Comments comments, List<XSSFShape> shapes) {
            this.sheetPart = sheetPart;
            this.sheetName = sheetName;
            this.comments = comments;
            this.shapes = shapes;
        }

        public PackagePart getSheetPart() {
            return this.sheetPart;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public Comments getComments() {
            return this.comments;
        }

        public List<XSSFShape> getShapes() {
            return this.shapes;
        }
    }

    static class OoxmlSheetReader {
        public final StreamingReader.Builder builder;
        private final Map<String, PackagePart> sheetMap;
        private final ArrayList<XSSFReader.XSSFSheetRef> sheetRefList;
        private final boolean strictOoxmlChecksNeeded;
        private final Map<XSSFReader.XSSFSheetRef, SheetData> sheetDataMap = new HashMap<XSSFReader.XSSFSheetRef, SheetData>();

        OoxmlSheetReader(StreamingReader.Builder builder, PackagePart wb, boolean strictOoxmlChecksNeeded) throws IOException, POIXMLException {
            this.builder = builder;
            this.strictOoxmlChecksNeeded = strictOoxmlChecksNeeded;
            try {
                this.sheetMap = new HashMap<String, PackagePart>();
                OPCPackage pkg = wb.getPackage();
                Set<String> worksheetRels = this.getSheetRelationships();
                for (PackageRelationship rel : wb.getRelationships()) {
                    String relType = rel.getRelationshipType();
                    if (!worksheetRels.contains(relType)) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    this.sheetMap.put(rel.getId(), pkg.getPart(relName));
                }
                this.sheetRefList = this.createSheetListFromWB(wb);
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException((Throwable)e);
            }
        }

        int size() {
            return this.sheetRefList.size();
        }

        int getSheetIndex(String name) throws MissingSheetException {
            int i = 0;
            for (XSSFReader.XSSFSheetRef sheetRef : this.sheetRefList) {
                if (name.equalsIgnoreCase(sheetRef.getName())) {
                    return i;
                }
                ++i;
            }
            throw new MissingSheetException("Failed to find sheet " + name);
        }

        SheetData getSheetData(int idx) throws MissingSheetException {
            if (idx > this.sheetRefList.size()) {
                throw new MissingSheetException("Failed to find sheet with id " + idx);
            }
            XSSFReader.XSSFSheetRef matchedSheetRef = this.sheetRefList.get(idx);
            if (matchedSheetRef == null) {
                throw new MissingSheetException("Failed to find sheet with id " + idx);
            }
            return this.getSheetData(matchedSheetRef);
        }

        SheetData getSheetData(XSSFReader.XSSFSheetRef sheetRef) {
            SheetData sd = this.sheetDataMap.get(sheetRef);
            if (sd == null) {
                sd = OoxmlReader.createSheetData(this.builder, sheetRef, this.sheetMap, this.strictOoxmlChecksNeeded);
                this.sheetDataMap.put(sheetRef, sd);
            }
            return sd;
        }

        private ArrayList<XSSFReader.XSSFSheetRef> createSheetListFromWB(PackagePart wb) throws IOException, OpenException, POIXMLException {
            XMLReader xmlReader;
            XSSFReader.XMLSheetRefReader xmlSheetRefReader = new XSSFReader.XMLSheetRefReader();
            try {
                xmlReader = XMLHelper.newXMLReader();
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new POIXMLException((Throwable)e);
            }
            xmlReader.setContentHandler((ContentHandler)xmlSheetRefReader);
            try (InputStream stream = wb.getInputStream();){
                xmlReader.parse(new InputSource(stream));
            }
            catch (SAXException e) {
                throw new OpenException(e);
            }
            ArrayList<XSSFReader.XSSFSheetRef> validSheets = new ArrayList<XSSFReader.XSSFSheetRef>();
            for (XSSFReader.XSSFSheetRef xssfSheetRef : xmlSheetRefReader.getSheetRefs()) {
                String sheetId = xssfSheetRef.getId();
                if (sheetId == null || sheetId.isEmpty()) continue;
                validSheets.add(xssfSheetRef);
            }
            return validSheets;
        }

        private Set<String> getSheetRelationships() {
            return OVERRIDE_WORKSHEET_RELS;
        }
    }
}

