/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cache.redis;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheConfig;
import coldfusion.tagext.io.cache.CacheException;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.util.CaseInsensitiveHashtable;
import coldfusion.util.PasswordUtils;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class GenericRedisCache
extends GenericCache
implements Observer {
    private String configFilePath;
    private String applicationName;
    private JedisPool jedisPool = null;
    public static final String SEMI_COLON = ":";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    public static final String METADATA = "metadata";
    private static final String REDISSTATS_KEY_HITCOUNT = "redisstats_key_hitcount";
    private static final String REDISSTATS_CACHE_MISSCOUNT = "redisstats_cache_misscount";
    private static final String REDISSTATS_CACHE_CURRENTCOUNT = "redisstats_cache_currentcount";
    private static final String REDISSTATS_CACHE_HITCOUNT = "redisstats_cache_hitcount";
    private static final String REDISSTATS_CACHE_PROPERTIES = "redisstats_cache_properties";
    private static final String REDIS_CACHE_NAMES = "redis_cache_names";
    private static final String REDISSTATS_KEY_LASTACCESS = "redisstats_key_lastaccess";
    private static final String REDISSTATS_KEY_UPDATETIME = "redisstats_key_updatetime";
    private static final String REDISSTATS_KEY_CREATETIME = "redisstats_key_createtime";
    private static final String REDISSTATS_KEY_TIMESPAN = "redisstats_key_timespan";
    private static final String REDISSTATS_KEY_IDELTIME = "redisstats_key_idletime";
    private static final String VALUE = "value";
    private int maxElements = -1;
    private CacheConfig cacheConfig = new CacheConfig();
    private int idletimeCheckThreadInterval = 5;
    private int maxConnections = 100;
    private int maxwaitMillis = 1000;
    private boolean blockWhenExhausted = true;
    private boolean validateConnection = true;
    private boolean validateConnectionOnCheckout;
    private int timeout = 2000;
    private boolean isCFLoginRedisSessionStorage;
    private static final String keyScript1 = "redis.call('hset',KEYS[1],'redisstats_key_lastaccess',KEYS[3])";
    private static final String keyScript2 = "redis.call('hincrby',KEYS[1],'redisstats_key_hitcount','1')";
    private static final String cacheScript = "redis.call('hincrby',KEYS[2],'redisstats_cache_hitcount','1')";
    private static final String updateStatsFullScript = "redis.call('hset',KEYS[1],'redisstats_key_lastaccess',KEYS[3]) redis.call('hincrby',KEYS[1],'redisstats_key_hitcount','1') redis.call('hincrby',KEYS[2],'redisstats_cache_hitcount','1')";
    private static String updateStatsSha1Digest = "";
    private static String LUA_STORE_METADATA_SCRIPT = "local s1 = redis.call('hexists', KEYS[1],'value')  if(s1 == 0) then redis.call('hincrBy', KEYS[2],'redisstats_cache_currentcount','1') end redis.call('hset', KEYS[1],'redisstats_key_updatetime', ARGV[1])redis.call('hset', KEYS[1],'redisstats_key_createtime',ARGV[1])redis.call('hset', KEYS[1],'redisstats_key_timespan',ARGV[2])redis.call('hset', KEYS[1],'redisstats_key_idletime',ARGV[3])redis.call('hset', KEYS[1],'redisstats_key_hitcount','0')redis.call('hset', KEYS[1],'value',ARGV[4])";
    private static String LUA_STORE_METADATA_SCRIPT_EXPIRY = LUA_STORE_METADATA_SCRIPT + " redis.call('expire', KEYS[1], ARGV[2])";
    private static String putScriptSha1Digest1 = "";
    private static String putScriptSha1Digest2 = "";
    private static String putScriptMaxCheckSha1Digest = "";
    private JedisCluster jedisCluster = null;
    private static ScheduledExecutorService cleanupService = null;
    Runnable cleanupThread = new Runnable(){

        @Override
        public void run() {
            GenericRedisCache.this.removeIdleItems();
        }
    };
    private String seed;

    public GenericRedisCache() {
        this.initConfig();
        this.initCleanupService();
        CacheTagHelper.createDefaultCache((GenericCache)this, (CacheConfig)this.cacheConfig);
    }

    public GenericRedisCache(boolean b) {
        this.isCFLoginRedisSessionStorage = b;
        this.initConfig();
        this.initCleanupService();
        CacheTagHelper.createDefaultCache((GenericCache)this, (CacheConfig)this.cacheConfig);
    }

    public GenericRedisCache(String configPath, String applicationName, Map config, boolean isCFLoginRedisSessionStorage) {
        this.applicationName = applicationName;
        this.isCFLoginRedisSessionStorage = isCFLoginRedisSessionStorage;
        this.initConfig();
        if (configPath != null) {
            this.configFilePath = configPath.trim();
            this.configFilePath = CacheTagHelper.resolveConfigFilePath((String)this.configFilePath);
            CacheTagHelper.readApplicationLevelProperties((String)this.configFilePath, (CacheConfig)this.cacheConfig, (Map)config);
        }
        this.initCleanupService();
        CacheTagHelper.createDefaultCache((GenericCache)this, (CacheConfig)this.cacheConfig);
    }

    private void initConfig() {
        PasswordUtils.getInstance().addObserver((Observer)this);
        final Properties p = new Properties();
        final String serverPropFile = ServiceFactory.getRuntimeService().getLibDir() + "/rediscache.properties";
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    try (FileInputStream fis = new FileInputStream(serverPropFile);){
                        p.load(fis);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
            CaseInsensitiveHashtable props = new CaseInsensitiveHashtable((Map)p);
            if (props.containsKey((Object)"TIMETOIDLESECONDS")) {
                this.cacheConfig.setCacheIdleTime(Long.valueOf((String)props.get((Object)"TIMETOIDLESECONDS")).longValue());
            } else {
                this.cacheConfig.setCacheIdleTime(86400L);
            }
            if (props.containsKey((Object)"TIMETOLIVESECONDS")) {
                this.cacheConfig.setCacheTimeSpan(Long.valueOf((String)props.get((Object)"TIMETOLIVESECONDS")).longValue());
            } else {
                this.cacheConfig.setCacheTimeSpan(86400L);
            }
            if (props.containsKey((Object)"ETERNAL")) {
                this.cacheConfig.setCacheEternal(Cast._boolean((Object)props.get((Object)"ETERNAL")));
            }
            if (props.containsKey((Object)"MAXIDLELAZYEVICTION")) {
                this.cacheConfig.setCacheMaxIdleLazyEviction(Cast._boolean((Object)props.get((Object)"MAXIDLELAZYEVICTION")));
            } else {
                this.cacheConfig.setCacheMaxIdleLazyEviction(true);
            }
            if (props.containsKey((Object)"MAXELEMENTSCHECK")) {
                this.cacheConfig.setCacheMaxElementsCheck(Cast._boolean((Object)props.get((Object)"MAXELEMENTSCHECK")));
            } else {
                this.cacheConfig.setCacheMaxElementsCheck(true);
            }
            if (props.containsKey((Object)"METADATA")) {
                this.cacheConfig.setCacheMetadata(Cast._boolean((Object)props.get((Object)"METADATA")));
            } else {
                this.cacheConfig.setCacheMetadata(true);
            }
            if (props.containsKey((Object)"MAXELEMENTSINMEMORY")) {
                this.cacheConfig.setCacheMaxElements(Integer.valueOf((String)props.get((Object)"MAXELEMENTSINMEMORY")).intValue());
            } else {
                this.cacheConfig.setCacheMaxElements(10000);
            }
            if (props.containsKey((Object)"EVICTIONCHUNKSIZE")) {
                this.cacheConfig.setCacheSpoolChunkSize(Integer.valueOf((String)props.get((Object)"EVICTIONCHUNKSIZE")).intValue());
            } else {
                this.cacheConfig.setCacheSpoolChunkSize(100);
            }
            if (props.containsKey((Object)"IDLETIMECHECKTHREADINTERVAL")) {
                this.idletimeCheckThreadInterval = Integer.valueOf((String)props.get((Object)"IDLETIMECHECKTHREADINTERVAL"));
            }
            if (props.containsKey((Object)"MAXCONNECTIONS")) {
                this.maxConnections = Cast._int((Object)props.get((Object)"MAXCONNECTIONS"));
            }
            if (props.containsKey((Object)"MAXWAITMILLIS")) {
                this.maxwaitMillis = Cast._int((Object)props.get((Object)"MAXWAITMILLIS"));
            }
            if (props.containsKey((Object)"BLOCKWHENEXHAUSTED")) {
                this.blockWhenExhausted = Cast._boolean((Object)props.get((Object)"BLOCKWHENEXHAUSTED"));
            }
            if (props.containsKey((Object)"CONNECTIONTIMEOUT")) {
                this.timeout = Cast._int((Object)props.get((Object)"CONNECTIONTIMEOUT"));
            }
            if (props.containsKey((Object)"VALIDATECONNECTION")) {
                this.validateConnection = Cast._boolean((Object)props.get((Object)"VALIDATECONNECTION"));
            }
            if (props.containsKey((Object)"VALIDATEONCONNECTIONCHECKOUT")) {
                this.validateConnectionOnCheckout = Cast._boolean((Object)props.get((Object)"VALIDATEONCONNECTIONCHECKOUT"));
            }
        }
        catch (Exception e) {
            throw new CacheException();
        }
    }

    public Object getMetadata() {
        return null;
    }

    public void setCacheProperties(Map map, String region) {
        if (map != null && map instanceof Struct) {
            String appName = FusionContext.getCurrent().getApplicationName();
            String objectType = this.toStringValue(map.get("OBJECTTYPE"), "ALL").trim();
            String cacheName = null;
            if (region == null && CacheTagHelper.isStandardCacheRegion((String)objectType)) {
                region = objectType;
            }
            if (region == null && "ALL".equalsIgnoreCase(objectType)) {
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                this.setPropertyOnCache(cacheName, map);
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
                this.setPropertyOnCache(cacheName, map);
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"QUERY", (String)this.configFilePath);
                this.setPropertyOnCache(cacheName, map);
            } else {
                if (region != null && (region.equalsIgnoreCase("OBJECT") || region.equalsIgnoreCase("QUERY") || region.equalsIgnoreCase("TEMPLATE"))) {
                    region = region.toUpperCase();
                    cacheName = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                } else {
                    cacheName = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                    if (!this.cacheExists(region)) {
                        throw new CacheExceptions.CacheNotFoundException(region);
                    }
                }
                this.setPropertyOnCache(cacheName, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyOnCache(String cacheName, Map<Object, Object> map) {
        String mgrCalcKey;
        boolean b;
        if (cacheName != null && !(b = this.cacheExists(mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)cacheName), "OBJECT"))) {
            JedisCommands jedis = this.getClient();
            try {
                jedis.sadd(REDIS_CACHE_NAMES, new String[]{mgrCalcKey});
                cacheName = mgrCalcKey;
            }
            finally {
                this.closeClient(jedis);
            }
        }
        JedisCommands jedis = this.getClient();
        try {
            if (null != map) {
                CaseInsensitiveHashtable imap = new CaseInsensitiveHashtable();
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    imap.put(entry.getKey(), "" + entry.getValue());
                }
                if (imap.containsKey("MAXENTRIESLOCALHEAP")) {
                    imap.put("MAXELEMENTSINMEMORY", imap.get("MAXENTRIESLOCALHEAP"));
                }
                if (imap.size() > 0) {
                    jedis.hmset("redisstats_cache_properties:" + this.getHashtaggedCachekey(cacheName), (Map)imap);
                }
            }
        }
        finally {
            this.closeClient(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createCache(String mgrKey, String objType, String diskStore, Map properties) {
        if (mgrKey != null && mgrKey.trim().length() == 0) {
            throw new CacheExceptions.InvalidCacheNameException();
        }
        String appName = null;
        FusionContext context = FusionContext.getCurrent();
        if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        mgrKey = CacheTagHelper.getCacheKey2((String)mgrKey, (String)appName, (String)objType, (String)this.configFilePath);
        String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
        JedisCommands jedis = this.getClient();
        try {
            jedis.sadd(REDIS_CACHE_NAMES, new String[]{mgrCalcKey});
            if (properties != null && properties.size() > 0) {
                jedis.hmset("redisstats_cache_properties:" + this.getHashtaggedCachekey(mgrCalcKey), properties);
            }
            jedis.hset(mgrCalcKey, REDISSTATS_CACHE_HITCOUNT, "0");
            String string = "Redis";
            return string;
        }
        finally {
            this.closeClient(jedis);
        }
    }

    public boolean cacheExists(String region) {
        String[] regions = this.getAllCacheNames();
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            region = CacheTagHelper.getCacheKey2((String)region, (String)fContext.getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
        }
        return Arrays.asList(regions).contains(region);
    }

    public boolean cacheExists(String region, String type) {
        String[] regions = this.getAllCacheNames();
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            region = CacheTagHelper.getCacheKey2((String)region, (String)fContext.getApplicationName(), (String)type, (String)this.configFilePath);
        }
        return Arrays.asList(regions).contains(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(CacheTO xObj, boolean throwError, Long within) {
        JedisCommands cMgr = this.getClient();
        try {
            List value = null;
            value = cMgr.hmget(this.getRedisItemKey(xObj, true), new String[]{VALUE, REDISSTATS_KEY_HITCOUNT, REDISSTATS_KEY_LASTACCESS, REDISSTATS_KEY_CREATETIME, REDISSTATS_KEY_TIMESPAN, REDISSTATS_KEY_IDELTIME, REDISSTATS_KEY_UPDATETIME});
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(REDISSTATS_KEY_UPDATETIME, (String)value.get(6));
            metadata.put(REDISSTATS_KEY_CREATETIME, (String)value.get(3));
            metadata.put(REDISSTATS_KEY_TIMESPAN, (String)value.get(4));
            metadata.put(REDISSTATS_KEY_IDELTIME, (String)value.get(5));
            metadata.put(REDISSTATS_KEY_HITCOUNT, (String)value.get(1));
            metadata.put(VALUE, (String)value.get(0));
            metadata.put(REDISSTATS_KEY_LASTACCESS, (String)value.get(2));
            String createKey = (String)value.get(3);
            Object result = null;
            if (value != null && value.get(0) != null) {
                try {
                    result = value.get(0);
                }
                catch (Exception e) {
                    CFLogs.APPLICATION_LOG.error((Throwable)e);
                }
            } else {
                value = null;
            }
            if (value != null) {
                try {
                    this.updateStats(xObj, metadata);
                }
                catch (Exception e) {
                    CFLogs.APPLICATION_LOG.error((Throwable)e);
                }
            }
            Object object = CacheTagHelper.stringToObject((String)result);
            return object;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get(CacheTO xObj, boolean throwError) {
        JedisCommands cMgr = this.getClient();
        try {
            if (cMgr != null) {
                List value = null;
                String key = this.getRedisItemKey(xObj, true);
                value = cMgr.hmget(key, new String[]{VALUE, REDISSTATS_KEY_HITCOUNT, REDISSTATS_KEY_LASTACCESS, REDISSTATS_KEY_CREATETIME, REDISSTATS_KEY_TIMESPAN, REDISSTATS_KEY_IDELTIME, REDISSTATS_KEY_UPDATETIME});
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put(REDISSTATS_KEY_UPDATETIME, (String)value.get(6));
                metadata.put(REDISSTATS_KEY_CREATETIME, (String)value.get(3));
                metadata.put(REDISSTATS_KEY_TIMESPAN, (String)value.get(4));
                metadata.put(REDISSTATS_KEY_IDELTIME, (String)value.get(5));
                metadata.put(REDISSTATS_KEY_HITCOUNT, (String)value.get(1));
                metadata.put(VALUE, (String)value.get(0));
                metadata.put(REDISSTATS_KEY_LASTACCESS, (String)value.get(2));
                if (this.cacheConfig.isCacheMaxIdleLazyEviction() && this.removeIfIdleExpired(cMgr, metadata, key, this.getRedisCacheKey(xObj, false, false))) {
                    Object var7_7 = null;
                    return var7_7;
                }
                this.updateStats(xObj, metadata);
                if (value != null && value.get(0) != null) {
                    try {
                        long checkTime;
                        long lastModified;
                        if (!xObj.getQuiet && "TEMPLATE".equalsIgnoreCase(xObj.objecttype) && (lastModified = TemplateClassLoader.getLastModifiedTime((String)FusionContext.getCurrent().getPagePath())) > (checkTime = this.getUpdateTimeOfElement(xObj))) {
                            Object var11_13 = null;
                            return var11_13;
                        }
                    }
                    catch (Exception lastModified) {
                        // empty catch block
                    }
                    try {
                        Object lastModified = CacheTagHelper.stringToObject((String)((String)value.get(0)));
                        return lastModified;
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error((Throwable)e);
                        Object var8_14 = null;
                        this.closeClient(cMgr);
                        return var8_14;
                    }
                }
            }
            Object var4_4 = null;
            return var4_4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats(CacheTO xObj, Map<String, String> metadata) {
        if (!xObj.getQuiet) {
            if (this.cacheConfig != null && !this.cacheConfig.isCacheMetadata()) {
                return;
            }
            JedisCommands cMgr = this.getClient();
            try {
                String itemKey = this.getRedisItemKey(xObj, false);
                String cacheKey = this.getRedisCacheKey(xObj, false);
                if (null != metadata.get(VALUE)) {
                    String[] args = new String[]{itemKey, cacheKey, "" + System.currentTimeMillis()};
                    if (this.isCluster()) {
                        String keyScript4 = "redis.call('hset',KEYS[1],'redisstats_key_lastaccess',ARGV[1])";
                        ((JedisCluster)cMgr).eval(keyScript4 + " redis.call('hincrby',KEYS[1],'redisstats_key_hitcount','1') redis.call('hincrby',KEYS[2],'redisstats_cache_hitcount','1')", 2, args);
                    } else {
                        if (!((Jedis)cMgr).scriptExists(updateStatsSha1Digest).booleanValue()) {
                            updateStatsSha1Digest = ((Jedis)cMgr).scriptLoad(updateStatsFullScript);
                        }
                        ((Jedis)cMgr).evalsha(updateStatsSha1Digest, args.length, args);
                    }
                } else {
                    this.incrementMisscount(cMgr, cacheKey);
                }
            }
            finally {
                this.closeClient(cMgr);
            }
        }
    }

    private void closeClient(Object cMgr) {
        if (cMgr == null) {
            return;
        }
        try {
            if (cMgr instanceof Jedis) {
                ((Jedis)cMgr).close();
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
        }
    }

    private String getRedisItemKey(CacheTO xObj, boolean checkExists) {
        return this.getRedisItemKey(xObj, true, checkExists);
    }

    private String getRedisItemKey(CacheTO xObj, boolean throwError, boolean checkExists) {
        String mgrKey = this.getRedisCacheKey(xObj, throwError, checkExists);
        Object finalKey = mgrKey;
        if (null != xObj && xObj.id != null) {
            xObj.id.hashCode();
            finalKey = (String)finalKey + SEMI_COLON + xObj.id.toString();
        }
        return finalKey;
    }

    private String getRedisCacheKey(CacheTO xObj, boolean checkExists) {
        return this.getRedisCacheKey(xObj, true, checkExists);
    }

    private String getRedisCacheKey(CacheTO xObj, boolean throwError, boolean checkExists) {
        String mgrKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
        boolean exist = true;
        if (checkExists) {
            String[] regions = this.getAllCacheNames();
            exist = Arrays.asList(regions).contains(mgrKey);
            if (!(!throwError || exist || xObj.region == null || xObj.region.equalsIgnoreCase("OBJECT") || xObj.region.equalsIgnoreCase("QUERY") || xObj.region.equalsIgnoreCase("TEMPLATE"))) {
                throw new CacheExceptions.CacheNotFoundException(xObj.region);
            }
            if (!exist) {
                this.createCache(xObj.region, xObj.objecttype, null, null);
                String appName = null;
                FusionContext context = FusionContext.getCurrent();
                if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
                    appName = context.cacheConfig.applicationName;
                }
                mgrKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)appName, (String)xObj.objecttype, (String)this.configFilePath);
            }
        }
        return this.getHashtaggedCachekey(mgrKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUpdateTimeOfElement(CacheTO xObj) {
        JedisCommands cMgr = this.getClient();
        try {
            String obj = cMgr.hget(this.getRedisItemKey(xObj, false), REDISSTATS_KEY_UPDATETIME);
            if (null != obj) {
                long l = Long.valueOf(obj);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastAccessTimeOfElement(CacheTO xObj) {
        JedisCommands cMgr = this.getClient();
        try {
            String obj = cMgr.hget(this.getRedisItemKey(xObj, false), REDISSTATS_KEY_LASTACCESS);
            if (null != obj) {
                long l = Long.valueOf(obj);
                return l;
            }
            obj = cMgr.hget(this.getRedisItemKey(xObj, false), REDISSTATS_KEY_CREATETIME);
            long l = Long.valueOf(obj);
            return l;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMetadata(CacheTO xObj) {
        CaseInsensitiveHashtable result = new CaseInsensitiveHashtable();
        JedisCommands cMgr = this.getClient();
        String itemKey = this.getRedisItemKey(xObj, true);
        String cacheKey = this.getRedisCacheKey(xObj, true);
        try {
            xObj.getQuiet = true;
            if (this.get(xObj, false) == null) {
                CaseInsensitiveHashtable caseInsensitiveHashtable = result;
                return caseInsensitiveHashtable;
            }
            Map data = cMgr.hgetAll(itemKey);
            String hitKeyCount = (String)data.get(REDISSTATS_KEY_HITCOUNT);
            if (hitKeyCount == null) {
                result.put("HITCOUNT", 0);
            } else {
                result.put("HITCOUNT", hitKeyCount);
            }
            String timespanKey = (String)data.get(REDISSTATS_KEY_TIMESPAN);
            result.put("TIMESPAN", timespanKey);
            String idleKey = (String)data.get(REDISSTATS_KEY_IDELTIME);
            result.put("IDLETIME", idleKey);
            String lastAccessKey = (String)data.get(REDISSTATS_KEY_LASTACCESS);
            String lastUpdateKey = (String)data.get(REDISSTATS_KEY_UPDATETIME);
            if (null != lastAccessKey) {
                result.put("LASTHIT", new OleDateTime(Long.valueOf(lastAccessKey).longValue()));
            } else {
                result.put("LASTHIT", new OleDateTime(Long.valueOf(lastUpdateKey).longValue()));
            }
            result.put("LASTUPDATED", new OleDateTime(Long.valueOf(lastUpdateKey).longValue()));
            String createKey = (String)data.get(REDISSTATS_KEY_CREATETIME);
            result.put("CREATEDTIME", new OleDateTime(Long.valueOf(createKey).longValue()));
            result.put("SIZE", this.getItemSize(itemKey));
            String hitCount = cMgr.hget(cacheKey, REDISSTATS_CACHE_HITCOUNT);
            if (hitCount == null) {
                result.put("CACHE_HITCOUNT", 0);
            } else {
                result.put("CACHE_HITCOUNT", hitCount);
            }
            String missCount = cMgr.hget(cacheKey, REDISSTATS_CACHE_MISSCOUNT);
            if (missCount == null) {
                result.put("CACHE_MISSCOUNT", 0);
            } else {
                result.put("CACHE_MISSCOUNT", missCount);
            }
            String cacheName = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
            result.put("NAME", CacheTagHelper.getTrimmedCacheName((String)cacheName, (String)xObj.appname));
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
        }
        finally {
            this.closeClient(cMgr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getItemSize(String itemKey) {
        JedisCommands cMgr = this.getClient();
        try {
            Map items = cMgr.hgetAll(itemKey);
            long size = 0L;
            for (Map.Entry item : items.entrySet()) {
                size += CacheTagHelper.getSerializedSize(item.getKey()) + CacheTagHelper.getSerializedSize(item.getValue());
            }
            long l = size += CacheTagHelper.getSerializedSize((Object)itemKey);
            return l;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    public List getObjectCacheMetadata(String appName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (appName != null) {
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
            return result;
        }
        String[] cacheNames = this.getAllCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("OBJECT") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("OBJECT"));
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object populatePerAppMetadata(String region, String appName) {
        Struct resultObj = new Struct();
        List<String> keys = this.getAllKeysForRegion(region);
        JedisCommands cMgr = this.getClient();
        try {
            long cummSize = 0L;
            long size = 0L;
            if (keys != null) {
                ArrayList<Struct> objects = new ArrayList<Struct>();
                try {
                    for (String key : keys) {
                        Struct objMeta = new Struct();
                        objMeta.put((Object)"ID", (Object)key);
                        CacheTO statsTo = new CacheTO();
                        statsTo.setId((Object)cMgr.get(key));
                        statsTo.setKey(null);
                        statsTo.setAppname(appName);
                        statsTo.setObjecttype("OBJECT");
                        statsTo.getQuiet = true;
                        Map metadata = this.getMetadata(statsTo);
                        objMeta.put((Object)"SIZE", metadata.get("SIZE"));
                        objMeta.put((Object)"HITCOUNT", metadata.get("HITCOUNT"));
                        if (!this.isStatisticsKey(key)) {
                            cummSize += this.getItemSize(key);
                            ++size;
                        }
                        objects.add(objMeta);
                    }
                    resultObj.put((Object)"OBJECTS", objects);
                    String hitCount = cMgr.hget(region, REDISSTATS_CACHE_HITCOUNT);
                    String missCount = cMgr.hget(region, REDISSTATS_CACHE_MISSCOUNT);
                    if (missCount == null) {
                        resultObj.put((Object)"CACHE_MISSCOUNT", (Object)0);
                    } else {
                        resultObj.put((Object)"CACHE_MISSCOUNT", (Object)missCount);
                    }
                    resultObj.put((Object)"CACHE_HITCOUNT", (Object)hitCount);
                    Double mc = 0.0;
                    if (null != missCount) {
                        mc = Double.valueOf(missCount);
                    }
                    if (hitCount == null || Double.valueOf(hitCount) == 0.0) {
                        resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                    } else {
                        resultObj.put((Object)"HITRATIO", (Object)new Double(Double.valueOf(hitCount) / (mc + Double.valueOf(hitCount))));
                    }
                    resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
                    resultObj.put((Object)"NUMBER", (Object)new Long(size));
                    resultObj.put((Object)"APPLICATIONNAME", (Object)appName);
                }
                catch (Exception e) {
                    Struct struct = resultObj;
                    this.closeClient(cMgr);
                    return struct;
                }
            }
            Struct struct = resultObj;
            return struct;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    private boolean isStatisticsKey(String key) {
        return key.contains("redisstats_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllKeysForRegion(String region) {
        JedisCommands cMgr = this.getClient();
        try {
            ScanParams scanParams = new ScanParams();
            scanParams.match(region + ":*");
            String cursor = ScanParams.SCAN_POINTER_START;
            boolean cycleIsFinished = false;
            ArrayList<String> allIds = new ArrayList<String>();
            try {
                while (!cycleIsFinished) {
                    ScanResult scanResult = null;
                    scanResult = this.isCluster() ? ((JedisCluster)cMgr).scan(cursor, scanParams) : ((Jedis)cMgr).scan(cursor, scanParams);
                    List result = scanResult.getResult();
                    allIds.addAll(result);
                    cursor = scanResult.getCursor();
                    if (!cursor.equals("0")) continue;
                    cycleIsFinished = true;
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
            }
            ArrayList<String> arrayList = allIds;
            return arrayList;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    public List getTemplateCacheMetadata(String appName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (appName != null) {
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
            return result;
        }
        String[] cacheNames = this.getAllCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("OBJECT") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("TEMPLATE"));
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAllCacheIdsCount(CacheTO xObj, boolean accurate) {
        JedisCommands cMgr = this.getClient();
        try {
            String key = this.getRedisCacheKey(xObj, false);
            String script = "local count=0 local matches =redis.call('keys','" + key + ":*') for _,key in ipairs(matches) do    count = count + 1  end return count ";
            Integer count = 0;
            String[] args = new String[]{key};
            if (this.isCluster()) {
                ((JedisCluster)cMgr).eval(script, 1, args);
            } else {
                ((Jedis)cMgr).eval(script, 1, args);
            }
            int n = Cast._int((Object)count);
            return n;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getAllCacheIds(CacheTO xObj, boolean accurate) {
        JedisCommands cMgr = this.getClient();
        try {
            String key = this.getRedisCacheKey(xObj, true);
            List<Object> allIds = new ArrayList();
            allIds = this.getAllKeysForRegion(key);
            ArrayList<Object> res = new ArrayList();
            ArrayList<Object> arrayList = res = allIds.stream().filter(item -> !item.toLowerCase().contains("redisstats_")).map(item -> item.substring(item.indexOf(SEMI_COLON) + 1)).collect(Collectors.toList());
            return arrayList;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    public void setMaxElementsInMemory(String cacheKey, int count) {
        this.maxElements = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(CacheTO xObj) {
        String cacheKey = this.getRedisCacheKey(xObj, true);
        String itemKey = this.getRedisItemKey(xObj, true);
        JedisCommands cMgr = this.getClient();
        try {
            if (xObj.id != null) {
                Object keyHash = xObj.id;
                if (xObj.exact && cMgr.hgetAll(itemKey).size() > 0) {
                    this.deleteKey(itemKey, cacheKey, cMgr);
                    boolean bl = true;
                    return bl;
                }
                if (!xObj.exact && keyHash instanceof String) {
                    boolean cacheDeleted = false;
                    String matchCriteria = CacheTagHelper.createMatchCriteria((String)((String)keyHash));
                    List<String> keys = this.getAllKeysForRegion(cacheKey);
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        Object obj;
                        String key;
                        String tempkey = key = iterator.next();
                        if (key.contains(SEMI_COLON)) {
                            tempkey = key.substring(key.indexOf(SEMI_COLON) + 1);
                        }
                        if (!((obj = CacheTagHelper.stringToObject((String)tempkey)) instanceof String) || CFPage.REFindNoCase((String)matchCriteria, (String)CacheTagHelper.createMatchCriteria((String)((String)obj))) <= 0) continue;
                        this.deleteKey(key, cacheKey, cMgr);
                        cacheDeleted = true;
                    }
                    boolean bl = cacheDeleted;
                    return bl;
                }
            } else if (!xObj.exact) {
                List<String> keys = this.getAllKeysForRegion(cacheKey);
                if (null != keys) {
                    for (String key : keys) {
                        this.deleteKey(key, cacheKey, cMgr);
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    private void deleteKey(String itemKey, String cacheKey, JedisCommands cMgr) {
        String script = "local s = redis.call('hexists',KEYS[1],'value')   if (s == 1) then redis.call('del',KEYS[1]) redis.call('hincrBy',KEYS[2],'redisstats_cache_currentcount','-1') end";
        String[] args = new String[]{itemKey, cacheKey};
        if (this.isCluster()) {
            ((JedisCluster)cMgr).eval(script, 2, args);
        } else {
            ((Jedis)cMgr).eval(script, 2, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheTO xObj, boolean throwOnError) {
        String itemKey = this.getRedisItemKey(xObj, throwOnError);
        JedisCommands cacheMgr = this.getClient();
        try {
            String cacheKey = this.getRedisCacheKey(xObj, throwOnError);
            CaseInsensitiveHashtable prop = new CaseInsensitiveHashtable();
            Map p = cacheMgr.hgetAll("redisstats_cache_properties:" + cacheKey);
            if (null != p) {
                prop = new CaseInsensitiveHashtable(p);
            }
            if (this.cacheConfig.isCacheMaxElementsCheck()) {
                String maxProp;
                String script1 = "local s1 = redis.call('hget',KEYS[1],'MAXELEMENTSINMEMORY') ";
                String script2 = "local s2 = redis.call('hget',KEYS[2],'redisstats_cache_currentcount')";
                String fullScript = script1 + " " + script2 + " if(s1 == false) then s1  ='null' end   if(s2 ==false) then s2 = 'null' end   return s2 .. ' ' .. s1";
                long count = 0L;
                String result = null;
                String[] args = new String[]{"redisstats_cache_properties:" + cacheKey, cacheKey};
                if (this.isCluster()) {
                    result = (String)((JedisCluster)cacheMgr).eval(fullScript, 2, args);
                } else {
                    if (!((Jedis)cacheMgr).scriptExists(putScriptMaxCheckSha1Digest).booleanValue()) {
                        putScriptMaxCheckSha1Digest = ((Jedis)cacheMgr).scriptLoad(fullScript);
                    }
                    result = (String)((Jedis)cacheMgr).evalsha(putScriptMaxCheckSha1Digest, args.length, args);
                }
                String[] split = result.split(" ");
                if (!split[0].equals("null")) {
                    count = Integer.parseInt(split[0]);
                }
                if (!split[1].equals("null") && (maxProp = split[1]) != null && maxProp.length() > 0) {
                    prop.put("MAXELEMENTSINMEMORY", maxProp);
                }
                if (this.cacheConfig != null && prop.get("MAXELEMENTSINMEMORY") == null && prop.get("MAXENTRIESLOCALHEAP") == null) {
                    prop.put("MAXELEMENTSINMEMORY", "" + this.cacheConfig.getCacheMaxElements());
                }
                if (prop != null && (prop.get("MAXELEMENTSINMEMORY") != null || prop.get("MAXENTRIESLOCALHEAP") != null)) {
                    Object maxElems = prop.get("MAXELEMENTSINMEMORY");
                    if (null == maxElems) {
                        maxElems = prop.get("MAXENTRIESLOCALHEAP");
                    }
                    long maxElemsValue = Long.valueOf((String)maxElems);
                    int sz = this.cacheConfig.getCacheSpoolChunkSize();
                    if (count >= maxElemsValue) {
                        long delCount = count - maxElemsValue + (long)sz;
                        String script = "local count=0 local exists = 0 local matches =redis.call('keys','" + cacheKey + ":*') count = #matches  for i,name in ipairs(matches) do    if(i <= " + delCount + ") then redis.call('del',name) count = count - 1 end end redis.call('hset',KEYS[1],'redisstats_cache_currentcount',count) return count ";
                        Object obj = null;
                        String[] keys = new String[]{cacheKey};
                        try {
                            obj = this.isCluster() ? ((JedisCluster)cacheMgr).eval(script, 1, keys) : ((Jedis)cacheMgr).eval(script, 1, keys);
                        }
                        catch (Exception e) {
                            CFLogs.APPLICATION_LOG.error((Throwable)e);
                        }
                    }
                }
            }
            String value = CacheTagHelper.objectToString((Object)xObj.value);
            int idletime = 0;
            idletime = xObj.timetoidle >= 0L ? (int)xObj.timetoidle : (prop != null && prop.get("TIMETOIDLESECONDS") != null ? Integer.valueOf((String)prop.get("TIMETOIDLESECONDS")) : (this.cacheConfig != null ? (int)this.cacheConfig.getCacheIdleTime() : 86400));
            int timetolive = 0;
            timetolive = xObj.timetoLive >= 0L ? (int)xObj.timetoLive : (prop != null && prop.get("TIMETOLIVESECONDS") != null ? Integer.valueOf((String)prop.get("TIMETOLIVESECONDS")) : (this.cacheConfig != null ? (int)this.cacheConfig.getCacheTimeSpan() : 86400));
            boolean isEternal = xObj.eternal;
            if (prop != null && prop.get("ETERNAL") != null) {
                isEternal = Cast._boolean(prop.get("ETERNAL"));
            } else if (this.cacheConfig != null) {
                isEternal = this.cacheConfig.isCacheEternal();
            }
            if (xObj.timetoidle == 0L && xObj.timetoLive == 0L) {
                isEternal = true;
            }
            if (isEternal) {
                timetolive = 0;
                idletime = 0;
            }
            String fullScript = timetolive > 0 ? LUA_STORE_METADATA_SCRIPT_EXPIRY : LUA_STORE_METADATA_SCRIPT;
            String[] args = new String[]{itemKey, cacheKey, Long.toString(System.currentTimeMillis()), Integer.toString(timetolive), Integer.toString(idletime), value};
            if (this.isCluster()) {
                ((JedisCluster)cacheMgr).eval(fullScript, 2, args);
            } else if (timetolive > 0) {
                if (!((Jedis)cacheMgr).scriptExists(putScriptSha1Digest2).booleanValue()) {
                    putScriptSha1Digest2 = ((Jedis)cacheMgr).scriptLoad(fullScript);
                }
                ((Jedis)cacheMgr).evalsha(putScriptSha1Digest2, 2, args);
            } else {
                if (!((Jedis)cacheMgr).scriptExists(putScriptSha1Digest1).booleanValue()) {
                    putScriptSha1Digest1 = ((Jedis)cacheMgr).scriptLoad(fullScript);
                }
                ((Jedis)cacheMgr).evalsha(putScriptSha1Digest1, 2, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeClient(cacheMgr);
        }
    }

    private String getHashtaggedCachekey(String cacheKey) {
        if (cacheKey.startsWith(OPEN_BRACE)) {
            return cacheKey;
        }
        return OPEN_BRACE + cacheKey + CLOSE_BRACE;
    }

    public List getCacheProperties(String region) {
        ArrayList result = new ArrayList();
        String appName = FusionContext.getCurrent().getApplicationName();
        if (region == null) {
            this.populateCacheProperties(appName, null, "OBJECT", result);
            this.populateCacheProperties(appName, null, "TEMPLATE", result);
            this.populateCacheProperties(appName, null, "QUERY", result);
        } else {
            this.populateCacheProperties(appName, null, region, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCacheProperties(String appName, String objType, String region, ArrayList result) {
        if (objType == null) {
            objType = "OBJECT";
        }
        String mgrKey = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)objType, (String)this.configFilePath);
        JedisCommands client = this.getClient();
        try {
            String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
            if (!this.cacheExists(region, objType) && !CacheTagHelper.isStandardCacheRegion((String)region)) {
                throw new CacheExceptions.CacheNotFoundException(region);
            }
            objType = !CacheTagHelper.isStandardCacheRegion((String)region) ? "ANY" : region.toUpperCase();
            Struct objSettings = new Struct();
            objSettings.put((Object)"OBJECTTYPE", (Object)objType);
            String cacheName = CacheTagHelper.getTrimmedCacheName((String)mgrCalcKey, (String)appName);
            objSettings.put((Object)"NAME", (Object)cacheName);
            Map map = client.hgetAll("redisstats_cache_properties:" + this.getHashtaggedCachekey(mgrCalcKey));
            Number idletime = 86400;
            Number timetolive = 86400;
            Boolean eternal = false;
            Object maxObjects = 10000;
            if (null != map) {
                timetolive = (map = new CaseInsensitiveHashtable(map)).get("TIMETOLIVESECONDS") != null ? map.get("TIMETOLIVESECONDS") : Long.valueOf(this.cacheConfig.getCacheTimeSpan());
                idletime = map.get("TIMETOIDLESECONDS") != null ? map.get("TIMETOIDLESECONDS") : Long.valueOf(this.cacheConfig.getCacheIdleTime());
                maxObjects = map.get("MAXELEMENTSINMEMORY") != null ? map.get("MAXELEMENTSINMEMORY") : (map.get("MAXENTRIESLOCALHEAP") != null ? map.get("MAXENTRIESLOCALHEAP") : Integer.valueOf(this.cacheConfig.getCacheMaxElements()));
                eternal = map.get("ETERNAL") != null ? map.get("ETERNAL") : Boolean.valueOf(this.cacheConfig.isCacheEternal());
            } else if (this.cacheConfig != null) {
                timetolive = this.cacheConfig.getCacheTimeSpan();
                idletime = this.cacheConfig.getCacheIdleTime();
                eternal = this.cacheConfig.isCacheEternal();
                maxObjects = this.cacheConfig.getCacheMaxElements();
            }
            objSettings.put((Object)"TIMETOIDLESECONDS", (Object)idletime);
            objSettings.put((Object)"TIMETOLIVESECONDS", (Object)timetolive);
            objSettings.put((Object)"ETERNAL", (Object)eternal);
            objSettings.put((Object)"MAXELEMENTSINMEMORY", maxObjects);
            result.add(objSettings);
        }
        finally {
            this.closeClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(String region) {
        JedisCommands cMgr = this.getClient();
        try {
            List<String> allCaches = this.getApplicationRegionCaches(region);
            allCaches.add(region);
            for (String cache : allCaches) {
                List<String> keys = this.getAllKeysForRegion(cache);
                for (String key : keys) {
                    this.deleteKey(key, key.split("___")[0], cMgr);
                }
            }
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    private List<String> getApplicationRegionCaches(String region) {
        Enumeration appNames;
        ArrayList<String> caches = new ArrayList<String>();
        if (!this.isApplicationSpecificCache() && CacheTagHelper.isStandardCacheRegion((String)region) && (appNames = ApplicationScopeTracker.getApplicationKeys()) != null) {
            while (appNames.hasMoreElements()) {
                String cacheKey = CacheTagHelper.getCacheKey2((String)region, (String)((String)appNames.nextElement()), null, (String)this.configFilePath);
                caches.add(cacheKey);
            }
        }
        return caches;
    }

    public ArrayList getAllCacheMetadataForMonitoring(boolean server) {
        String[] regions = this.getAllCacheNames();
        ArrayList<Struct> appr = new ArrayList<Struct>();
        for (String region : regions) {
            Struct resultObj = new Struct();
            if (CacheTagHelper.skipRegionForMonitoring((String)region, (String)this.configFilePath, (String)this.applicationName, (boolean)server)) continue;
            resultObj = this.getAllCacheMetadataForMonitoring(region, server);
            appr.add(resultObj);
        }
        return appr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Struct getAllCacheMetadataForMonitoring(String region, boolean server) {
        Struct resultObj = new Struct();
        JedisCommands cMgr = this.getClient();
        try {
            String cacheKey = this.getHashtaggedCachekey(region);
            String metaname = CacheTagHelper.getRegionNameForMonitoring((String)region, (String)this.applicationName, (GenericCache)this, (boolean)server);
            resultObj.put((Object)"APPLICATIONNAME", (Object)metaname);
            resultObj.put((Object)"ENGINE", (Object)this.getEngine());
            String hitCount = cMgr.hget(cacheKey, REDISSTATS_CACHE_HITCOUNT);
            if (hitCount == null) {
                resultObj.put((Object)"CACHE_HITCOUNT", (Object)0);
            } else {
                resultObj.put((Object)"CACHE_HITCOUNT", (Object)hitCount);
            }
            String missCount = cMgr.hget(cacheKey, REDISSTATS_CACHE_MISSCOUNT);
            if (missCount == null) {
                resultObj.put((Object)"CACHE_MISSCOUNT", (Object)0);
            } else {
                resultObj.put((Object)"CACHE_MISSCOUNT", (Object)missCount);
            }
            ScanParams scanParams = new ScanParams();
            scanParams.match(cacheKey + ":*");
            String cursor = ScanParams.SCAN_POINTER_START;
            boolean cycleIsFinished = false;
            long cummSize = 0L;
            long size = 0L;
            while (!cycleIsFinished) {
                ScanResult scanResult = null;
                scanResult = this.isCluster() ? ((JedisCluster)cMgr).scan(cursor, scanParams) : ((Jedis)cMgr).scan(cursor, scanParams);
                List result = scanResult.getResult();
                for (String k : result) {
                    if (this.isStatisticsKey(k)) continue;
                    ++size;
                    cummSize += this.getItemSize(k);
                }
                cursor = scanResult.getCursor();
                if (!cursor.equals("0")) continue;
                cycleIsFinished = true;
            }
            resultObj.put((Object)"NUMBER", (Object)new Long(size));
            resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
            Double mc = 0.0;
            if (null != missCount) {
                mc = Double.valueOf(missCount);
            }
            if (hitCount == null || Double.valueOf(hitCount) == 0.0) {
                resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
            } else {
                resultObj.put((Object)"HITRATIO", (Object)new Double(Double.valueOf(hitCount) / (mc + Double.valueOf(hitCount))));
            }
            Struct struct = resultObj;
            return struct;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(String cacheName) {
        if (cacheName != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)cacheName)) {
                throw new CacheExceptions.ImpicitCacheRegionDeletionException(cacheName);
            }
            JedisCommands cMgr = this.getClient();
            try {
                String cacheKey = CacheTagHelper.getCacheKey2((String)cacheName, (String)FusionContext.getCurrent().getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
                if (!this.cacheExists(cacheName)) {
                    throw new CacheExceptions.CacheNotFoundException(cacheName);
                }
                ScanParams scanParams = new ScanParams();
                scanParams.match(this.getHashtaggedCachekey(cacheKey) + ":*");
                String cursor = ScanParams.SCAN_POINTER_START;
                boolean cycleIsFinished = false;
                while (!cycleIsFinished) {
                    ScanResult scanResult = null;
                    scanResult = this.isCluster() ? ((JedisCluster)cMgr).scan(cursor, scanParams) : ((Jedis)cMgr).scan(cursor, scanParams);
                    List result = scanResult.getResult();
                    for (String key : result) {
                        this.deleteKey(key, this.getHashtaggedCachekey(cacheKey), cMgr);
                    }
                    cursor = scanResult.getCursor();
                    if (!cursor.equals("0")) continue;
                    cycleIsFinished = true;
                }
                cMgr.srem(REDIS_CACHE_NAMES, new String[]{cacheKey});
                cMgr.del(cacheKey);
            }
            finally {
                this.closeClient(cMgr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllCacheNames() {
        JedisCommands cMgr = this.getClient();
        try {
            Set caches = cMgr.smembers(REDIS_CACHE_NAMES);
            if (caches != null) {
                String[] stringArray = (String[])caches.stream().toArray(String[]::new);
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    public boolean isApplicationSpecificCache() {
        return this.configFilePath != null;
    }

    private boolean isCluster() {
        return ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getSessionStorageIsCluster();
    }

    private synchronized void initCacheManager() {
        if (this.jedisPool == null && (this.jedisCluster == null || this.jedisCluster.getClusterNodes() == null || this.jedisCluster.getClusterNodes().size() == 0)) {
            try {
                boolean isCluster = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getSessionStorageIsCluster();
                String host1 = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getRedisCacheStorageHost();
                int port1 = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getRedisCacheStoragePort();
                String password = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getRedisCacheStoragePassword();
                boolean isSSL1 = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getRedisCacheStorageIsSSL();
                if (this.isCFLoginRedisSessionStorage) {
                    host1 = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getSessionStorageHost();
                    port1 = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getSessionStoragePort();
                    password = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getSessionStoragePassword();
                    isSSL1 = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getSessionStorageSSLEnabled();
                }
                final String host = host1;
                final int port = port1;
                final boolean isSSL = isSSL1;
                if (null != password) {
                    password = PasswordUtils.decryptPassword((String)password, (String)this.seed);
                }
                final GenericObjectPoolConfig config = new GenericObjectPoolConfig();
                config.setMaxTotal(this.maxConnections);
                config.setBlockWhenExhausted(this.blockWhenExhausted);
                config.setMaxWaitMillis((long)this.maxwaitMillis);
                config.setTestOnBorrow(this.validateConnection);
                config.setTestOnReturn(this.validateConnectionOnCheckout);
                if (isCluster) {
                    try {
                        final String pass = password;
                        this.jedisCluster = AccessController.doPrivileged(new PrivilegedExceptionAction<JedisCluster>(){

                            @Override
                            public JedisCluster run() {
                                HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
                                if (host.contains(",")) {
                                    for (String hst : host.split(",")) {
                                        jedisClusterNode.add(new HostAndPort(hst, port));
                                    }
                                } else {
                                    jedisClusterNode.add(new HostAndPort(host, port));
                                }
                                if (pass != null && pass.length() > 0) {
                                    return new JedisCluster(jedisClusterNode, GenericRedisCache.this.timeout, GenericRedisCache.this.timeout, 5, pass, config);
                                }
                                return new JedisCluster(jedisClusterNode, GenericRedisCache.this.timeout, config);
                            }
                        });
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error((Object)"Error initializing redis cluster", (Throwable)e);
                    }
                } else {
                    try {
                        final String pass = password;
                        this.jedisPool = AccessController.doPrivileged(new PrivilegedExceptionAction<JedisPool>(){

                            @Override
                            public JedisPool run() {
                                if (pass != null && pass.length() > 0) {
                                    return new JedisPool(config, host, port, GenericRedisCache.this.timeout, pass, isSSL);
                                }
                                return new JedisPool(config, host, port, GenericRedisCache.this.timeout, isSSL);
                            }
                        });
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error((Object)"Error initializing redis", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
                throw new CacheExceptions.CacheInitializationException(e.getMessage());
            }
        }
    }

    public JedisCommands getClient() {
        this.initCacheManager();
        if (this.jedisCluster != null) {
            return this.jedisCluster;
        }
        if (null == this.jedisPool) {
            this.initCacheManager();
        }
        return this.jedisPool.getResource();
    }

    public Object getCache(String appname, String objecttype, String key) {
        return this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initCleanupService() {
        if (cleanupService != null || this.cacheConfig.isCacheMaxIdleLazyEviction()) return;
        Class<GenericRedisCache> clazz = GenericRedisCache.class;
        synchronized (GenericRedisCache.class) {
            if (cleanupService == null) {
                cleanupService = Executors.newSingleThreadScheduledExecutor();
            }
            cleanupService.scheduleAtFixedRate(this.cleanupThread, 0L, this.idletimeCheckThreadInterval, TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdleItems() {
        JedisCommands cMgr = this.getClient();
        try {
            ScanParams scanParams = new ScanParams();
            scanParams.match("*");
            String cursor = ScanParams.SCAN_POINTER_START;
            boolean cycleIsFinished = false;
            while (!cycleIsFinished) {
                ScanResult scanResult = null;
                scanResult = this.isCluster() ? ((JedisCluster)cMgr).scan(cursor, scanParams) : ((Jedis)cMgr).scan(cursor, scanParams);
                List result = scanResult.getResult();
                for (String key : result) {
                    try {
                        if (!cMgr.type(key).equals("hash") || !cMgr.hexists(key, REDISSTATS_KEY_IDELTIME)) continue;
                        List value = null;
                        value = cMgr.hmget(key, new String[]{VALUE, REDISSTATS_KEY_HITCOUNT, REDISSTATS_KEY_LASTACCESS, REDISSTATS_KEY_CREATETIME, REDISSTATS_KEY_TIMESPAN, REDISSTATS_KEY_IDELTIME, REDISSTATS_KEY_UPDATETIME});
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        metadata.put(REDISSTATS_KEY_UPDATETIME, (String)value.get(6));
                        metadata.put(REDISSTATS_KEY_CREATETIME, (String)value.get(3));
                        metadata.put(REDISSTATS_KEY_TIMESPAN, (String)value.get(4));
                        metadata.put(REDISSTATS_KEY_IDELTIME, (String)value.get(5));
                        metadata.put(REDISSTATS_KEY_HITCOUNT, (String)value.get(1));
                        metadata.put(VALUE, (String)value.get(0));
                        metadata.put(REDISSTATS_KEY_LASTACCESS, (String)value.get(2));
                        this.removeIfIdleExpired(cMgr, metadata, key, key.split("___")[0]);
                    }
                    catch (Exception e) {
                        CFLogs.APPLICATION_LOG.error((Throwable)e);
                    }
                }
                cursor = scanResult.getCursor();
                if (!cursor.equals("0")) continue;
                cycleIsFinished = true;
            }
        }
        finally {
            this.closeClient(cMgr);
        }
    }

    private boolean removeIfIdleExpired(JedisCommands cMgr, Map<String, String> metadata, String key, String cacheKey) {
        if (metadata.get(VALUE) == null) {
            return false;
        }
        Long updateTime = 0L;
        updateTime = metadata.containsKey(REDISSTATS_KEY_LASTACCESS) && metadata.get(REDISSTATS_KEY_LASTACCESS) != null ? Long.valueOf(metadata.get(REDISSTATS_KEY_LASTACCESS)) : Long.valueOf(metadata.get(REDISSTATS_KEY_UPDATETIME));
        Long idleTime = Long.valueOf(metadata.get(REDISSTATS_KEY_IDELTIME));
        long dif = (System.currentTimeMillis() - updateTime) / 1000L;
        if (dif > idleTime && idleTime > 0L) {
            this.deleteKey(key, cacheKey, cMgr);
            this.incrementMisscount(cMgr, cacheKey);
            return true;
        }
        return false;
    }

    private void incrementMisscount(JedisCommands cMgr, String cacheKey) {
        if (this.isCluster()) {
            ((JedisCluster)cMgr).hincrBy(cacheKey, REDISSTATS_CACHE_MISSCOUNT, 1L);
        } else {
            ((Jedis)cMgr).hincrBy(cacheKey, REDISSTATS_CACHE_MISSCOUNT, 1L);
        }
    }

    public void reset() {
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
        this.jedisPool = null;
        if (this.jedisCluster != null) {
            this.jedisCluster.close();
            this.jedisCluster = null;
        }
        this.initConfig();
    }

    public String getEngine() {
        return "Redis";
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
        }
    }
}

