/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cache.memcached;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheConfig;
import coldfusion.tagext.io.cache.CacheEntry;
import coldfusion.tagext.io.cache.CacheException;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.util.CaseInsensitiveHashtable;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import redis.clients.jedis.JedisPool;

public class GenericMemcachedCache
extends GenericCache {
    private String configFilePath;
    private String applicationName;
    private JedisPool jedisPool = null;
    private static final String MCSTATS_CACHE_MISSCOUNT = "MCSTATS_cache_misscount";
    private static final String MCSTATS_CACHE_HITCOUNT = "MCSTATS_cache_hitcount";
    private static final String MC_CACHE_NAMES = "mc_cache_names";
    private static final String MC_CACHE = "mc_cache";
    private static final String PROP_MAXMEMORYIDLETIMESECONDS = "MAXMEMORYIDLETIMESECONDS";
    private static final String PROP_MAXKEYSIZE = "MAXKEYSIZE";
    private static final String VALUE = "value";
    private static final String MC_QUERY_SPACE_REPLACEMENT = "$$";
    private int maxElements = -1;
    private CacheConfig cacheConfig = new CacheConfig();
    private int idletimeCheckThreadInterval = 5;
    private MemcachedClient mcClient;
    private static ScheduledExecutorService cleanupService = null;
    private static ScheduledExecutorService refreshService = null;
    Runnable cleanupThread = new Runnable(){

        @Override
        public void run() {
            GenericMemcachedCache.this.removeIdleItems();
        }
    };
    Runnable refreshThread = new Runnable(){

        @Override
        public void run() {
            MemcachedClient client = GenericMemcachedCache.this.getClient();
            Set cacheNames = (Set)client.get(GenericMemcachedCache.MC_CACHE_NAMES);
            if (cacheNames != null) {
                for (String cache : cacheNames) {
                    String values = (String)client.get(cache);
                    if (values == null) continue;
                    String[] split = values.split(" ");
                    HashSet<String> set = new HashSet<String>(Arrays.asList(split));
                    StringBuilder sb = new StringBuilder();
                    if (set.size() == split.length) continue;
                    for (String s : set) {
                        sb.append(s).append(" ");
                    }
                    client.set(cache, 0, (Object)sb.toString());
                }
            }
        }
    };

    public GenericMemcachedCache() {
        this.initConfig();
        this.initCleanupService();
    }

    private void initConfig() {
        final Properties p = new Properties();
        final String serverPropFile = ServiceFactory.getRuntimeService().getLibDir() + "/memcachedcache.properties";
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try (FileInputStream fis = new FileInputStream(serverPropFile);){
                        p.load(fis);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
            CaseInsensitiveHashtable props = new CaseInsensitiveHashtable((Map)p);
            if (props.containsKey((Object)"TIMETOIDLESECONDS")) {
                this.cacheConfig.setCacheIdleTime(Cast._long((Object)props.get((Object)"TIMETOIDLESECONDS")));
            } else {
                this.cacheConfig.setCacheIdleTime(86400L);
            }
            if (props.containsKey((Object)"TIMETOLIVESECONDS")) {
                this.cacheConfig.setCacheTimeSpan(Cast._long((Object)props.get((Object)"TIMETOLIVESECONDS")));
            } else {
                this.cacheConfig.setCacheTimeSpan(86400L);
            }
            if (props.containsKey((Object)"ETERNAL")) {
                this.cacheConfig.setCacheEternal(Cast._boolean((Object)props.get((Object)"ETERNAL")));
            }
            if (props.containsKey((Object)"MAXIDLELAZYEVICTION")) {
                this.cacheConfig.setCacheMaxIdleLazyEviction(Cast._boolean((Object)props.get((Object)"MAXIDLELAZYEVICTION")));
            } else {
                this.cacheConfig.setCacheMaxIdleLazyEviction(true);
            }
            if (props.containsKey((Object)"MAXELEMENTSCHECK")) {
                this.cacheConfig.setCacheMaxElementsCheck(Cast._boolean((Object)props.get((Object)"MAXELEMENTSCHECK")));
            } else {
                this.cacheConfig.setCacheMaxElementsCheck(true);
            }
            if (props.containsKey((Object)"METADATA")) {
                this.cacheConfig.setCacheMetadata(Cast._boolean((Object)props.get((Object)"METADATA")));
            } else {
                this.cacheConfig.setCacheMetadata(true);
            }
            if (props.containsKey((Object)"MAXELEMENTSINMEMORY")) {
                this.cacheConfig.setCacheMaxElements(Cast._int((Object)props.get((Object)"MAXELEMENTSINMEMORY")));
            } else {
                this.cacheConfig.setCacheMaxElements(10000);
            }
            if (props.containsKey((Object)"EVICTIONCHUNKSIZE")) {
                this.cacheConfig.setCacheSpoolChunkSize(Cast._int((Object)props.get((Object)"EVICTIONCHUNKSIZE")));
            } else {
                this.cacheConfig.setCacheSpoolChunkSize(100);
            }
            if (props.containsKey((Object)"IDLETIMECHECKTHREADINTERVAL")) {
                this.idletimeCheckThreadInterval = Cast._int((Object)props.get((Object)"IDLETIMECHECKTHREADINTERVAL"));
            }
        }
        catch (Exception e) {
            throw new CacheException();
        }
    }

    public GenericMemcachedCache(String configPath, String appname, Map config) {
        this.applicationName = appname;
        this.initConfig();
        if (configPath != null) {
            this.configFilePath = configPath.trim();
            this.configFilePath = CacheTagHelper.resolveConfigFilePath((String)this.configFilePath);
            CacheTagHelper.readApplicationLevelProperties((String)this.configFilePath, (CacheConfig)this.cacheConfig, (Map)config);
        }
        this.initCleanupService();
    }

    public Object getMetadata() {
        return null;
    }

    public void setCacheProperties(Map map, String region) {
        if (map != null && map instanceof Struct) {
            String appName = FusionContext.getCurrent().getApplicationName();
            String objectType = this.toStringValue(map.get("OBJECTTYPE"), "ALL").trim();
            String cacheName = null;
            if (region == null && CacheTagHelper.isStandardCacheRegion((String)objectType)) {
                region = objectType;
            }
            if (region == null && "ALL".equalsIgnoreCase(objectType)) {
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                this.setPropertyOnCache(cacheName, map);
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
                this.setPropertyOnCache(cacheName, map);
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"QUERY", (String)this.configFilePath);
                this.setPropertyOnCache(cacheName, map);
            } else {
                if (region != null && (region.equalsIgnoreCase("OBJECT") || region.equalsIgnoreCase("QUERY") || region.equalsIgnoreCase("TEMPLATE"))) {
                    region = region.toUpperCase();
                    cacheName = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                } else {
                    cacheName = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                    if (!this.cacheExists(region)) {
                        throw new CacheExceptions.CacheNotFoundException(region);
                    }
                }
                this.setPropertyOnCache(cacheName, map);
            }
        }
    }

    private void setPropertyOnCache(String cacheName, Map<Object, Object> map) {
        MemcachedClient client = this.getClient();
        if (cacheName != null) {
            String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)cacheName);
            boolean exist = true;
            String[] regions = this.getAllCacheNames();
            exist = Arrays.asList(regions).contains(mgrCalcKey);
            if (!exist) {
                if (client.get(MC_CACHE_NAMES) == null) {
                    client.add(MC_CACHE_NAMES, 0, new HashSet());
                }
                Set cacheNames = (Set)client.get(MC_CACHE_NAMES);
                cacheNames.add(mgrCalcKey);
                client.set(mgrCalcKey, 0, (Object)"");
                client.set(MC_CACHE_NAMES, 0, (Object)cacheNames);
                cacheName = mgrCalcKey;
            }
        }
        if (null != map) {
            CaseInsensitiveHashtable imap = new CaseInsensitiveHashtable();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                imap.put(entry.getKey(), entry.getValue());
            }
            if (imap.containsKey("MAXENTRIESLOCALHEAP")) {
                imap.put("MAXELEMENTSINMEMORY", imap.get("MAXENTRIESLOCALHEAP"));
            }
            client.set("mc_cache:" + cacheName, 0, (Object)imap);
        }
    }

    public boolean cacheExists(String region, String type) {
        String[] regions = this.getAllCacheNames();
        region = CacheTagHelper.getCacheKey2((String)region, (String)FusionContext.getCurrent().getApplicationName(), (String)type, (String)this.configFilePath);
        return Arrays.asList(regions).contains(region);
    }

    public Object createCache(String mgrKey, String objType, String diskStore, Map properties) {
        Set cacheNames;
        if (mgrKey != null && mgrKey.trim().length() == 0) {
            throw new CacheExceptions.InvalidCacheNameException();
        }
        String appName = null;
        FusionContext context = FusionContext.getCurrent();
        if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        mgrKey = CacheTagHelper.getCacheKey2((String)mgrKey, (String)appName, (String)objType, (String)this.configFilePath);
        String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
        mgrCalcKey = this.trimKey(mgrCalcKey);
        MemcachedClient client = this.getClient();
        if (client.get(MC_CACHE_NAMES) == null) {
            client.add(MC_CACHE_NAMES, 0, new HashSet());
        }
        if (!(cacheNames = (Set)client.get(MC_CACHE_NAMES)).contains(mgrCalcKey)) {
            cacheNames.add(mgrCalcKey);
            client.set(MC_CACHE_NAMES, 0, (Object)cacheNames);
        }
        if (properties == null) {
            properties = new Struct();
        }
        client.set("mc_cache:" + mgrCalcKey, 0, (Object)properties);
        client.set(mgrCalcKey + ":MCSTATS_cache_hitcount", 0, (Object)0);
        client.set(mgrCalcKey + ":MCSTATS_cache_misscount", 0, (Object)0);
        client.set(mgrCalcKey, 0, (Object)"");
        return this.getClient();
    }

    public boolean cacheExists(String region) {
        String[] regions = this.getAllCacheNames();
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            region = CacheTagHelper.getCacheKey2((String)region, (String)fContext.getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
        }
        return Arrays.asList(regions).contains(region);
    }

    public Object get(CacheTO xObj, boolean throwError, Long within) {
        MemcachedClient client = this.getClient();
        Object obj = client.get(this.getMemcachedItemKey(xObj, throwError));
        Object value = null;
        Object result = null;
        if (null != obj) {
            value = ((CacheEntry)obj).getValue();
            Long createKey = ((CacheEntry)obj).getCreateTime();
            if (value != null) {
                try {
                    result = value;
                }
                catch (Exception e) {
                    CFLogs.APPLICATION_LOG.error((Throwable)e);
                }
            } else {
                value = null;
            }
        }
        if (value != null) {
            this.updateStats(xObj, obj);
        }
        return result;
    }

    public Object get(CacheTO xObj, boolean throwError) {
        MemcachedClient client = this.getClient();
        Object value = null;
        String key = this.getMemcachedItemKey(xObj, throwError);
        Object obj = client.get(key);
        if (obj != null) {
            value = ((CacheEntry)obj).getValue();
        }
        if (this.cacheConfig.isCacheMaxIdleLazyEviction() && this.removeIfIdleExpired(client, key)) {
            return null;
        }
        this.updateStats(xObj, obj);
        if (value != null) {
            try {
                long checkTime;
                long lastModified;
                if (!xObj.getQuiet && "TEMPLATE".equalsIgnoreCase(xObj.objecttype) && (lastModified = TemplateClassLoader.getLastModifiedTime((String)FusionContext.getCurrent().getPagePath())) > (checkTime = this.getUpdateTimeOfElement(xObj))) {
                    return null;
                }
            }
            catch (Exception lastModified) {
                // empty catch block
            }
            try {
                return value;
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void updateStats(CacheTO xObj, Object value) {
        if (!xObj.getQuiet) {
            MemcachedClient client = this.getClient();
            if (this.cacheConfig != null && !this.cacheConfig.isCacheMetadata()) {
                return;
            }
            String itemKey = null;
            String cacheKey = null;
            itemKey = this.getMemcachedItemKey(xObj);
            cacheKey = this.getMemcachedCacheKey(xObj);
            Object obj = value;
            if (null != obj) {
                CacheEntry item = (CacheEntry)obj;
                long time = (long)item.getTimeToLive() - (System.currentTimeMillis() - item.getCreateTime()) / 1000L;
                if (item.getTimeToLive() == 0) {
                    time = 0L;
                }
                item.setLastAccessTime(Long.valueOf(System.currentTimeMillis()));
                item.setHits(item.getHits() + 1);
                client.set(itemKey, (int)time, (Object)item);
            }
            if (null != value) {
                count = client.get(cacheKey + ":MCSTATS_cache_hitcount");
                Integer c = 1;
                if (count != null) {
                    c = c + (Integer)count;
                }
                client.set(cacheKey + ":MCSTATS_cache_hitcount", 0, (Object)c);
            } else {
                count = client.get(cacheKey + ":MCSTATS_cache_misscount");
                Integer c = 1;
                if (count != null) {
                    c = c + (Integer)count;
                }
                client.set(cacheKey + ":MCSTATS_cache_misscount", 0, (Object)c);
            }
        }
    }

    private String getMemcachedItemKey(CacheTO xObj) {
        return this.getMemcachedItemKey(xObj, true);
    }

    private String getMemcachedItemKey(CacheTO xObj, boolean throwError, String mgrKey) {
        Object finalKey = mgrKey;
        if (null != xObj && xObj.id != null) {
            xObj.id.hashCode();
            finalKey = (String)finalKey + ":" + xObj.id.toString();
        }
        if (((String)finalKey).length() > 250) {
            finalKey = mgrKey + ":" + GenericMemcachedCache.hash(xObj.id.toString(), "SHA-256");
        }
        finalKey = this.trimKey((String)finalKey);
        return finalKey;
    }

    private String trimKey(String finalKey) {
        finalKey = finalKey.replaceAll("\n", "");
        finalKey = finalKey.replaceAll("\r", "");
        finalKey = finalKey.replaceAll("\t", "");
        finalKey = finalKey.replace(" ", MC_QUERY_SPACE_REPLACEMENT);
        return finalKey;
    }

    private String getMemcachedItemKey(CacheTO xObj, boolean throwError) {
        String mgrKey = this.getMemcachedCacheKey(xObj, throwError);
        return this.getMemcachedItemKey(xObj, throwError, mgrKey);
    }

    public static String hash(String input, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(input.getBytes(StandardCharsets.US_ASCII));
            byte[] appKeyBytes = digest.digest();
            return GenericMemcachedCache.stringify(appKeyBytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }

    private String getMemcachedCacheKey(CacheTO xObj) {
        return this.getMemcachedCacheKey(xObj, true);
    }

    private String getMemcachedCacheKey(CacheTO xObj, boolean throwError) {
        String mgrKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
        boolean exist = false;
        String[] regions = this.getAllCacheNames();
        exist = Arrays.asList(regions).contains(mgrKey);
        if (!(!throwError || exist || xObj.region == null || xObj.region.equalsIgnoreCase("OBJECT") || xObj.region.equalsIgnoreCase("QUERY") || xObj.region.equalsIgnoreCase("TEMPLATE"))) {
            throw new CacheExceptions.CacheNotFoundException(xObj.region);
        }
        if (!exist) {
            this.createCache(xObj.region, xObj.objecttype, null, null);
            String appName = null;
            FusionContext context = FusionContext.getCurrent();
            if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
                appName = context.cacheConfig.applicationName;
            }
            mgrKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)appName, (String)xObj.objecttype, (String)this.configFilePath);
        }
        mgrKey = this.trimKey(mgrKey);
        return mgrKey;
    }

    public long getUpdateTimeOfElement(CacheTO xObj) {
        MemcachedClient client = this.getClient();
        Object obj = client.get(this.getMemcachedItemKey(xObj));
        if (null != obj) {
            return ((CacheEntry)obj).getLastUpdateTime();
        }
        return 0L;
    }

    public Map getMetadata(CacheTO xObj) {
        CaseInsensitiveHashtable result = new CaseInsensitiveHashtable();
        MemcachedClient client = this.getClient();
        String itemKey = this.getMemcachedItemKey(xObj);
        String cacheKey = this.getMemcachedCacheKey(xObj);
        try {
            Object obj = client.get(itemKey);
            if (null == obj) {
                return result;
            }
            CacheEntry item = (CacheEntry)obj;
            result.put("HITCOUNT", item.getHits());
            result.put("TIMESPAN", item.getTimeToLive());
            result.put("IDLETIME", item.getIdleTime());
            if (item.getLastAccessTime() != null) {
                result.put("LASTHIT", new OleDateTime(item.getLastAccessTime().longValue()));
            } else {
                result.put("LASTHIT", new OleDateTime(item.getLastUpdateTime().longValue()));
            }
            result.put("LASTUPDATED", new OleDateTime(item.getLastUpdateTime().longValue()));
            result.put("CREATEDTIME", new OleDateTime(item.getCreateTime().longValue()));
            result.put("SIZE", this.getItemSize(itemKey));
            Integer hitCount = (Integer)client.get(cacheKey + ":MCSTATS_cache_hitcount");
            result.put("CACHE_HITCOUNT", hitCount);
            Integer missCount = (Integer)client.get(cacheKey + ":MCSTATS_cache_misscount");
            if (missCount == null) {
                result.put("CACHE_MISSCOUNT", 0);
            } else {
                result.put("CACHE_MISSCOUNT", missCount);
            }
            String cacheName = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
            result.put("NAME", CacheTagHelper.getTrimmedCacheName((String)cacheName, (String)xObj.appname));
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.error((Throwable)e);
        }
        return result;
    }

    private long getItemSize(String itemKey) {
        MemcachedClient client = this.getClient();
        CacheEntry entry = (CacheEntry)client.get(itemKey);
        long size = 0L;
        return size += CacheTagHelper.getSerializedSize((Object)entry) + CacheTagHelper.getSerializedSize((Object)itemKey);
    }

    public List getObjectCacheMetadata(String appName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (appName != null) {
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
            return result;
        }
        String[] cacheNames = this.getAllCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("OBJECT") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("OBJECT"));
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
        }
        return result;
    }

    private Object populatePerAppMetadata(String region, String appName) {
        Struct resultObj = new Struct();
        Set<String> keys = this.getAllKeysForRegion(region);
        MemcachedClient client = this.getClient();
        long cummSize = 0L;
        long size = 0L;
        if (keys != null) {
            ArrayList<Struct> objects = new ArrayList<Struct>();
            try {
                for (String key : keys) {
                    Struct objMeta = new Struct();
                    objMeta.put((Object)"ID", (Object)key);
                    CacheTO statsTo = new CacheTO();
                    statsTo.setId(client.get(key));
                    statsTo.setKey(null);
                    statsTo.setAppname(appName);
                    statsTo.setObjecttype("OBJECT");
                    statsTo.getQuiet = true;
                    Map metadata = this.getMetadata(statsTo);
                    objMeta.put((Object)"SIZE", metadata.get("SIZE"));
                    objMeta.put((Object)"HITCOUNT", metadata.get("HITCOUNT"));
                    if (!this.isStatisticsKey(key)) {
                        cummSize += this.getItemSize(key);
                        ++size;
                    }
                    objects.add(objMeta);
                }
                resultObj.put((Object)"OBJECTS", objects);
                Integer hitCount = (Integer)client.get(region + ":MCSTATS_cache_hitcount");
                Integer missCount = (Integer)client.get(region + ":MCSTATS_cache_misscount");
                if (missCount == null) {
                    resultObj.put((Object)"CACHE_MISSCOUNT", (Object)0);
                } else {
                    resultObj.put((Object)"CACHE_MISSCOUNT", (Object)missCount);
                }
                resultObj.put((Object)"CACHE_HITCOUNT", (Object)hitCount);
                Double mc = 0.0;
                if (null != missCount) {
                    mc = (double)missCount;
                }
                if (hitCount == null || Double.valueOf(hitCount.intValue()) == 0.0) {
                    resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                } else {
                    resultObj.put((Object)"HITRATIO", (Object)new Double(Double.valueOf(hitCount.intValue()) / (mc + Double.valueOf(hitCount.intValue()))));
                }
                resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
                resultObj.put((Object)"NUMBER", (Object)new Long(size));
                resultObj.put((Object)"APPLICATIONNAME", (Object)appName);
            }
            catch (Exception e) {
                return resultObj;
            }
        }
        return resultObj;
    }

    private boolean isStatisticsKey(String key) {
        return key.contains("MCSTATS_");
    }

    private Set<String> getAllKeysForRegion(String region) {
        MemcachedClient client = this.getClient();
        String values = (String)client.get(region);
        if (values != null) {
            String[] split = values.split(" ");
            if (split.length == 1 && split[0].length() == 0) {
                return null;
            }
            HashSet<String> set = new HashSet<String>(Arrays.asList(split));
            set.remove("");
            return set;
        }
        return null;
    }

    public List getTemplateCacheMetadata(String appName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (appName != null) {
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
            return result;
        }
        String[] cacheNames = this.getAllCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("OBJECT") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("TEMPLATE"));
            String mgrKey = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
            result.add(this.populatePerAppMetadata(mgrKey, appName));
        }
        return result;
    }

    public List<Object> getAllCacheIds(CacheTO xObj, boolean accurate) {
        String key = this.getMemcachedCacheKey(xObj);
        Set<String> allIds = this.getAllKeysForRegion(key);
        List<Object> res = new ArrayList<Object>();
        if (null != allIds) {
            res = accurate ? allIds.stream().filter(item -> !item.toLowerCase().contains("MCSTATS_") && !this.hasKeyExpired((String)item)).map(item -> CacheTagHelper.stringToObject((String)item.replace(MC_QUERY_SPACE_REPLACEMENT, " ").substring(item.indexOf(":") + 1))).collect(Collectors.toList()) : allIds.stream().filter(item -> !item.toLowerCase().contains("MCSTATS_")).map(item -> CacheTagHelper.stringToObject((String)item.replace(MC_QUERY_SPACE_REPLACEMENT, " ").substring(item.indexOf(":") + 1))).collect(Collectors.toList());
        }
        return res;
    }

    private int getAllCacheIdsCount(CacheTO xObj) {
        String key = this.getMemcachedCacheKey(xObj);
        MemcachedClient client = this.getClient();
        String values = (String)client.get(key);
        if (values != null) {
            String[] split = values.split(" ");
            return new HashSet<String>(Arrays.asList(split)).size() - 1;
        }
        return 0;
    }

    private boolean hasKeyExpired(String key) {
        MemcachedClient client = this.getClient();
        if (client.get(key) == null) {
            this.deleteKey(key);
            return true;
        }
        return false;
    }

    public void setMaxElementsInMemory(String cacheKey, int count) {
        this.maxElements = count;
    }

    public boolean remove(CacheTO xObj) {
        String cacheKey = this.getMemcachedCacheKey(xObj, true);
        String itemKey = this.getMemcachedItemKey(xObj);
        if (xObj.id != null) {
            MemcachedClient client = this.getClient();
            Object keyHash = xObj.id;
            if (xObj.exact && client.get(itemKey) != null) {
                this.deleteKey(itemKey);
                return true;
            }
            if (!xObj.exact && keyHash instanceof String) {
                boolean cacheDeleted = false;
                String matchCriteria = CacheTagHelper.createMatchCriteria((String)((String)keyHash));
                Set<String> keys = this.getAllKeysForRegion(cacheKey);
                if (keys != null) {
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        Object obj;
                        String key;
                        String tempkey = key = iterator.next();
                        if (key.contains(":")) {
                            tempkey = key.substring(key.indexOf(":") + 1);
                        }
                        if (!((obj = CacheTagHelper.stringToObject((String)tempkey)) instanceof String) || CFPage.REFindNoCase((String)matchCriteria, (String)CacheTagHelper.createMatchCriteria((String)((String)obj))) <= 0) continue;
                        this.deleteKey(key);
                        cacheDeleted = true;
                    }
                }
                return cacheDeleted;
            }
        } else if (!xObj.exact) {
            Set<String> keys = this.getAllKeysForRegion(this.getMemcachedCacheKey(xObj));
            if (null != keys) {
                for (String key : keys) {
                    this.deleteKey(key);
                }
            }
            return true;
        }
        return false;
    }

    public void put(CacheTO xObj, boolean throwOnError) {
        MemcachedClient client = this.getClient();
        String cacheKey = this.getMemcachedCacheKey(xObj, throwOnError);
        String itemKey = this.getMemcachedItemKey(xObj, throwOnError, cacheKey);
        Object prop = null;
        if (this.cacheConfig.isCacheMaxElementsCheck()) {
            Object obj = client.get("mc_cache:" + cacheKey);
            if (obj != null) {
                prop = new CaseInsensitiveHashtable((Map)obj);
            }
            if (prop == null) {
                prop = new HashMap();
            }
            if (this.cacheConfig != null && prop.get("MAXELEMENTSINMEMORY") == null && prop.get("MAXENTRIESLOCALHEAP") == null) {
                prop.put("MAXELEMENTSINMEMORY", "" + this.cacheConfig.getCacheMaxElements());
            }
            if (prop != null && (prop.get("MAXELEMENTSINMEMORY") != null || prop.get("MAXENTRIESLOCALHEAP") != null)) {
                long maxElemsValue;
                Object maxElems = prop.get("MAXELEMENTSINMEMORY");
                if (null == maxElems) {
                    maxElems = prop.get("MAXENTRIESLOCALHEAP");
                }
                if ((maxElemsValue = Cast._long(maxElems)) > 0L && (long)this.getAllCacheIdsCount(xObj) >= maxElemsValue) {
                    Set<String> keys = this.getAllKeysForRegion(cacheKey);
                    int sz = this.cacheConfig.getCacheSpoolChunkSize();
                    if (null != keys) {
                        Iterator<String> iter = keys.iterator();
                        int count = 0;
                        ArrayList<String> keysEffected = new ArrayList<String>();
                        while (iter.hasNext()) {
                            String first = iter.next();
                            if ((long)count++ < maxElemsValue - (long)sz - 1L) continue;
                            client.delete(first);
                            keysEffected.add(first);
                        }
                        keys.removeAll(keysEffected);
                        StringBuilder sb = new StringBuilder();
                        for (String s : keys) {
                            sb.append(s).append(" ");
                        }
                        client.set(cacheKey, 0, (Object)sb.toString());
                    }
                }
            }
        }
        CacheEntry item = new CacheEntry();
        item.setValue(xObj.value);
        int idletime = 0;
        idletime = xObj.timetoidle >= 0L ? (int)xObj.timetoidle : (prop != null && prop.get("TIMETOIDLESECONDS") != null ? Cast._int(prop.get("TIMETOIDLESECONDS")) : (this.cacheConfig != null ? (int)this.cacheConfig.getCacheIdleTime() : 86400));
        int timetolive = 0;
        timetolive = xObj.timetoLive >= 0L ? (int)xObj.timetoLive : (prop != null && prop.get("TIMETOLIVESECONDS") != null ? Cast._int(prop.get("TIMETOLIVESECONDS")) : (this.cacheConfig != null ? (int)this.cacheConfig.getCacheTimeSpan() : 86400));
        boolean isEternal = xObj.eternal;
        if (prop != null && prop.get("ETERNAL") != null) {
            isEternal = Cast._boolean(prop.get("ETERNAL"));
        } else if (this.cacheConfig != null) {
            isEternal = this.cacheConfig.isCacheEternal();
        }
        if (xObj.timetoidle == 0L && xObj.timetoLive == 0L) {
            isEternal = true;
        }
        if (isEternal) {
            timetolive = 0;
            idletime = 0;
        }
        item.setIdleTime(idletime);
        item.setTimeToLive(timetolive);
        long time = System.currentTimeMillis();
        item.setLastUpdateTime(Long.valueOf(time));
        item.setCreateTime(Long.valueOf(time));
        client.set(itemKey, timetolive, (Object)item);
        client.append(cacheKey, (Object)(" " + itemKey));
    }

    public List getCacheProperties(String region) {
        ArrayList result = new ArrayList();
        String appName = FusionContext.getCurrent().getApplicationName();
        if (region == null) {
            this.populateCacheProperties(appName, null, "OBJECT", result);
            this.populateCacheProperties(appName, null, "TEMPLATE", result);
            this.populateCacheProperties(appName, null, "QUERY", result);
        } else {
            this.populateCacheProperties(appName, null, region, result);
        }
        return result;
    }

    private void populateCacheProperties(String appName, String objType, String region, ArrayList result) {
        String cacheName;
        if (objType == null) {
            objType = "OBJECT";
        }
        String mgrKey = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)objType, (String)this.configFilePath);
        MemcachedClient client = this.getClient();
        String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
        if (!this.cacheExists(region, objType) && !CacheTagHelper.isStandardCacheRegion((String)region)) {
            throw new CacheExceptions.CacheNotFoundException(region);
        }
        objType = !CacheTagHelper.isStandardCacheRegion((String)region) ? "ANY" : region.toUpperCase();
        Struct objSettings = new Struct();
        objSettings.put((Object)"OBJECTTYPE", (Object)objType);
        String name = cacheName = CacheTagHelper.getTrimmedCacheName((String)mgrCalcKey, (String)appName);
        Object prop = client.get("mc_cache:" + mgrCalcKey);
        Map map = null;
        if (prop != null) {
            map = (Map)prop;
        }
        Number idletime = 86400;
        Number timetolive = 86400;
        Boolean eternal = false;
        Object maxObjects = 10000;
        if (null != map) {
            timetolive = map.get("TIMETOLIVESECONDS") != null ? map.get("TIMETOLIVESECONDS") : Long.valueOf(this.cacheConfig.getCacheTimeSpan());
            idletime = map.get("TIMETOIDLESECONDS") != null ? map.get("TIMETOIDLESECONDS") : Long.valueOf(this.cacheConfig.getCacheIdleTime());
            maxObjects = map.get("MAXELEMENTSINMEMORY") != null ? map.get("MAXELEMENTSINMEMORY") : (map.get("MAXENTRIESLOCALHEAP") != null ? map.get("MAXENTRIESLOCALHEAP") : Integer.valueOf(this.cacheConfig.getCacheMaxElements()));
            eternal = map.get("ETERNAL") != null ? map.get("ETERNAL") : Boolean.valueOf(this.cacheConfig.isCacheEternal());
            if (map.get("NAME") != null) {
                name = map.get("NAME");
            }
        } else if (this.cacheConfig != null) {
            timetolive = this.cacheConfig.getCacheTimeSpan();
            idletime = this.cacheConfig.getCacheIdleTime();
            eternal = this.cacheConfig.isCacheEternal();
            maxObjects = this.cacheConfig.getCacheMaxElements();
        }
        objSettings.put((Object)"TIMETOIDLESECONDS", (Object)idletime);
        objSettings.put((Object)"TIMETOLIVESECONDS", (Object)timetolive);
        objSettings.put((Object)"ETERNAL", (Object)eternal);
        objSettings.put((Object)"MAXELEMENTSINMEMORY", maxObjects);
        objSettings.put((Object)"NAME", (Object)name);
        result.add(objSettings);
    }

    public void clearCache(String region) {
        List<String> allCaches = this.getApplicationRegionCaches(region);
        allCaches.add(region);
        for (String cache : allCaches) {
            Set<String> keys = this.getAllKeysForRegion(cache);
            if (null == keys) continue;
            for (String key : keys) {
                this.deleteKey(key);
            }
        }
    }

    private List<String> getApplicationRegionCaches(String region) {
        Enumeration appNames;
        ArrayList<String> caches = new ArrayList<String>();
        if (!this.isApplicationSpecificCache() && CacheTagHelper.isStandardCacheRegion((String)region) && (appNames = ApplicationScopeTracker.getApplicationKeys()) != null) {
            while (appNames.hasMoreElements()) {
                String cacheKey = CacheTagHelper.getCacheKey2((String)region, (String)((String)appNames.nextElement()), null, (String)this.configFilePath);
                caches.add(cacheKey);
            }
        }
        return caches;
    }

    public ArrayList getAllCacheMetadataForMonitoring(boolean server) {
        String[] regions = this.getAllCacheNames();
        ArrayList<Struct> appr = new ArrayList<Struct>();
        for (String region : regions) {
            Struct resultObj = new Struct();
            if (CacheTagHelper.skipRegionForMonitoring((String)region, (String)this.configFilePath, (String)this.applicationName, (boolean)server)) continue;
            resultObj = this.getAllCacheMetadataForMonitoring(region, server);
            appr.add(resultObj);
        }
        return appr;
    }

    private Struct getAllCacheMetadataForMonitoring(String region, boolean server) {
        Struct resultObj = new Struct();
        MemcachedClient client = this.getClient();
        String cacheKey = region;
        Object metaname = null;
        resultObj.put((Object)"APPLICATIONNAME", metaname);
        resultObj.put((Object)"ENGINE", (Object)this.getEngine());
        CacheTO xObj = new CacheTO();
        xObj.setKey(region);
        Integer hitCount = (Integer)client.get(cacheKey + ":MCSTATS_cache_hitcount");
        if (hitCount == null) {
            resultObj.put((Object)"CACHE_HITCOUNT", (Object)0);
        } else {
            resultObj.put((Object)"CACHE_HITCOUNT", (Object)hitCount);
        }
        Integer missCount = (Integer)client.get(cacheKey + ":MCSTATS_cache_misscount");
        if (missCount == null) {
            resultObj.put((Object)"CACHE_MISSCOUNT", (Object)0);
        } else {
            resultObj.put((Object)"CACHE_MISSCOUNT", (Object)missCount);
        }
        long cummSize = 0L;
        long size = 0L;
        Set<String> keys = this.getAllKeysForRegion(region);
        if (null != keys) {
            for (String key : keys) {
                if (this.isStatisticsKey(key) || this.hasKeyExpired(key)) continue;
                ++size;
                cummSize += this.getItemSize(key);
            }
        }
        resultObj.put((Object)"NUMBER", (Object)new Long(size));
        resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
        Double mc = 0.0;
        if (null != missCount) {
            mc = (double)missCount;
        }
        if (hitCount == null || Double.valueOf(hitCount.intValue()) == 0.0) {
            resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
        } else {
            resultObj.put((Object)"HITRATIO", (Object)new Double(Double.valueOf(hitCount.intValue()) / (mc + Double.valueOf(hitCount.intValue()))));
        }
        return resultObj;
    }

    public void removeCache(String cacheName) {
        if (cacheName != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)cacheName)) {
                throw new CacheExceptions.ImpicitCacheRegionDeletionException(cacheName);
            }
            MemcachedClient client = this.getClient();
            String cacheKey = CacheTagHelper.getCacheKey2((String)cacheName, (String)FusionContext.getCurrent().getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
            if (!this.cacheExists(cacheName)) {
                throw new CacheExceptions.CacheNotFoundException(cacheName);
            }
            Set cacheNames = (Set)client.get(MC_CACHE_NAMES);
            Set<String> keys = this.getAllKeysForRegion(cacheKey);
            if (null != keys) {
                for (String key : keys) {
                    this.deleteKey(key);
                }
            }
            cacheNames.remove(cacheKey);
            client.set(MC_CACHE_NAMES, 0, (Object)cacheNames);
            cacheNames.remove(cacheKey);
            client.delete(cacheName + ":MCSTATS_cache_hitcount");
            client.delete(cacheName + ":MCSTATS_cache_misscount");
        }
    }

    private void deleteKey(String key) {
        MemcachedClient client = this.getClient();
        client.delete(key);
        String region = key.split(":")[0];
        Set<String> keys = this.getAllKeysForRegion(region);
        if (null != keys) {
            keys.remove(key);
            StringBuilder sb = new StringBuilder();
            for (String s : keys) {
                sb.append(s).append(" ");
            }
            client.set(region, 0, (Object)sb.toString());
        }
    }

    public String[] getAllCacheNames() {
        MemcachedClient client = this.getClient();
        Object o = client.get(MC_CACHE_NAMES);
        if (o != null) {
            return (String[])((Set)o).stream().toArray(String[]::new);
        }
        return new String[0];
    }

    public boolean isApplicationSpecificCache() {
        return this.configFilePath != null;
    }

    private synchronized MemcachedClient getClient() {
        if (this.mcClient == null) {
            try {
                String server = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getMemcachedServer();
                ArrayList<String> servers = new ArrayList<String>();
                for (String ser : server.split(",")) {
                    servers.add(ser);
                }
                this.mcClient = new MemcachedClient(AddrUtil.getAddresses(servers));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean oneActive = false;
                for (MemcachedNode node : this.mcClient.getNodeLocator().getAll()) {
                    if (!node.isActive()) continue;
                    oneActive = true;
                    break;
                }
                if (!oneActive) {
                    this.mcClient.shutdown();
                    this.mcClient = null;
                    CFLogs.APPLICATION_LOG.error((Object)"None of the memcached server nodes are active");
                    throw new CacheExceptions.CacheInitializationException("None of the memcached server nodes are active");
                }
            }
            catch (IOException e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
                throw new CacheExceptions.CacheInitializationException(e.getMessage());
            }
        }
        return this.mcClient;
    }

    public Object getCache(String appname, String objecttype, String key) {
        return this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void initCleanupService() {
        Class<GenericMemcachedCache> clazz;
        if (cleanupService == null && !this.cacheConfig.isCacheMaxIdleLazyEviction()) {
            clazz = GenericMemcachedCache.class;
            // MONITORENTER : coldfusion.cache.memcached.GenericMemcachedCache.class
            if (cleanupService == null) {
                cleanupService = Executors.newSingleThreadScheduledExecutor();
            }
            cleanupService.scheduleAtFixedRate(this.cleanupThread, 0L, this.idletimeCheckThreadInterval, TimeUnit.SECONDS);
            // MONITOREXIT : clazz
        }
        if (refreshService != null) return;
        clazz = GenericMemcachedCache.class;
        // MONITORENTER : coldfusion.cache.memcached.GenericMemcachedCache.class
        if (refreshService == null) {
            refreshService = Executors.newSingleThreadScheduledExecutor();
        }
        refreshService.scheduleAtFixedRate(this.refreshThread, 0L, 600L, TimeUnit.SECONDS);
        // MONITOREXIT : clazz
    }

    private void removeIdleItems() {
        MemcachedClient client = this.getClient();
        Set cacheNames = (Set)client.get(MC_CACHE_NAMES);
        for (String cache : cacheNames) {
            Set<String> keys = this.getAllKeysForRegion(cache);
            if (null == keys) continue;
            Map values = client.getBulk(keys);
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                try {
                    Object o;
                    if (key.equals(MC_CACHE_NAMES) || !((o = entry.getValue()) instanceof CacheEntry)) continue;
                    this.removeIfIdleExpired(client, key);
                }
                catch (Exception e) {
                    CFLogs.APPLICATION_LOG.error((Throwable)e);
                }
            }
        }
    }

    private boolean removeIfIdleExpired(MemcachedClient client, String key) {
        CacheEntry obj = (CacheEntry)client.get(key);
        if (null == obj) {
            return false;
        }
        Long lastAccess = obj.getLastAccessTime();
        if (null == lastAccess) {
            lastAccess = obj.getLastUpdateTime();
        }
        int idleTime = obj.getIdleTime();
        if (lastAccess != null && idleTime > 0 && (System.currentTimeMillis() - lastAccess) / 1000L > (long)idleTime) {
            this.deleteKey(key);
            return true;
        }
        return false;
    }

    public void reset() {
        if (this.mcClient != null) {
            this.mcClient.flush();
            this.mcClient = null;
        }
        this.initConfig();
    }

    public String getEngine() {
        return "Memcached";
    }
}

