/*
 * Decompiled with CFR 0.152.
 */
package ice.https;

import ice.https.HttpsURLConnection;
import ice.net.HttpURLConnectionSettings;
import ice.util.Defs;
import ice.util.Settings;

public class HttpsURLConnectionSettings
extends HttpURLConnectionSettings
implements Settings {
    private static final String HTTPS_VERSION_DEFAULT = "HTTP/1.0";
    private static final String HTTPS_VERSION_KEY = "ice.net.httpsVersion";
    private Object certificateManager;

    public HttpsURLConnectionSettings() {
        this.initialize();
    }

    public HttpsURLConnectionSettings(HttpURLConnectionSettings httpUrlConnectionSettings) {
        this.initialize();
        if (httpUrlConnectionSettings != null) {
            this.setAcceptLanguageList(httpUrlConnectionSettings.getAcceptLanguageList());
            this.setAuthenticationManager(httpUrlConnectionSettings.getAuthenticationManager());
            this.setCacheManager(httpUrlConnectionSettings.getCacheManager());
            this.setConnectionManager(httpUrlConnectionSettings.getConnectionManager());
            this.setCookieManager(httpUrlConnectionSettings.getCookieManager());
            this.setMemoryManager(httpUrlConnectionSettings.getMemoryManager());
            this.setProxyResolver(httpUrlConnectionSettings.getProxyResolver());
            this.setRedirectsEnabled(httpUrlConnectionSettings.areRedirectsEnabled());
            this.setRequestHeaders(httpUrlConnectionSettings.getRequestHeaders());
            this.setRetryBrokenConnections(httpUrlConnectionSettings.shouldRetryBrokenConnections());
        }
    }

    public Object getCertificateManager() {
        return this.certificateManager;
    }

    public static String getDefaultHttpsVersion() {
        return Defs.sysProperty((String)HTTPS_VERSION_KEY, (String)HTTPS_VERSION_DEFAULT);
    }

    public void resetToDefault() {
        super.resetToDefault();
        this.certificateManager = null;
        this.initialize();
    }

    public void setCertificateManager(Object certificateManager) throws IllegalArgumentException {
        HttpsURLConnection.checkCertificateManager(certificateManager);
        this.certificateManager = certificateManager;
    }

    public static void setDefaultHttpsVersion(String httpsVersion) throws IllegalArgumentException {
        HttpsURLConnectionSettings.checkHttpVersion((String)httpsVersion);
        Defs.setSystemProperty((String)HTTPS_VERSION_KEY, (String)httpsVersion);
    }

    private void initialize() {
        this.httpVersion = HttpsURLConnectionSettings.getDefaultHttpsVersion();
    }
}

