/*
 * Decompiled with CFR 0.152.
 */
package ice.https;

import ice.debug.Debug;
import ice.https.HttpsURLConnectionSettings;
import ice.net.Authentication;
import ice.net.HttpRequest;
import ice.net.HttpURLConnection;
import ice.net.HttpURLConnectionSettings;
import ice.net.proxy.Proxy;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.net.HeaderMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Vector;

public class HttpsURLConnection
extends HttpURLConnection {
    protected static HttpsURLConnectionSettings FALLBACK_HTTPS_URL_CONNECTION_SETTINGS;
    private static Class certificateManagerClass;
    private static Class sslSocketClass;
    private static Constructor sslSocketConstructor;
    protected Object certificateManager;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$InetAddress;

    public HttpsURLConnection(URL url) {
        this(url, FALLBACK_HTTPS_URL_CONNECTION_SETTINGS);
    }

    public HttpsURLConnection(URL url, HttpURLConnectionSettings httpUrlConnectionSettings) {
        super(url, httpUrlConnectionSettings);
    }

    public HttpsURLConnection(URL url, HttpsURLConnectionSettings httpsUrlConnectionSettings) {
        super(url, (HttpURLConnectionSettings)httpsUrlConnectionSettings);
        this.setInstanceCertificateManager(httpsUrlConnectionSettings.getCertificateManager());
    }

    public static Object getGlobalCertificateManager() {
        return FALLBACK_HTTPS_URL_CONNECTION_SETTINGS.getCertificateManager();
    }

    public Object getInstanceCertificateManager() {
        return this.certificateManager;
    }

    public static void setGlobalCertificateManager(Object certificateManager) throws IllegalArgumentException {
        FALLBACK_HTTPS_URL_CONNECTION_SETTINGS.setCertificateManager(certificateManager);
    }

    public void setInstanceCertificateManager(Object certificateManager) throws IllegalArgumentException {
        HttpsURLConnection.checkCertificateManager(certificateManager);
        this.certificateManager = certificateManager;
    }

    protected static void checkCertificateManager(Object certificateManager) throws IllegalArgumentException {
        if (certificateManager != null && !certificateManagerClass.isInstance(certificateManager)) {
            throw new IllegalArgumentException("certificateManager is not an instance of ice.ssl.CertificateManager");
        }
    }

    protected Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        Socket _socket = null;
        Proxy _proxy = this.getProxy();
        if (_proxy != null) {
            _socket = new Socket(inetAddress, port);
            InputStream _inputStream = _socket.getInputStream();
            OutputStream _outputStream = _socket.getOutputStream();
            int _port = this.url.getPort();
            if (_port == -1) {
                _port = this.getDefaultPort();
            }
            boolean _validConnection = false;
            while (!_validConnection) {
                String _statusLine;
                HttpRequest _httpRequest = new HttpRequest("CONNECT", this.url.getHost() + ":" + _port, "HTTP/1.0");
                _httpRequest.putHeader("Connection", "keep-alive");
                Authentication _proxyAuthentication = _proxy.getAuthentication();
                if (_proxyAuthentication != null) {
                    _httpRequest.putHeader("Proxy-Authorization", _proxyAuthentication.getAuthString());
                }
                _outputStream.write(_httpRequest.getBytes());
                StringBuffer _stringBuffer = new StringBuffer();
                try {
                    while (true) {
                        char _char = (char)_inputStream.read();
                        _stringBuffer.append(_char);
                        if (_char == '\uffffffff') break;
                        if (_char != '\r') continue;
                        _char = (char)_inputStream.read();
                        _stringBuffer.append(_char);
                        if (_char == '\uffffffff') break;
                        if (_char != '\n') continue;
                        _char = (char)_inputStream.read();
                        _stringBuffer.append(_char);
                        if (_char == '\uffffffff') break;
                        if (_char != '\r') continue;
                        _char = (char)_inputStream.read();
                        _stringBuffer.append(_char);
                        if (_char == '\uffffffff' || _char == '\n') break;
                    }
                }
                catch (OutOfMemoryError error) {
                    continue;
                }
                String _httpResponse = _stringBuffer.toString();
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.requestHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                    Debug.trace((String)("HTTP request:\r\n" + _httpRequest.getMessage()));
                }
                if (Defs.sysPropertyBoolean((String)"ice.net.debug.responseHeaders", (boolean)false) || Defs.sysPropertyBoolean((String)"ice.net.debug.all", (boolean)false)) {
                    Debug.trace((String)("HTTP response:\r\n" + _httpResponse));
                }
                if ((_statusLine = _httpResponse.substring(0, _httpResponse.indexOf("\r\n"))).indexOf(Integer.toString(200)) != -1) {
                    if (_proxyAuthentication != null) {
                        if (!_proxyAuthentication.isConfirmed()) {
                            _proxyAuthentication.setConfirmed(true);
                        }
                        if (_proxyAuthentication.isVolatile()) {
                            _proxy.setAuthentication(null);
                        }
                    }
                    _validConnection = true;
                    continue;
                }
                if (_statusLine.indexOf(Integer.toString(403)) != -1) {
                    _socket.close();
                    break;
                }
                if (_statusLine.indexOf(Integer.toString(407)) == -1) continue;
                Vector<HeaderMap.Header> _proxyAuthenticateList = new Vector<HeaderMap.Header>();
                int _index = 0;
                int _beginIndex = 0;
                int _endIndex = 0;
                while ((_index = _httpResponse.indexOf("Proxy-Authenticate", _endIndex)) != -1) {
                    _beginIndex = _httpResponse.indexOf(":", _index);
                    _endIndex = _httpResponse.indexOf("\r\n", _beginIndex);
                    _proxyAuthenticateList.add(new HeaderMap.Header("Proxy-Authenticate", _httpResponse.substring(_beginIndex + 1, _endIndex).trim()));
                }
                Object[] _proxyAuthenticateHeaders = new HeaderMap.Header[_proxyAuthenticateList.size()];
                _proxyAuthenticateList.copyInto(_proxyAuthenticateHeaders);
                Authentication _tempAuthentication = null;
                Authentication _badProxyAuthentication = _proxy.getAuthentication();
                try {
                    _proxyAuthentication = _tempAuthentication = this.authenticationManager.extractAuthentication(new URL(_proxy.getProtocol(), _proxy.getHost(), _proxy.getPort(), "/"), null, (HeaderMap.Header[])_proxyAuthenticateHeaders);
                }
                catch (MalformedURLException exception) {
                    Debug.ex((Throwable)exception);
                }
                if (_proxyAuthentication != null) {
                    _proxy.setAuthentication(_proxyAuthentication);
                }
                if (_badProxyAuthentication != null && !_badProxyAuthentication.isConfirmed() && !_badProxyAuthentication.inProgress()) {
                    this.authenticationManager.removeBadAuthentication(_badProxyAuthentication);
                    _proxy.setAuthentication(null);
                }
                if (_tempAuthentication != null && !_tempAuthentication.giveUp()) {
                    boolean _keepAlive = false;
                    _beginIndex = _httpResponse.indexOf("Connection");
                    if (_beginIndex != -1) {
                        _endIndex = _httpResponse.indexOf("\r\n", _beginIndex);
                        boolean bl = _keepAlive = _httpResponse.substring(_beginIndex, _endIndex).toLowerCase().indexOf("Keep-Alive".toLowerCase()) != -1;
                    }
                    if (!_keepAlive && (_beginIndex = _httpResponse.indexOf("Proxy-Connection")) != -1) {
                        _endIndex = _httpResponse.indexOf("\r\n", _beginIndex);
                        boolean bl = _keepAlive = _httpResponse.substring(_beginIndex, _endIndex).toLowerCase().indexOf("Keep-Alive".toLowerCase()) != -1;
                    }
                    if (!_keepAlive) {
                        _socket = new Socket(inetAddress, port);
                        _inputStream = _socket.getInputStream();
                        _outputStream = _socket.getOutputStream();
                        continue;
                    }
                    _beginIndex = _httpResponse.indexOf("Content-Length");
                    if (_beginIndex != -1) {
                        _endIndex = _httpResponse.indexOf("\r\n", _beginIndex);
                        int _contentLength = Integer.parseInt(_httpResponse.substring(_httpResponse.indexOf(":", _beginIndex) + 1, _endIndex).trim());
                        byte[] _bytes = new byte[4096];
                        for (int _bytesRead = 0; _bytesRead != _contentLength; _bytesRead += _inputStream.read(_bytes, 0, Math.min(_contentLength - _bytesRead, _bytes.length))) {
                        }
                        continue;
                    }
                    _inputStream.read(new byte[_inputStream.available()]);
                    continue;
                }
                if (_tempAuthentication != null) {
                    this.authenticationManager.removeAuthentication(_tempAuthentication);
                    if (_tempAuthentication.isProxyAuth()) {
                        _proxy.setAuthentication(null);
                    }
                }
                _validConnection = true;
            }
            _socket = this.getSocketTunnel(_socket, this.getURL().getHost());
        } else {
            _socket = this.getSocket(inetAddress, port);
        }
        this.setCertificateManager(_socket);
        _socket.setSoTimeout(this.connectionManager.getSoTimeout());
        _socket.setTcpNoDelay(!this.connectionManager.isNagleEnabled());
        return _socket;
    }

    protected int getDefaultPort() {
        return 443;
    }

    protected Socket getSocket(InetAddress inetAddress, int port) throws IOException {
        Socket _socket = null;
        Constructor _constructor = this.getSSLSocketConstructor();
        if (_constructor != null) {
            Object[] _arguments = new Object[]{inetAddress, new Integer(port)};
            try {
                _socket = (Socket)_constructor.newInstance(_arguments);
            }
            catch (InvocationTargetException exception) {
                throw (IOException)exception.getTargetException();
            }
            catch (Exception exception) {
                Debug.ex((Throwable)exception);
                throw new ICEException(1, 3, 8);
            }
        }
        return _socket;
    }

    protected Socket getSocketTunnel(Socket socket, String host) throws IOException {
        Socket _socket = null;
        if (sslSocketClass != null) {
            Class[] _parameterTypes = new Class[]{class$java$net$Socket == null ? (class$java$net$Socket = HttpsURLConnection.class$("java.net.Socket")) : class$java$net$Socket, class$java$lang$String == null ? (class$java$lang$String = HttpsURLConnection.class$("java.lang.String")) : class$java$lang$String};
            Object[] _arguments = new Object[]{socket, host};
            try {
                _socket = (Socket)sslSocketClass.getConstructor(_parameterTypes).newInstance(_arguments);
            }
            catch (Exception exception) {
                throw new ICEException(1, 3, 8);
            }
        }
        return _socket;
    }

    private Constructor getSSLSocketConstructor() {
        if (sslSocketConstructor == null && sslSocketClass != null) {
            try {
                sslSocketConstructor = sslSocketClass.getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = HttpsURLConnection.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE);
            }
            catch (NoSuchMethodException exception) {
                Debug.ex((Throwable)exception);
            }
        }
        return sslSocketConstructor;
    }

    private void setCertificateManager(Socket socket) {
        if (this.certificateManager != null && sslSocketClass != null) {
            try {
                Defs.getMethod((Class)sslSocketClass, (String)"setCertificateManager", (Class[])new Class[]{certificateManagerClass}).invoke((Object)socket, this.certificateManager);
            }
            catch (IllegalAccessException exception) {
                Debug.ex((Throwable)exception);
            }
            catch (InvocationTargetException exception) {
                Debug.ex((Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            certificateManagerClass = Class.forName("ice.ssl.CertificateManager");
            sslSocketClass = Class.forName("ice.ssl.SSLSocket");
        }
        catch (ClassNotFoundException exception) {
            Debug.ex((Throwable)exception);
        }
        FALLBACK_HTTPS_URL_CONNECTION_SETTINGS = new HttpsURLConnectionSettings(FALLBACK_HTTP_URL_CONNECTION_SETTINGS);
        FALLBACK_HTTP_URL_CONNECTION_SETTINGS = FALLBACK_HTTPS_URL_CONNECTION_SETTINGS;
    }
}

