/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.sun.star.lib.loader.InstallationFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Loader {
    private static ClassLoader m_Loader = null;

    private Loader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        Object object;
        Serializable serializable;
        String[] stringArray2;
        String string = null;
        Class<Loader> clazz = Loader.class;
        ClassLoader classLoader = clazz.getClassLoader();
        Vector<URL> vector = new Vector<URL>();
        try {
            stringArray2 = classLoader.getResources("META-INF/MANIFEST.MF");
            while (stringArray2.hasMoreElements()) {
                vector.add(stringArray2.nextElement());
            }
            for (int i = vector.size() - 1; i >= 0; --i) {
                serializable = (URL)vector.elementAt(i);
                try {
                    object = (JarURLConnection)((URL)serializable).openConnection();
                    Manifest manifest = ((JarURLConnection)object).getManifest();
                    Attributes attributes = manifest.getAttributes("com/sun/star/lib/loader/Loader.class");
                    if (attributes == null || (string = attributes.getValue("Application-Class")) == null) continue;
                    break;
                }
                catch (IOException iOException) {
                    System.err.println("com.sun.star.lib.loader.Loader::main: bad manifest file: " + iOException);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("com.sun.star.lib.loader.Loader::main: cannot get manifest resources: " + iOException);
        }
        if (string == null) {
            if (stringArray.length <= 0) throw new IllegalArgumentException("The name of the class to be loaded must be either specified in the Main-Class attribute of the com/sun/star/lib/loader/Loader.class entry of the manifest file or as a command line argument.");
            string = stringArray[0];
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        } else {
            stringArray2 = stringArray;
        }
        if (string == null) return;
        ClassLoader classLoader2 = Loader.getCustomLoader();
        Thread.currentThread().setContextClassLoader(classLoader2);
        serializable = classLoader2.loadClass(string);
        object = ((Class)serializable).getMethod("main", String[].class);
        ((Method)object).invoke(null, new Object[]{stringArray2});
    }

    public static synchronized ClassLoader getCustomLoader() {
        if (m_Loader == null) {
            URL[] uRLArray;
            String string;
            Vector<URL> vector = new Vector<URL>();
            String string2 = null;
            try {
                string2 = System.getProperty("java.class.path");
            }
            catch (SecurityException securityException) {
                System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: cannot get system property java.class.path: " + securityException);
            }
            if (string2 != null) {
                Loader.addUrls(vector, string2, File.pathSeparator);
            }
            if ((string = InstallationFinder.getPath()) != null) {
                uRLArray = new File(string, "classes");
                File file = new File((File)uRLArray, "juh.jar");
                if (file.exists()) {
                    URL[] uRLArray2 = new URL[1];
                    try {
                        uRLArray2[0] = file.toURL();
                        CustomURLClassLoader customURLClassLoader = new CustomURLClassLoader(uRLArray2);
                        Class<?> clazz = customURLClassLoader.loadClass("com.sun.star.comp.helper.UnoInfo");
                        Method method = clazz.getMethod("getJars", null);
                        URL[] uRLArray3 = (URL[])method.invoke(null, (Object[])null);
                        for (int i = 0; i < uRLArray3.length; ++i) {
                            vector.add(uRLArray3[i]);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: cannot add UNO jar files: " + malformedURLException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: cannot add UNO jar files: " + classNotFoundException);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: cannot add UNO jar files: " + noSuchMethodException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: cannot add UNO jar files: " + illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: cannot add UNO jar files: " + invocationTargetException);
                    }
                } else {
                    Loader.callUnoinfo(string, vector);
                }
            } else {
                System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: no UNO installation found!");
            }
            uRLArray = new URL[vector.size()];
            vector.toArray(uRLArray);
            m_Loader = new CustomURLClassLoader(uRLArray);
        }
        return m_Loader;
    }

    private static void addUrls(Vector vector, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                vector.add(new File(stringTokenizer.nextToken()).toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: bad pathname: " + malformedURLException);
            }
        }
    }

    private static void callUnoinfo(String string, Vector vector) {
        String string2;
        int n;
        int n2;
        Process process;
        try {
            process = Runtime.getRuntime().exec(new String[]{new File(string, "unoinfo").getPath(), "java"});
        }
        catch (IOException iOException) {
            System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: exec unoinfo: " + iOException);
            return;
        }
        new Drain(process.getErrorStream()).start();
        byte[] byArray = new byte[1000];
        int n3 = 0;
        try {
            InputStream inputStream = process.getInputStream();
            n2 = inputStream.read();
            while (true) {
                int n4;
                if (n3 == byArray.length) {
                    if (n3 > 0x3FFFFFFF) {
                        System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: too much unoinfo output");
                        return;
                    }
                    byte[] byArray2 = new byte[2 * n3];
                    for (int i = 0; i < n3; ++i) {
                        byArray2[i] = byArray[i];
                    }
                    byArray = byArray2;
                }
                if ((n4 = inputStream.read(byArray, n3, byArray.length - n3)) != -1) {
                    n3 += n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: reading unoinfo output: " + iOException);
            return;
        }
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: waiting for unoinfo: " + interruptedException);
            return;
        }
        if (n != 0) {
            System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: unoinfo exit value " + n3);
            return;
        }
        if (n2 == 48) {
            string2 = new String(byArray);
        } else if (n2 == 49) {
            try {
                string2 = new String(byArray, "UTF-16LE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: transforming unoinfo output: " + unsupportedEncodingException);
                return;
            }
        } else {
            System.err.println("com.sun.star.lib.loader.Loader::getCustomLoader: bad unoinfo output");
            return;
        }
        Loader.addUrls(vector, string2, "\u0000");
    }

    private static final class CustomURLClassLoader
    extends URLClassLoader {
        public CustomURLClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            throw new ClassNotFoundException(string);
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    clazz = super.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return super.loadClass(string, bl);
                }
                catch (SecurityException securityException) {
                    return super.loadClass(string, bl);
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private static final class Drain
    extends Thread {
        private final InputStream stream;

        public Drain(InputStream inputStream) {
            super("unoinfo stderr drain");
            this.stream = inputStream;
        }

        public void run() {
            try {
                while (this.stream.read() != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

